/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.lookup;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.SsoDomainFinder;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.util.Optional;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.impl.LookupServiceLocator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LookupUtil {
    private static final Log _logger = LogFactory.getLog(LookupUtil.class);
    public static final String PRODUCT_CIS = "com.vmware.cis";
    public static final String PRODUCT_SMS = "com.vmware.vim.sms";
    public static final String PRODUCT_PBM = "com.vmware.vim.pbm";
    public static final String TYPE_VCENTER = "vcenterserver";
    public static final String TYPE_IS = "cs.inventory";
    public static final String TYPE_LICENSE = "cs.license";
    public static final String TYPE_SSO = "cs.identity";
    public static final String TYPE_SMS = "sms";
    public static final String TYPE_SCA = "sca";
    public static final String CAPABILITY_NAME__VC_TRUSTS = "VC-trusts";
    public static final String TYPE_H5C = "vsphereui";
    public static final String HOST_ID_ATTRIBUTE_KEY = "com.vmware.cis.cm.HostId";
    public static final String CIS_COMMON_EP_URL = "cis.common.ep.localurl";
    public static final String VAPI_JSON_HTTPS_PROTOCOL = "vapi.json.https";
    public static final String VAPI_JSON_HTTP_PROTOCOL = "vapi.json.http";
    public static final String SRS_SERVICE_PRODUCT_ID = "com.vmware.cis";
    public static final String SRS_SERVICE_TYPE_ID = "cs.perfcharts";
    public static final String SRS_ENTRY_ENDPOINT_PROTOCOL = "http";
    public static final String SRS_ENTRY_ENDPOINT_TYPE_ID = "com.vmware.perfcharts.entry.url";
    public static final String SCA_VMOMI_PROTOCOL = "vmomi";
    public static final String SCA_ENDPOINT_TYPE_ID = "com.vmware.cis.sca";
    public static final ServiceRegistration.ServiceType VCENTER = new ServiceRegistration.ServiceType("com.vmware.cis", "vcenterserver");
    public static final ServiceRegistration.ServiceType SSO = new ServiceRegistration.ServiceType("com.vmware.cis", "cs.identity");
    public static final ServiceRegistration.ServiceType LICENSE = new ServiceRegistration.ServiceType("com.vmware.cis", "cs.license");
    public static final ServiceRegistration.ServiceType IS = new ServiceRegistration.ServiceType("com.vmware.cis", "cs.inventory");
    public static final String LS_SERVICE_ATTR__DOMAIN_ID = "domainId";
    public static final String LS_SERVICE_ATTR__DOMAIN_NAME = "domainName";
    public static final String LS_SERVICE_ATTR__DOMAIN_TYPE = "domainType";
    public static final ServiceRegistration.ServiceType SMS = new ServiceRegistration.ServiceType("com.vmware.vim.sms", "sms");
    public static final ServiceRegistration.ServiceType H5C = new ServiceRegistration.ServiceType("com.vmware.vim.sms", "sms");

    private LookupUtil() {
    }

    public static ServiceRegistration.Info[] find(@Nonnull LookupService lookupService, @Nonnull ServiceRegistration.ServiceType serviceType) {
        return LookupUtil.find(lookupService, serviceType, null);
    }

    public static ServiceRegistration.Info[] find(@Nonnull LookupService lookupService, @Nonnull ServiceRegistration.ServiceType serviceType, @Nullable ServiceRegistration.EndpointType endpointType) {
        Validate.notNull((Object)serviceType);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Fetching services from LookupService of type " + serviceType.getType()));
        }
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setServiceType(serviceType);
        if (endpointType != null) {
            filter.setEndpointType(endpointType);
        }
        filter.setSearchAllSsoDomains(Boolean.valueOf(true));
        ServiceRegistration.Info[] infoArray = lookupService.getServiceRegistrationInfos(filter);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Fetched services from LookupService of type " + serviceType.getType()));
        }
        return infoArray;
    }

    public static ServiceRegistration.Endpoint getEndpoint(@Nonnull ServiceRegistration.Info info, @Nonnull String string) {
        if (info.getServiceEndpoints() == null) {
            return null;
        }
        for (ServiceRegistration.Endpoint endpoint : info.getServiceEndpoints()) {
            if (!string.equals(endpoint.getEndpointType().getType())) continue;
            return endpoint;
        }
        return null;
    }

    public static String getServiceHostId(ServiceRegistration.Info info) {
        return LookupUtil.getServiceAttribute(info, HOST_ID_ATTRIBUTE_KEY);
    }

    public static String getServiceAttribute(ServiceRegistration.Info info, String string) {
        if (info != null && info.getServiceAttributes() != null) {
            for (ServiceRegistration.Attribute attribute : info.getServiceAttributes()) {
                if (!string.equals(attribute.getKey()) || attribute.getValue() == null) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public static String getLocalHostLduGuid(LookupService lookupService) {
        LookupServiceLocator lookupServiceLocator = lookupService.getLocator();
        if (lookupServiceLocator != null) {
            return lookupServiceLocator.getLocalHostLduGuid();
        }
        return null;
    }

    public static String getLocalHostId(LookupService lookupService) {
        LookupServiceLocator lookupServiceLocator = lookupService.getLocator();
        if (lookupServiceLocator != null) {
            return lookupServiceLocator.getLocalHostId();
        }
        return null;
    }

    static Optional<SsoDomainFinder.SsoDomainData> getSsoDomainData(@Nonnull ServiceRegistration.Info info) {
        Validate.notNull((Object)info);
        String string = LookupUtil.getServiceAttribute(info, LS_SERVICE_ATTR__DOMAIN_ID);
        if (string == null) {
            return Optional.empty();
        }
        String string2 = LookupUtil.getServiceAttribute(info, LS_SERVICE_ATTR__DOMAIN_NAME);
        SsoDomainFinder.SsoDomainData ssoDomainData = new SsoDomainFinder.SsoDomainData(string, string2);
        return Optional.of((Object)ssoDomainData);
    }

    public static Optional<SsoDomain> getSsoDomain(@Nonnull ServiceRegistration.Info info) {
        SsoDomainFinder.SsoDomainData ssoDomainData = (SsoDomainFinder.SsoDomainData)LookupUtil.getSsoDomainData(info).orElse(null);
        if (ssoDomainData == null) {
            return Optional.empty();
        }
        SsoDomain ssoDomain = SsoDomain.valueOf((String)ssoDomainData.getId(), (String)ssoDomainData.getName());
        return Optional.of((Object)ssoDomain);
    }

    @Nonnull
    public static Set<String> parseCapabilities(@Nullable String string) {
        if (string == null) {
            return Collections.emptySet();
        }
        String[] stringArray = string.split(",");
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (String string2 : stringArray) {
            if (StringUtil.isNullOrWhitespace((String)string2)) {
                _logger.warn((Object)("Found an empty capability: " + string));
                continue;
            }
            hashSet.add(string2);
        }
        if (hashSet.isEmpty()) {
            return Collections.emptySet();
        }
        return hashSet;
    }
}

