/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.lookup.impl;

import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.directory.extensions.DirectoryExtensionManagerProvider;
import com.vmware.vise.vim.lookup.LookupService;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LookupServiceExtensionManagerProvider
implements DirectoryExtensionManagerProvider {
    private final Log _logger = LogFactory.getLog(this.getClass());
    private final LookupService _lookupService;
    private final String _localExtensionType;
    private final String _remoteExtensionType;

    public LookupServiceExtensionManagerProvider(@Nonnull LookupService lookupService, @Nonnull String string, @Nonnull String string2, @Nonnull FeatureStateService featureStateService) {
        Validate.notNull((Object)lookupService);
        Validate.notNull((Object)string);
        Validate.notNull((Object)string2);
        Validate.notNull((Object)featureStateService);
        this._lookupService = lookupService;
        this._localExtensionType = string;
        this._remoteExtensionType = string2;
    }

    @Override
    public Collection<DirectoryExtensionManagerProvider.DirectoryPackageInfo> discoverPackages() {
        Collection<DirectoryExtensionManagerProvider.DirectoryPackageInfo> collection = this.discoverPackagesByEndpointType(this._localExtensionType);
        if (BuildProperties.isH5Client()) {
            Collection<DirectoryExtensionManagerProvider.DirectoryPackageInfo> collection2 = this.discoverPackagesByEndpointType(this._remoteExtensionType);
            collection.addAll(collection2);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<DirectoryExtensionManagerProvider.DirectoryPackageInfo> discoverPackagesByEndpointType(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            List<DirectoryExtensionManagerProvider.DirectoryPackageInfo> list;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ServiceRegistration.Info[] infoArray = this._lookupService.getServiceRegistrationInfos(LookupServiceExtensionManagerProvider.buildFilter(string));
            List<DirectoryExtensionManagerProvider.DirectoryPackageInfo> list2 = list = this.getPackages(infoArray);
            return list2;
        }
        catch (InvalidArgument | SecurityError throwable) {
            this._logger.error((Object)"Error when fetching NGC plugins from LookupService (SSO may be disabled).", throwable);
            List<DirectoryExtensionManagerProvider.DirectoryPackageInfo> list = Collections.emptyList();
            return list;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static ServiceRegistration.Filter buildFilter(String string) {
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.endpointType = new ServiceRegistration.EndpointType();
        filter.endpointType.protocol = ServiceEndpoint.EndpointProtocol.http.toString();
        filter.endpointType.type = string;
        return filter;
    }

    private List<DirectoryExtensionManagerProvider.DirectoryPackageInfo> getPackages(ServiceRegistration.Info[] infoArray) {
        ArrayList<DirectoryExtensionManagerProvider.DirectoryPackageInfo> arrayList = new ArrayList<DirectoryExtensionManagerProvider.DirectoryPackageInfo>();
        if (infoArray == null || infoArray.length == 0) {
            return arrayList;
        }
        for (ServiceRegistration.Info info : infoArray) {
            if (info.getServiceEndpoints() == null || info.getServiceEndpoints().length == 0) continue;
            ServiceRegistration.ServiceType serviceType = info.getServiceType();
            if (serviceType == null) {
                this._logger.warn((Object)("Lookup service extension '" + info.getServiceId() + "' has empty service type, skip."));
                continue;
            }
            for (ServiceRegistration.Endpoint endpoint : info.getServiceEndpoints()) {
                String string;
                ServiceRegistration.EndpointType endpointType = endpoint.getEndpointType();
                if (endpointType == null || !this._remoteExtensionType.equals(string = endpointType.getType()) && !this._localExtensionType.equals(string)) continue;
                DirectoryExtensionManagerProvider.DirectoryPackageInfo directoryPackageInfo = this.buildPackageInfo(info, endpoint);
                arrayList.add(directoryPackageInfo);
            }
        }
        return arrayList;
    }

    private DirectoryExtensionManagerProvider.DirectoryPackageInfo buildPackageInfo(ServiceRegistration.Info info, ServiceRegistration.Endpoint endpoint) {
        DirectoryExtensionManagerProvider.DirectoryPackageInfo directoryPackageInfo = new DirectoryExtensionManagerProvider.DirectoryPackageInfo();
        ServiceRegistration.ServiceType serviceType = info.getServiceType();
        String string = serviceType.getProduct() + "." + serviceType.getType();
        directoryPackageInfo.setId(string);
        directoryPackageInfo.setVersion(info.getServiceVersion());
        directoryPackageInfo.setName(info.getServiceNameResourceKey());
        directoryPackageInfo.setDescription(info.getServiceDescriptionResourceKey());
        directoryPackageInfo.setVendor(info.getVendorNameResourceKey());
        boolean bl = this._remoteExtensionType.equals(endpoint.getEndpointType().getType());
        directoryPackageInfo.setRemotePlugin(bl);
        directoryPackageInfo.url = endpoint.getUrl().toString();
        if (endpoint.getSslTrust() != null && endpoint.getSslTrust().length > 0) {
            String string2;
            directoryPackageInfo.certificate = string2 = endpoint.getSslTrust()[0];
            if (string2 != null) {
                try {
                    String string3 = CertificateUtil.getThumbprint((String)string2);
                    directoryPackageInfo.setSslThumbprints(new String[]{string3});
                }
                catch (UnsupportedEncodingException | NoSuchAlgorithmException | CertificateException exception) {
                    this._logger.warn((Object)"Fail to get certificate thumbprint", (Throwable)exception);
                }
            }
        }
        directoryPackageInfo.serviceInstance = info.getServiceId();
        return directoryPackageInfo;
    }
}

