/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso;

import com.google.common.collect.ImmutableSet;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.sso.version.version3_5;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.connections.SiteAffinityServerEndpointProvider;
import com.vmware.vise.vim.security.sso.StsServerInfo;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public final class SsoServerInfo {
    private static final String WEBSSO_URL_PATTERN = "/websso/SAML2/SSOSSL?RelyingPartyEntityId=";
    private static final String SCHEME_END = "://";
    private static final String PORT_DELIMETER = ":";
    private final SsoDomain _ssoDomain;
    private final String _primaryAdminAppUrl;
    private final String _primaryStsUrl;
    private final boolean _primaryStsHasVcTrustsCapability;
    private final KeyStore _keyStore;
    private final X509Certificate _stsSslCertificate;
    private final X509Certificate _adminAppSslCertificate;
    private final X509Certificate _metadataSslCertificate;
    private final String _primaryMetadataUrl;
    private final Class<?> _vmodlVersion;
    private final URI _primaryStsUri;
    private final Set<String> _allAdminAppUrls;
    private final Set<StsServerInfo> _allStsServerInfos;
    private final Set<String> _allMetadataUrls;

    private SsoServerInfo(Builder builder) {
        Validate.notNull((Object)builder.ssoDomain);
        this._ssoDomain = builder.ssoDomain;
        this._primaryAdminAppUrl = builder.adminAppUrl;
        this._primaryStsUrl = builder.stsUrl;
        this._primaryStsUri = this._primaryStsUrl != null ? URI.create(this._primaryStsUrl) : null;
        this._primaryStsHasVcTrustsCapability = builder.stsHasVcTrustsCapability;
        this._keyStore = builder.keyStore;
        this._stsSslCertificate = builder._stsSslCertificate;
        this._adminAppSslCertificate = builder._adminAppSslCertificate;
        this._metadataSslCertificate = builder._metadataSslCertificate;
        this._primaryMetadataUrl = builder.metadataUrl;
        this._vmodlVersion = builder.vmodlVersion != null ? builder.vmodlVersion : version3_5.class;
        this._allAdminAppUrls = builder.allAdminAppUrls != null && builder.allAdminAppUrls.size() > 0 ? ImmutableSet.copyOf(builder.allAdminAppUrls) : Collections.singleton(this._primaryAdminAppUrl);
        this._allStsServerInfos = builder.allStsServerInfos != null && builder.allStsServerInfos.size() > 0 ? ImmutableSet.copyOf(builder.allStsServerInfos) : Collections.emptySet();
        this._allMetadataUrls = builder.allMetadataUrls != null && builder.allMetadataUrls.size() > 0 ? ImmutableSet.copyOf(builder.allMetadataUrls) : Collections.singleton(this._primaryMetadataUrl);
    }

    public SsoDomain getSsoDomain() {
        return this._ssoDomain;
    }

    public String getAdminAppUrl() {
        return this._primaryAdminAppUrl;
    }

    public Set<String> getAllAdminAppUrls() {
        return this._allAdminAppUrls;
    }

    public String getMetadataUrl() {
        return this._primaryMetadataUrl;
    }

    public Set<String> getAllMetadataUrls() {
        return this._allMetadataUrls;
    }

    public String getStsUrl() {
        return this._primaryStsUrl;
    }

    public Set<StsServerInfo> getAllStsServerInfos() {
        return this._allStsServerInfos;
    }

    public URI getStsUri() {
        return this._primaryStsUri;
    }

    public boolean stsHasVcTrustsCapability() {
        return this._primaryStsHasVcTrustsCapability;
    }

    public KeyStore getKeyStore() {
        return this._keyStore;
    }

    public X509Certificate getSslCertificate() {
        return this.getStsSslCertificate();
    }

    public X509Certificate getStsSslCertificate() {
        return this._stsSslCertificate;
    }

    public X509Certificate getAdminAppSslCertificate() {
        return this._adminAppSslCertificate;
    }

    public X509Certificate getMetadataSslCertificate() {
        return this._metadataSslCertificate;
    }

    public Class<?> getVmodlVersion() {
        return this._vmodlVersion;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SsoServerInfo)) {
            return false;
        }
        SsoServerInfo ssoServerInfo = (SsoServerInfo)object;
        return StringUtils.equals((String)this._primaryStsUrl, (String)ssoServerInfo.getStsUrl());
    }

    public String getWebSsoAddress(String string) throws MalformedURLException, URISyntaxException {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.getMetadataUrl();
        URL uRL = new URL(string2);
        SiteAffinityServerEndpointProvider siteAffinityServerEndpointProvider = new SiteAffinityServerEndpointProvider(SsoDomain.getLocal(), uRL.toURI());
        String string3 = siteAffinityServerEndpointProvider.getServerEndpoint().getHost();
        stringBuilder.append(uRL.getProtocol()).append(SCHEME_END);
        stringBuilder.append(string3);
        if (uRL.getPort() != -1) {
            stringBuilder.append(PORT_DELIMETER).append(uRL.getPort());
        }
        stringBuilder.append(WEBSSO_URL_PATTERN).append(string);
        return stringBuilder.toString();
    }

    public String toString() {
        return "adminAppUrl: " + this._primaryAdminAppUrl + ", stsUrl: " + this._primaryStsUrl + ", metadataUrl: " + this._primaryMetadataUrl + ", vmodlVersion: " + this._vmodlVersion;
    }

    public String toExtendedString() {
        return this.toString() + ", allStsServerInfos: " + this._allStsServerInfos + ", allAdminAppUrls: " + this._allAdminAppUrls + ", allMetadataUrls: " + this._allMetadataUrls;
    }

    public static class Builder {
        private static final String METADATA_PATH = "/websso/SAML2/Metadata";
        private static final String STS_PATH = "/sts/STSService";
        public SsoDomain ssoDomain;
        public String adminAppUrl;
        public String stsUrl;
        public boolean stsHasVcTrustsCapability;
        public KeyStore keyStore;
        public String metadataUrl;
        public Class<?> vmodlVersion;
        public String adminAppSslTrust;
        public String stsSslTrust;
        public String metadataSslTrust;
        public Set<String> allAdminAppUrls;
        public Set<StsServerInfo> allStsServerInfos;
        public Set<String> allMetadataUrls;
        private X509Certificate _adminAppSslCertificate;
        private X509Certificate _stsSslCertificate;
        private X509Certificate _metadataSslCertificate;

        public Builder ssoDomain(SsoDomain ssoDomain) {
            Validate.notNull((Object)ssoDomain);
            this.ssoDomain = ssoDomain;
            return this;
        }

        public Builder addEndpoints(@Nullable ServiceRegistration.Endpoint[] endpointArray, @Nullable Set<String> set) {
            if (endpointArray == null || endpointArray.length == 0) {
                return this;
            }
            block10: for (ServiceRegistration.Endpoint endpoint : endpointArray) {
                String string;
                switch (string = endpoint.getEndpointType().getType()) {
                    case "com.vmware.cis.cs.identity.admin": {
                        URI uRI = endpoint.getUrl();
                        if (uRI == null) continue block10;
                        if (this.adminAppUrl == null) {
                            this.adminAppUrl = uRI.toString();
                            this.adminAppSslTrust = endpoint.getSslTrust()[0];
                        }
                        if (this.allAdminAppUrls == null) {
                            this.allAdminAppUrls = new LinkedHashSet<String>();
                        }
                        this.allAdminAppUrls.add(this.adminAppUrl);
                        continue block10;
                    }
                    case "com.vmware.cis.cs.identity.sso": {
                        URI uRI = endpoint.getUrl();
                        if (uRI == null) continue block10;
                        String string2 = endpoint.getSslTrust()[0];
                        if (this.stsUrl == null) {
                            this.stsUrl = uRI.toString();
                            this.stsSslTrust = string2;
                            this.stsHasVcTrustsCapability = set.contains("VC-trusts");
                        }
                        StsServerInfo stsServerInfo = StsServerInfo.builder(uRI).sslTrust(string2).capabilities(set).build();
                        if (this.allStsServerInfos == null) {
                            this.allStsServerInfos = new LinkedHashSet<StsServerInfo>();
                        }
                        this.allStsServerInfos.add(stsServerInfo);
                        continue block10;
                    }
                    case "com.vmware.cis.cs.identity.websso": {
                        URI uRI = endpoint.getUrl();
                        if (uRI == null) continue block10;
                        if (this.metadataUrl == null) {
                            this.metadataUrl = uRI.toString();
                            this.metadataSslTrust = endpoint.getSslTrust()[0];
                        }
                        if (this.allMetadataUrls == null) {
                            this.allMetadataUrls = new LinkedHashSet<String>();
                        }
                        this.allMetadataUrls.add(this.metadataUrl);
                        continue block10;
                    }
                }
            }
            return this;
        }

        public SsoServerInfo getInstance() throws UnsupportedEncodingException, CertificateException {
            if (this.metadataUrl == null && this.stsUrl != null) {
                this.metadataUrl = this.stsUrl.toString().replace(STS_PATH, METADATA_PATH);
                this.metadataSslTrust = this.stsSslTrust;
            }
            if (this.stsSslTrust != null) {
                this._stsSslCertificate = (X509Certificate)CertificateUtil.generateCertificate((String)this.stsSslTrust);
            }
            if (this.adminAppSslTrust != null) {
                this._adminAppSslCertificate = this.adminAppSslTrust.equals(this.stsSslTrust) ? this._stsSslCertificate : (X509Certificate)CertificateUtil.generateCertificate((String)this.adminAppSslTrust);
            }
            if (this.metadataSslTrust != null) {
                this._metadataSslCertificate = this.metadataSslTrust.equals(this.stsSslTrust) ? this._stsSslCertificate : (this.metadataSslTrust.equals(this.adminAppSslTrust) ? this._adminAppSslCertificate : (X509Certificate)CertificateUtil.generateCertificate((String)this.metadataSslTrust));
            }
            SsoServerInfo ssoServerInfo = new SsoServerInfo(this);
            return ssoServerInfo;
        }
    }
}

