/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso;

import com.google.common.collect.ImmutableSet;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.lookup.LookupUtil;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;

public class StsServerInfo {
    @Nonnull
    private final URI _stsServerUri;
    @Nullable
    private final String _sslTrust;
    @Nonnull
    private final Set<String> _capabilities;
    private final boolean _hasVcTrustsCapability;

    private StsServerInfo(@Nonnull URI uRI, @Nullable String string, @Nullable Collection<String> collection) {
        Validate.notNull((Object)uRI);
        this._stsServerUri = uRI;
        this._sslTrust = string;
        ImmutableSet immutableSet = collection == null || collection.isEmpty() ? Collections.emptySet() : ImmutableSet.copyOf(collection);
        this._capabilities = immutableSet;
        this._hasVcTrustsCapability = immutableSet.contains("VC-trusts");
    }

    @Nonnull
    public URI getUri() {
        return this._stsServerUri;
    }

    @Nullable
    public String getSslTrust() {
        return this._sslTrust;
    }

    public boolean hasVcTrustsCapability() {
        return this._hasVcTrustsCapability;
    }

    @Nonnull
    public Set<String> getCapabilities() {
        return this._capabilities;
    }

    public static Builder builder(@Nonnull String string) {
        return new Builder(string);
    }

    public static Builder builder(@Nonnull URI uRI) {
        return new Builder(uRI);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof StsServerInfo) {
            StsServerInfo stsServerInfo = (StsServerInfo)object;
            return this._stsServerUri.equals(stsServerInfo._stsServerUri);
        }
        return false;
    }

    public int hashCode() {
        return this._stsServerUri.hashCode();
    }

    public String toString() {
        return "URI:" + this._stsServerUri + ", WS-trusts=" + this._hasVcTrustsCapability + ", capabilities=" + this._capabilities;
    }

    public static class Builder {
        @Nonnull
        private URI _stsServerUri;
        @Nullable
        private String _sslTrust;
        @Nullable
        private Collection<String> _capabilities;

        public Builder(@Nonnull String string) {
            this(URI.create(string));
        }

        public Builder(@Nonnull URI uRI) {
            Validate.notNull((Object)uRI);
            this._stsServerUri = uRI;
        }

        public Builder sslTrust(@Nullable String string) {
            this._sslTrust = string;
            return this;
        }

        public Builder capabilities(@Nullable String string) {
            this._capabilities = StringUtil.isNullOrWhitespace((String)string) ? null : LookupUtil.parseCapabilities(string);
            return this;
        }

        public Builder capabilities(@Nullable Collection<String> collection) {
            this._capabilities = collection == null || collection.isEmpty() ? null : collection;
            return this;
        }

        public StsServerInfo build() {
            return new StsServerInfo(this._stsServerUri, this._sslTrust, this._capabilities);
        }
    }
}

