/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vise.vim.security.sso.SsoLocator;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicSsoLocator
implements SsoLocator {
    private SsoLocator[] _ssoLocators;
    private static final Log _logger = LogFactory.getLog(DynamicSsoLocator.class);

    public DynamicSsoLocator(SsoLocator[] ssoLocatorArray) {
        this._ssoLocators = ssoLocatorArray;
    }

    @Override
    public SsoServerInfo getSsoServerInfo() throws Exception {
        Map<SsoDomain, SsoServerInfo> map = this.getSsoServerInfos();
        SsoDomain ssoDomain = SsoDomain.getLocal();
        SsoServerInfo ssoServerInfo = map.get(ssoDomain);
        return ssoServerInfo;
    }

    @Override
    public Map<SsoDomain, SsoServerInfo> getSsoServerInfos() throws Exception {
        Map<SsoDomain, SsoServerInfo> map = null;
        Exception exception = null;
        for (SsoLocator ssoLocator : this._ssoLocators) {
            try {
                map = ssoLocator.getSsoServerInfos();
                return map;
            }
            catch (Exception exception2) {
                _logger.error((Object)("Error when fetching sso info from " + ssoLocator.getClass().getSimpleName()), (Throwable)exception2);
                if (exception != null) continue;
                exception = exception2;
            }
        }
        throw exception;
    }
}

