/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.google.common.collect.ImmutableMap;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.sso.client.GssNegotiationClient;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoLocator;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vise.vim.security.sso.impl.SsoUtilInternal;
import com.vmware.vise.vim.security.sso.impl.StsPoolableObjectFactory;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class SsoServiceImpl
implements SsoService {
    private volatile STSConfigHolder _stsConfigHolder;
    private final AtomicReference<Future<STSConfigHolder>> _stsConfigHolderRefresherTaskRef = new AtomicReference<Object>(null);
    private final SsoLocator _ssoLocator;
    private boolean _useHokToken = false;
    private final SsoSolutionUser _ngcSolutionUser;
    private final KeystoreService _ksService;
    @Nullable
    private final HttpConfigurationProvider _httpConfigProvider;
    @Nullable
    private final SsoConfigurationProvider _ssoConfigProvider;
    private KeyPair _hokKeyPair;
    private X509Certificate _hokCertificate;
    private static final Log _logger = LogFactory.getLog(SsoServiceImpl.class);
    private static final long TASK_COMPLETION_THRESHOLD_NANOS = TimeUnit.SECONDS.toNanos(2L);
    private static final long LOCK_ACQUISITION_THRESHOLD_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private StsPoolableObjectFactory _stsFactory = null;
    private volatile GenericObjectPool _stsPool = null;
    private static final int MAX_STS_POOL_SIZE = 20;
    private static AtomicInteger _numberOfRunningTasks = new AtomicInteger(0);

    @Deprecated
    public SsoServiceImpl(SsoLocator ssoLocator, boolean bl, SsoSolutionUser ssoSolutionUser, KeystoreService keystoreService) {
        this(false, ssoLocator, bl, ssoSolutionUser, keystoreService, null, (HttpConfigurationProvider)SsoUtil.getLegacyHttpConfigPool());
    }

    public SsoServiceImpl(@Nonnull SsoLocator ssoLocator, boolean bl, @Nullable SsoSolutionUser ssoSolutionUser, @Nonnull KeystoreService keystoreService, @Nonnull SsoConfigurationProvider ssoConfigurationProvider, @Nonnull HttpConfigurationProvider httpConfigurationProvider) {
        this(true, (SsoLocator)ValidationUtil.notNull((Object)ssoLocator, (String)"ssoLocator is null"), bl, ssoSolutionUser, (KeystoreService)ValidationUtil.notNull((Object)keystoreService, (String)"ksService is null"), (SsoConfigurationProvider)ValidationUtil.notNull((Object)ssoConfigurationProvider, (String)"ssoConfigurationProvider is null"), (HttpConfigurationProvider)ValidationUtil.notNull((Object)httpConfigurationProvider, (String)"httpConfigurationProvider is null"));
    }

    private SsoServiceImpl(boolean bl, SsoLocator ssoLocator, boolean bl2, SsoSolutionUser ssoSolutionUser, KeystoreService keystoreService, @Nullable SsoConfigurationProvider ssoConfigurationProvider, @Nullable HttpConfigurationProvider httpConfigurationProvider) {
        this._ssoLocator = ssoLocator;
        this._useHokToken = bl2;
        this._ngcSolutionUser = ssoSolutionUser;
        this._ksService = keystoreService;
        this._ssoConfigProvider = ssoConfigurationProvider;
        this._httpConfigProvider = httpConfigurationProvider;
        this.initialize();
    }

    private void initialize() {
        if (this._useHokToken && (this._ngcSolutionUser == null || this._ngcSolutionUser.getCertificate() == null || this._ngcSolutionUser.getPrivateKey() == null)) {
            this.initHokCertificate();
        }
    }

    private void initHokCertificate() {
        this._hokKeyPair = SsoUtilInternal.createHokKeyPair();
        try {
            this._hokCertificate = SsoUtilInternal.createHokCertificate(this._hokKeyPair);
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when generating hok certificate.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<SecurityTokenService, SecurityTokenServiceConfig> getSts() throws Exception {
        STSConfigHolder sTSConfigHolder = this._stsConfigHolder;
        SecurityTokenServiceConfig securityTokenServiceConfig = sTSConfigHolder != null ? sTSConfigHolder.getSTSConfig() : null;
        SecurityTokenServiceConfig securityTokenServiceConfig2 = this.getStsConfig();
        long l = System.nanoTime();
        SsoServiceImpl ssoServiceImpl = this;
        synchronized (ssoServiceImpl) {
            long l2 = System.nanoTime() - l;
            if (l2 > LOCK_ACQUISITION_THRESHOLD_NANOS) {
                _logger.warn((Object)("Acquisition of lock in getSts() took too long: " + l2 + " ms"));
            }
            if (this.isStsObjectPoolCreationRequired(securityTokenServiceConfig, securityTokenServiceConfig2)) {
                this.clearStsPool();
                this.createStsObjectPool(securityTokenServiceConfig2);
            }
            SecurityTokenService securityTokenService = (SecurityTokenService)this._stsPool.borrowObject();
            return new Pair((Object)securityTokenService, (Object)securityTokenServiceConfig2);
        }
    }

    private synchronized void clearStsPool() {
        if (this._stsPool == null) {
            return;
        }
        try {
            this._stsPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._stsPool = null;
    }

    private boolean isStsObjectPoolCreationRequired(SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenServiceConfig securityTokenServiceConfig2) throws Exception {
        if (this._stsPool == null) {
            return true;
        }
        return securityTokenServiceConfig != securityTokenServiceConfig2;
    }

    private void returnSts(SecurityTokenService securityTokenService) {
        if (this._stsPool == null || securityTokenService == null) {
            return;
        }
        try {
            this._stsPool.returnObject((Object)securityTokenService);
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when returning STS instance back to the pool.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityTokenServiceConfig getStsConfig() throws Exception {
        boolean bl;
        long l;
        Object object;
        Object object2;
        block17: {
            boolean bl2;
            do {
                if ((object = this._stsConfigHolderRefresherTaskRef.get()) == null) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("An STS config refresher task already exists. (" + object + ") Will wait for its result."));
                }
                l = System.nanoTime();
                bl = false;
                break block17;
            } while (!(bl2 = this._stsConfigHolderRefresherTaskRef.compareAndSet((Future<STSConfigHolder>)null, (Future<STSConfigHolder>)(object2 = new FutureTask<STSConfigHolder>(new STSConfigRefresherTask())))));
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Will run an STS config refresher task in the current thread: " + object2));
                }
                object = object2;
                bl = true;
                l = System.nanoTime();
                ((FutureTask)object2).run();
            }
            finally {
                this._stsConfigHolderRefresherTaskRef.compareAndSet((Future<STSConfigHolder>)object2, null);
            }
        }
        Exception exception = null;
        try {
            object2 = object.get(2L, TimeUnit.MINUTES);
        }
        catch (Exception exception2) {
            exception = exception2;
            object2 = this._stsConfigHolder;
            if (object2 == null) {
                throw exception2;
            }
            _logger.error((Object)"The retrieval of STSConfig failed but since we have a previous cached instance, we'll use it and hopefully it will do the job", (Throwable)exception2);
        }
        finally {
            long l2 = System.nanoTime() - l;
            if (l2 > TASK_COMPLETION_THRESHOLD_NANOS) {
                _logger.warn((Object)("An STS config refresher task took too long: " + TimeUnit.NANOSECONDS.toMillis(l2) + " ms;  ranTaskInThisThread=" + bl + ", task=" + object));
            } else if (_logger.isDebugEnabled()) {
                if (exception != null) {
                    _logger.debug((Object)("STS config refresher task failed: " + exception));
                } else {
                    _logger.debug((Object)"STS config refresher task completed");
                }
            }
        }
        SecurityTokenServiceConfig securityTokenServiceConfig = ((STSConfigHolder)object2).getSTSConfig();
        return securityTokenServiceConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStsObjectPool(SecurityTokenServiceConfig securityTokenServiceConfig) throws Exception {
        long l = System.nanoTime();
        SsoServiceImpl ssoServiceImpl = this;
        synchronized (ssoServiceImpl) {
            long l2 = System.nanoTime() - l;
            if (l2 > LOCK_ACQUISITION_THRESHOLD_NANOS) {
                _logger.warn((Object)("Acquisition of lock in createStsObjectPool() took too long: " + l2 + " ms"));
            }
            if (this._stsPool != null) {
                return;
            }
            _logger.debug((Object)"createStsObjectPool(): start");
            this._stsFactory = new StsPoolableObjectFactory(securityTokenServiceConfig);
            GenericObjectPool.Config config = new GenericObjectPool.Config();
            config.maxActive = 20;
            config.whenExhaustedAction = 1;
            config.testOnReturn = true;
            this._stsPool = new GenericObjectPool((PoolableObjectFactory)this._stsFactory, config);
            _logger.debug((Object)"createStsObjectPool(): end");
        }
    }

    @Override
    public SsoServerInfo getServerInfo() throws Exception {
        return this._ssoLocator.getSsoServerInfo();
    }

    @Override
    public Map<SsoDomain, SsoServerInfo> getServerInfos() throws Exception {
        SsoServerInfo ssoServerInfo = this.getServerInfo();
        return ImmutableMap.of((Object)SsoDomain.getLocal(), (Object)ssoServerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X509Certificate[] getStsCertificates() {
        Pair<SecurityTokenService, SecurityTokenServiceConfig> pair = null;
        try {
            pair = this.getSts();
            SecurityTokenServiceConfig securityTokenServiceConfig = (SecurityTokenServiceConfig)pair.second;
            X509Certificate[] x509CertificateArray = securityTokenServiceConfig.getTrustedRootCertificates();
            return x509CertificateArray;
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when fetching sts root certificates ", (Throwable)exception);
        }
        finally {
            if (pair != null) {
                SecurityTokenService securityTokenService = (SecurityTokenService)pair.first;
                this.returnSts(securityTokenService);
            }
        }
        return null;
    }

    @Override
    public X509Certificate[] getStsCertificates(SsoDomain ssoDomain) {
        return this.getStsCertificates();
    }

    @Override
    public SamlToken acquireToken(String string, String string2, TokenSpec tokenSpec) throws SsoServiceException {
        Pair<SecurityTokenService, SecurityTokenServiceConfig> pair = null;
        SecurityTokenService securityTokenService = null;
        try {
            SamlToken samlToken;
            pair = this.getSts();
            securityTokenService = (SecurityTokenService)pair.first;
            SecurityTokenServiceConfig securityTokenServiceConfig = (SecurityTokenServiceConfig)pair.second;
            SamlToken samlToken2 = samlToken = SsoUtilInternal.acquireToken(securityTokenServiceConfig, securityTokenService, string, string2, tokenSpec);
            this.returnSts(securityTokenService);
            return samlToken2;
        }
        catch (Exception exception) {
            try {
                throw new SsoServiceException(exception);
            }
            catch (Throwable throwable) {
                this.returnSts(securityTokenService);
                throw throwable;
            }
        }
    }

    @Override
    public SamlToken acquireToken(SsoDomain ssoDomain, String string, String string2, TokenSpec tokenSpec) throws SsoServiceException {
        return this.acquireToken(string, string2, tokenSpec);
    }

    @Override
    public GssNegotiationClient obtainGssNegotiationClient(TokenSpec tokenSpec) throws SsoServiceException {
        Pair<SecurityTokenService, SecurityTokenServiceConfig> pair = null;
        SecurityTokenService securityTokenService = null;
        try {
            pair = this.getSts();
            securityTokenService = (SecurityTokenService)pair.first;
            SecurityTokenServiceConfig securityTokenServiceConfig = (SecurityTokenServiceConfig)pair.second;
            GssNegotiationClient gssNegotiationClient = SsoUtilInternal.obtainGssNegotiationClient(securityTokenServiceConfig, securityTokenService, tokenSpec);
            this.returnSts(securityTokenService);
            return gssNegotiationClient;
        }
        catch (Exception exception) {
            try {
                throw new SsoServiceException(exception);
            }
            catch (Throwable throwable) {
                this.returnSts(securityTokenService);
                throw throwable;
            }
        }
    }

    @Override
    public GssNegotiationClient obtainGssNegotiationClient(SsoDomain ssoDomain, TokenSpec tokenSpec) throws SsoServiceException {
        return this.obtainGssNegotiationClient(tokenSpec);
    }

    @Override
    public SamlToken negotiateToken(GssNegotiationClient gssNegotiationClient, String string) throws SsoServiceException {
        try {
            return SsoUtilInternal.negotiateToken(gssNegotiationClient, string);
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
    }

    @Override
    public SamlToken acquireTokenByToken(SamlToken samlToken, TokenSpec tokenSpec) throws SsoServiceException {
        Pair<SecurityTokenService, SecurityTokenServiceConfig> pair = null;
        SecurityTokenService securityTokenService = null;
        try {
            SamlToken samlToken2;
            _logger.debug((Object)"Getting STS pair");
            pair = this.getSts();
            _logger.debug((Object)"Got STS pair");
            securityTokenService = (SecurityTokenService)pair.first;
            SecurityTokenServiceConfig securityTokenServiceConfig = (SecurityTokenServiceConfig)pair.second;
            SamlToken samlToken3 = samlToken2 = SsoUtilInternal.acquireTokenByToken(securityTokenServiceConfig, securityTokenService, samlToken, tokenSpec);
            this.returnSts(securityTokenService);
            return samlToken3;
        }
        catch (Exception exception) {
            try {
                throw new SsoServiceException(exception);
            }
            catch (Throwable throwable) {
                this.returnSts(securityTokenService);
                throw throwable;
            }
        }
    }

    @Override
    public SamlToken acquireTokenByToken(SsoDomain ssoDomain, SamlToken samlToken, TokenSpec tokenSpec) throws SsoServiceException {
        return this.acquireTokenByToken(samlToken, tokenSpec);
    }

    @Override
    public SamlToken buildToken(String string) throws SsoServiceException {
        try {
            SamlToken samlToken = SsoUtilInternal.buildToken(this.getStsConfig(), string);
            return samlToken;
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
    }

    @Override
    public SamlToken buildToken(SsoDomain ssoDomain, String string) throws SsoServiceException {
        return this.buildToken(string);
    }

    @Override
    public SamlToken renewToken(SamlToken samlToken, long l) throws SsoServiceException {
        Pair<SecurityTokenService, SecurityTokenServiceConfig> pair = null;
        SecurityTokenService securityTokenService = null;
        try {
            SamlToken samlToken2;
            pair = this.getSts();
            securityTokenService = (SecurityTokenService)pair.first;
            SecurityTokenServiceConfig securityTokenServiceConfig = (SecurityTokenServiceConfig)pair.second;
            SamlToken samlToken3 = samlToken2 = SsoUtilInternal.renewToken(securityTokenServiceConfig, securityTokenService, samlToken, l);
            this.returnSts(securityTokenService);
            return samlToken3;
        }
        catch (Exception exception) {
            try {
                throw new SsoServiceException(exception);
            }
            catch (Throwable throwable) {
                this.returnSts(securityTokenService);
                throw throwable;
            }
        }
    }

    @Override
    public SamlToken renewToken(SsoDomain ssoDomain, SamlToken samlToken, long l) throws SsoServiceException {
        return this.renewToken(samlToken, l);
    }

    @Override
    public boolean validateToken(SamlToken samlToken) throws SsoServiceException {
        Pair<SecurityTokenService, SecurityTokenServiceConfig> pair = null;
        SecurityTokenService securityTokenService = null;
        try {
            boolean bl;
            pair = this.getSts();
            securityTokenService = (SecurityTokenService)pair.first;
            SecurityTokenServiceConfig securityTokenServiceConfig = (SecurityTokenServiceConfig)pair.second;
            boolean bl2 = bl = SsoUtilInternal.validateToken(securityTokenServiceConfig, securityTokenService, samlToken);
            this.returnSts(securityTokenService);
            return bl2;
        }
        catch (Exception exception) {
            try {
                throw new SsoServiceException(exception);
            }
            catch (Throwable throwable) {
                this.returnSts(securityTokenService);
                throw throwable;
            }
        }
    }

    @Override
    public boolean validateToken(SsoDomain ssoDomain, SamlToken samlToken) throws SsoServiceException {
        return this.validateToken(samlToken);
    }

    @Override
    public PrivateKey getHokPrivateKey() {
        if (!this._useHokToken) {
            return null;
        }
        if (this._ngcSolutionUser != null && this._ngcSolutionUser.getPrivateKey() != null) {
            return this._ngcSolutionUser.getPrivateKey();
        }
        return this._hokKeyPair.getPrivate();
    }

    @Override
    public X509Certificate getHokCertificate() {
        if (!this._useHokToken) {
            return null;
        }
        if (this._ngcSolutionUser != null && this._ngcSolutionUser.getCertificate() != null) {
            return this._ngcSolutionUser.getCertificate();
        }
        return this._hokCertificate;
    }

    @Override
    public boolean checkTokenLifetime(SamlToken samlToken) throws InvalidTokenException {
        return SsoUtilInternal.checkTokenLifetime(samlToken);
    }

    private void checkHokCertificateValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        if (!this._useHokToken) {
            return;
        }
        X509Certificate x509Certificate = null;
        try {
            if (this._ngcSolutionUser != null && (x509Certificate = this._ngcSolutionUser.getCertificate()) != null) {
                x509Certificate.checkValidity();
                return;
            }
            x509Certificate = this._hokCertificate;
            x509Certificate.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            _logger.info((Object)("The client certificate has expired at " + x509Certificate.getNotAfter()));
            throw certificateExpiredException;
        }
    }

    public void shutdown() {
        ExecutorService executorService;
        SecurityTokenServiceConfig securityTokenServiceConfig;
        STSConfigHolder sTSConfigHolder = this._stsConfigHolder;
        if (sTSConfigHolder != null && (securityTokenServiceConfig = sTSConfigHolder.getSTSConfig()) != null && (executorService = securityTokenServiceConfig.getExecutorService()) != null) {
            executorService.shutdown();
        }
    }

    private class STSConfigRefresherTask
    implements Callable<STSConfigHolder> {
        private STSConfigRefresherTask() {
        }

        @Override
        public STSConfigHolder call() throws Exception {
            int n = _numberOfRunningTasks.incrementAndGet();
            if (n > 1) {
                _logger.warn((Object)("Multiple STSConfigRefresherTask are running: " + n + "\n" + ExceptionUtil.getCurrentStackTrace()));
            }
            try {
                STSConfigHolder sTSConfigHolder;
                _logger.debug((Object)"Running an STSConfigRefresherTask");
                SsoServerInfo ssoServerInfo = SsoServiceImpl.this._ssoLocator.getSsoServerInfo();
                _logger.debug((Object)"Fetched the ssoInfo");
                if (ssoServerInfo == null) {
                    throw new NullPointerException("SsoServerInfo should be non-null.");
                }
                STSConfigHolder sTSConfigHolder2 = SsoServiceImpl.this._stsConfigHolder;
                if (sTSConfigHolder2 == null || !ssoServerInfo.equals(sTSConfigHolder2.getServerInfo())) {
                    _logger.debug((Object)"Creating a new STSConfigHolder");
                    sTSConfigHolder = null;
                    if (SsoServiceImpl.this._useHokToken) {
                        sTSConfigHolder = new SecurityTokenServiceConfig.HolderOfKeyConfig((Key)SsoServiceImpl.this.getHokPrivateKey(), SsoServiceImpl.this.getHokCertificate(), null);
                    }
                    SsoServiceImpl.this.shutdown();
                    SecurityTokenServiceConfig securityTokenServiceConfig = SsoServiceImpl.this._ssoConfigProvider != null && SsoServiceImpl.this._httpConfigProvider != null ? SsoUtilInternal.createStsConfiguration(ssoServerInfo, (SecurityTokenServiceConfig.HolderOfKeyConfig)sTSConfigHolder, SsoServiceImpl.this._ksService, SsoServiceImpl.this._ssoConfigProvider, SsoServiceImpl.this._httpConfigProvider) : SsoUtilInternal.createStsConfiguration(ssoServerInfo, (SecurityTokenServiceConfig.HolderOfKeyConfig)sTSConfigHolder, SsoServiceImpl.this._ksService);
                    sTSConfigHolder2 = new STSConfigHolder(securityTokenServiceConfig, ssoServerInfo);
                    SsoServiceImpl.this._stsConfigHolder = sTSConfigHolder2;
                    _logger.debug((Object)"Created the STSConfigHolder");
                }
                SsoServiceImpl.this.checkHokCertificateValidity();
                _logger.debug((Object)"Checked the HoK ceritifcate validity");
                sTSConfigHolder = sTSConfigHolder2;
                return sTSConfigHolder;
            }
            catch (Exception exception) {
                if ((exception instanceof InternalException || exception instanceof SslException) && exception.getCause() instanceof Exception) {
                    throw (Exception)exception.getCause();
                }
                throw exception;
            }
            finally {
                _numberOfRunningTasks.decrementAndGet();
            }
        }
    }

    private static class STSConfigHolder {
        private final SecurityTokenServiceConfig _config;
        private final SsoServerInfo _info;

        public STSConfigHolder(SecurityTokenServiceConfig securityTokenServiceConfig, SsoServerInfo ssoServerInfo) {
            this._config = securityTokenServiceConfig;
            this._info = ssoServerInfo;
        }

        public SecurityTokenServiceConfig getSTSConfig() {
            return this._config;
        }

        public SsoServerInfo getServerInfo() {
            return this._info;
        }
    }
}

