/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vise.data.provider.DelegatingServiceBase;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.service.ServiceRegistry;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.SsoServiceProvider;
import com.vmware.vise.vim.security.sso.impl.SsoUtilInternal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoServiceManagerImpl
implements SsoServiceManager {
    private static final Log _logger = LogFactory.getLog(SsoServiceManagerImpl.class);
    private DelegatingServiceBase _delegatingService;

    public SsoServiceManagerImpl(ServiceRegistry serviceRegistry) {
        this._delegatingService = new DelegatingServiceBase(SsoServiceProvider.class, serviceRegistry);
    }

    @Override
    public SsoAdminService getAdminService(Object object) {
        try {
            SsoAdminService ssoAdminService = null;
            if (object != null) {
                ssoAdminService = (SsoAdminService)this._delegatingService.delegate("getAdminService", new Object[]{object});
            }
            if (ssoAdminService == null) {
                ssoAdminService = (SsoAdminService)this._delegatingService.delegate("getAdminService", new Object[0]);
            }
            return ssoAdminService;
        }
        catch (Exception exception) {
            Throwable throwable = ExceptionUtil.unwrap((Throwable)exception);
            _logger.error((Object)("Failed getting admin service client: " + throwable.getMessage()));
            throw new RuntimeException(exception);
        }
    }

    @Override
    public SsoAdminService getAdminService(Object object, SsoDomain ssoDomain) {
        SsoUtilInternal.assertIsLocalDomain(ssoDomain);
        return this.getAdminService(object);
    }

    @Override
    public SsoAdminService getSolutionAdminService(Object object) {
        try {
            SsoAdminService ssoAdminService = null;
            if (object != null) {
                ssoAdminService = (SsoAdminService)this._delegatingService.delegate("getSolutionAdminService", new Object[]{object});
            }
            if (ssoAdminService == null) {
                ssoAdminService = (SsoAdminService)this._delegatingService.delegate("getSolutionAdminService", new Object[0]);
            }
            return ssoAdminService;
        }
        catch (Exception exception) {
            _logger.error((Object)("Faled getting solution admin service: " + exception.getMessage()));
            throw new RuntimeException(exception);
        }
    }

    @Override
    public SsoAdminService getSolutionAdminService(Object object, SsoDomain ssoDomain) {
        SsoUtilInternal.assertIsLocalDomain(ssoDomain);
        return this.getSolutionAdminService(object);
    }
}

