/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceProvider;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoServiceProviderImpl
implements SsoServiceProvider,
UserSessionListener {
    private static final Log _logger = LogFactory.getLog(SsoServiceProviderImpl.class);
    private static final String SSO_ADMIN_SERVICE_SESSION_KEY = "#defaultSsoAdminService#";
    private final SsoService _ssoService;
    private final HttpConfigurationProvider _httpConfigProvider;
    private SsoAdminService _solutionAdminService = null;

    @Deprecated
    public SsoServiceProviderImpl(SsoService ssoService) {
        this(false, ssoService, null);
    }

    public SsoServiceProviderImpl(@Nonnull SsoService ssoService, @Nonnull HttpConfigurationProvider httpConfigurationProvider) {
        this(true, (SsoService)ValidationUtil.notNull((Object)ssoService, (String)"ssoservice is null"), (HttpConfigurationProvider)ValidationUtil.notNull((Object)httpConfigurationProvider, (String)"httpConfigProvider is null"));
    }

    private SsoServiceProviderImpl(boolean bl, SsoService ssoService, HttpConfigurationProvider httpConfigurationProvider) {
        this._ssoService = ssoService;
        this._httpConfigProvider = httpConfigurationProvider;
    }

    public SsoAdminService getAdminService() {
        return this.getAdminService(null);
    }

    public SsoAdminService getAdminService(Object object) {
        SsoAdminService ssoAdminService = (SsoAdminService)SessionUtil.getData((String)SSO_ADMIN_SERVICE_SESSION_KEY);
        if (ssoAdminService != null) {
            return ssoAdminService;
        }
        return this.getAdminServiceSynchronized(object);
    }

    private synchronized SsoAdminService getAdminServiceSynchronized(Object object) {
        SsoAdminService ssoAdminService = (SsoAdminService)SessionUtil.getData((String)SSO_ADMIN_SERVICE_SESSION_KEY);
        if (ssoAdminService != null) {
            return ssoAdminService;
        }
        try {
            ssoAdminService = this._httpConfigProvider != null ? SsoUtil.getAdminService(this._ssoService.getServerInfo(), this._ssoService, AuthSessionUtil.getSsoToken(), this._httpConfigProvider) : SsoUtil.getAdminService(this._ssoService.getServerInfo(), this._ssoService, AuthSessionUtil.getSsoToken());
            SessionUtil.setData((String)SSO_ADMIN_SERVICE_SESSION_KEY, (Object)ssoAdminService, (boolean)false);
            return ssoAdminService;
        }
        catch (SsoServiceException ssoServiceException) {
            _logger.error((Object)("Falied getting SSO admin service: " + ssoServiceException.getMessage()));
            throw new RuntimeException(ssoServiceException);
        }
        catch (Exception exception) {
            _logger.error((Object)("Falied getting SSO admin service: " + exception.getMessage()));
            throw new RuntimeException(exception);
        }
    }

    public SsoAdminService getSolutionAdminService() {
        return this.getSolutionAdminService(null);
    }

    public SsoAdminService getSolutionAdminService(Object object) {
        if (this._solutionAdminService != null) {
            return this._solutionAdminService;
        }
        return this.getSolutionAdminServiceSynchronized(object);
    }

    private synchronized SsoAdminService getSolutionAdminServiceSynchronized(Object object) {
        if (this._solutionAdminService != null) {
            return this._solutionAdminService;
        }
        try {
            SsoAdminService ssoAdminService = this._httpConfigProvider != null ? SsoUtil.getAdminService(this._ssoService.getServerInfo(), this._ssoService, SsoUtil.getSolutionUser(), this._httpConfigProvider) : SsoUtil.getAdminService(this._ssoService.getServerInfo(), this._ssoService, SsoUtil.getSolutionUser());
            this._solutionAdminService = ssoAdminService;
            return this._solutionAdminService;
        }
        catch (SsoServiceException ssoServiceException) {
            _logger.error((Object)("Falied getting SSO solution admin service: " + ssoServiceException.getMessage()));
            throw new RuntimeException(ssoServiceException);
        }
        catch (Exception exception) {
            _logger.error((Object)("Falied getting SSO solution admin service: " + exception.getMessage()));
            throw new RuntimeException(exception);
        }
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        SsoAdminService ssoAdminService = (SsoAdminService)SessionUtil.getData((String)SSO_ADMIN_SERVICE_SESSION_KEY);
        if (ssoAdminService != null) {
            try {
                ssoAdminService.logout();
            }
            catch (Exception exception) {
                _logger.error((Object)"Failed to log out of the SsoAdminService", (Throwable)exception);
            }
        }
    }
}

