/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.SecurityTokenServiceEx;
import com.vmware.vise.vim.security.sso.impl.SsoUtilInternal;
import java.lang.invoke.MethodHandles;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.BasePoolableObjectFactory;

public final class StsPoolableObjectFactory
extends BasePoolableObjectFactory {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final SecurityTokenServiceConfig _config;
    private final List<SecurityTokenServiceEx> _createdObjects;

    public StsPoolableObjectFactory(SecurityTokenServiceConfig securityTokenServiceConfig) {
        this._config = securityTokenServiceConfig;
        this._createdObjects = new LinkedList<SecurityTokenServiceEx>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object makeObject() throws Exception {
        _logger.debug((Object)"Making an STS object");
        SecurityTokenServiceEx securityTokenServiceEx = SsoUtilInternal.createSts(this._config);
        List<SecurityTokenServiceEx> list = this._createdObjects;
        synchronized (list) {
            this._createdObjects.add(securityTokenServiceEx);
        }
        _logger.debug((Object)"Done making an STS object");
        return securityTokenServiceEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateObject(Object object) {
        List<SecurityTokenServiceEx> list = this._createdObjects;
        synchronized (list) {
            return this._createdObjects.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(Object object) throws Exception {
        List<SecurityTokenServiceEx> list = this._createdObjects;
        synchronized (list) {
            this._createdObjects.remove(object);
        }
    }
}

