/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vapi;

import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vapi.cis.authn.SecurityContextFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.security.SessionSecurityContext;
import com.vmware.vapi.std.Progress;
import com.vmware.vapi.std.errors.Unauthenticated;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.vapi.VapiConnectionAuthenticationStrategy;
import com.vmware.vise.vim.vapi.VapiSessionProvider;
import java.lang.reflect.Method;
import java.net.URI;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionBasedVapiConnectionAuthenticator
implements VapiConnectionAuthenticationStrategy {
    private static final Log _logger = LogFactory.getLog(SessionBasedVapiConnectionAuthenticator.class);
    private final Class<? extends Service> _sessionManagerType;
    private final String _sessionManagerLoginOperation;
    private final String _sessionManagerLogoutOperation;
    private final VapiSessionProvider _sessionProvider;
    private final URI _endpointUrl;

    public SessionBasedVapiConnectionAuthenticator(Class<? extends Service> clazz, String string, String string2, VapiSessionProvider vapiSessionProvider, URI uRI) {
        Validate.notNull(clazz);
        Validate.notNull((Object)string);
        Validate.notNull((Object)string2);
        Validate.notNull((Object)vapiSessionProvider);
        Validate.notNull((Object)uRI);
        this._sessionManagerType = clazz;
        this._sessionManagerLoginOperation = string;
        this._sessionManagerLogoutOperation = string2;
        this._sessionProvider = vapiSessionProvider;
        this._endpointUrl = uRI;
    }

    @Override
    public void onUserSessionStarted(HttpSessionEvent httpSessionEvent) {
    }

    @Override
    public void onUserSessionEnded(HttpSessionEvent httpSessionEvent, StubFactory stubFactory) {
        String string = SessionUtil.getClientId((HttpSession)httpSessionEvent.getSession());
        if (string == null) {
            _logger.warn((Object)"Session ended, but was associated with no clientId.");
            return;
        }
        char[] cArray = this.clear(string);
        if (cArray != null) {
            this.logout(cArray, stubFactory);
        }
    }

    private char[] login(String string, StubFactory stubFactory) {
        Validate.isTrue((boolean)this.isSupportedClientId(string));
        ClassLoader classLoader = SessionBasedVapiConnectionAuthenticator.class.getClassLoader();
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            char[] cArray;
            Thread.currentThread().setContextClassLoader(classLoader);
            ExecutionContext.SecurityContext securityContext = this._sessionProvider.createSamlSecurityContext(string);
            StubConfiguration stubConfiguration = new StubConfiguration();
            stubConfiguration.setSecurityContext(securityContext);
            Service service = stubFactory.createStub(this._sessionManagerType, (StubConfigurationBase)stubConfiguration);
            Method method = service.getClass().getMethod(this._sessionManagerLoginOperation, new Class[0]);
            char[] cArray2 = cArray = (char[])method.invoke((Object)service, new Object[0]);
            return cArray2;
        }
        catch (Exception exception) {
            _logger.error((Object)String.format("Logging in to service '%s' failed.", this._endpointUrl.toString()), (Throwable)exception);
            throw new RuntimeException(exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logout(char[] cArray, StubFactory stubFactory) {
        ClassLoader classLoader = SessionBasedVapiConnectionAuthenticator.class.getClassLoader();
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            StubConfiguration stubConfiguration = new StubConfiguration();
            ExecutionContext.SecurityContext securityContext = SecurityContextFactory.createSessionSecurityContext((char[])cArray);
            stubConfiguration.setSecurityContext(securityContext);
            Service service = stubFactory.createStub(this._sessionManagerType, (StubConfigurationBase)stubConfiguration);
            Method method = service.getClass().getMethod(this._sessionManagerLogoutOperation, AsyncCallback.class);
            method.invoke((Object)service, new Object[]{new LogoutCallback()});
        }
        catch (Exception exception) {
            _logger.error((Object)String.format("Logging out from service '%s' failed.", this._endpointUrl.toString()), (Throwable)exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
    }

    @Override
    public void clearState(String string) {
        if (!this.isSupportedClientId(string)) {
            return;
        }
        this.clear(string);
    }

    @Override
    public void clearAllState() {
        this._sessionProvider.clearAllSessions(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] clear(String string) {
        char[] cArray;
        Validate.isTrue((boolean)this.isSupportedClientId(string));
        Object object = this._sessionProvider.sessionMonitor(string);
        synchronized (object) {
            cArray = this._sessionProvider.sessionId(string);
            this._sessionProvider.clearSession(string);
        }
        return cArray;
    }

    @Override
    public ExecutionContext.SecurityContext createSecurityContext(String string, StubFactory stubFactory) {
        Validate.isTrue((boolean)this.isSupportedClientId(string));
        char[] cArray = this._sessionProvider.sessionId(string);
        if (cArray == null) {
            char[] cArray2 = this.login(string, stubFactory);
            if (cArray2 == null) {
                return null;
            }
            this._sessionProvider.storeSession(string, cArray2);
            cArray = cArray2;
        }
        return SecurityContextFactory.createSessionSecurityContext((char[])cArray);
    }

    @Override
    public String getClientId(ExecutionContext.SecurityContext securityContext) {
        Validate.notNull((Object)securityContext, (String)"Attempting to retrieve clientId of no SecurityContext");
        Validate.isTrue((boolean)(securityContext instanceof SessionSecurityContext), (String)"Non-session security context passed to the session authenticator");
        SessionSecurityContext sessionSecurityContext = (SessionSecurityContext)securityContext;
        char[] cArray = sessionSecurityContext.getSessionId();
        return this._sessionProvider.clientBySessionId(cArray);
    }

    @Override
    public boolean isSupportedClientId(String string) {
        return this._sessionProvider.isValidClientId(string);
    }

    private class LogoutCallback
    extends AsyncCallback<Void> {
        private LogoutCallback() {
        }

        public void onProgress(Progress progress) {
        }

        public void onResult(Void void_) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)String.format("Successfully logged out of %s.", SessionBasedVapiConnectionAuthenticator.this._endpointUrl.toString()));
            }
        }

        public void onError(RuntimeException runtimeException) {
            if (runtimeException instanceof Unauthenticated) {
                _logger.debug((Object)"Logging out of vAPI endpoint resulted in Unauthenticated error.", (Throwable)runtimeException);
            } else {
                _logger.error((Object)String.format("Error logging out of %s", SessionBasedVapiConnectionAuthenticator.this._endpointUrl.toString()), (Throwable)runtimeException);
            }
        }
    }
}

