/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vapi;

import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.bindings.client.RetryPolicy;
import com.vmware.vapi.cis.authn.ProtocolFactory;
import com.vmware.vapi.client.exception.TransportProtocolException;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.protocol.ClientConfiguration;
import com.vmware.vapi.protocol.HttpConfiguration;
import com.vmware.vapi.protocol.ProtocolConnection;
import com.vmware.vapi.std.errors.Unauthenticated;
import com.vmware.vise.util.Timeout;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.util.VecsUtil;
import com.vmware.vise.vim.internal.Config;
import com.vmware.vise.vim.vapi.OpIdProxyApiProvider;
import com.vmware.vise.vim.vapi.VapiConnectionAuthenticationStrategy;
import com.vmware.vise.vim.vapi.VapiConnectionControl;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import java.net.URI;
import java.security.cert.CertStore;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaticEndpointVapiConnectionManager
implements VapiConnectionManager {
    private static final Log _logger = LogFactory.getLog(StaticEndpointVapiConnectionManager.class);
    private final KeystoreService _ksService;
    private final VapiConnectionAuthenticationStrategy _authenticator;
    private final URI _endpointUrl;
    private volatile ProtocolConnection _vapiConnection;
    private final Object _connectionMonitor = new Object();
    private final ExecutorService _asyncCallExecutor;
    private final VapiConnectionControl _connectionControl;
    private final RetryPolicy _retryPolicy = new RetryPolicy(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RetryPolicy.RetrySpec onInvocationError(RuntimeException runtimeException, RetryPolicy.RetryContext retryContext, int n) {
            try {
                String string;
                try {
                    Validate.notNull((Object)retryContext);
                    string = StaticEndpointVapiConnectionManager.this._authenticator.getClientId(retryContext.getExecutionContext().retrieveSecurityContext());
                    if (runtimeException instanceof Unauthenticated) {
                        StaticEndpointVapiConnectionManager.this._authenticator.clearState(string);
                    } else if (runtimeException instanceof TransportProtocolException) {
                        StaticEndpointVapiConnectionManager.this._authenticator.clearState(string);
                        StaticEndpointVapiConnectionManager.this._authenticator.clearAllState();
                    }
                }
                finally {
                    if (runtimeException instanceof TransportProtocolException) {
                        Object object = StaticEndpointVapiConnectionManager.this._connectionMonitor;
                        synchronized (object) {
                            if (StaticEndpointVapiConnectionManager.this._vapiConnection != null) {
                                try {
                                    StaticEndpointVapiConnectionManager.this._vapiConnection.disconnect();
                                }
                                finally {
                                    StaticEndpointVapiConnectionManager.this._vapiConnection = null;
                                }
                            }
                        }
                    }
                }
                boolean bl = StaticEndpointVapiConnectionManager.this._connectionControl.retryOnError(runtimeException, retryContext, n);
                if (bl) {
                    if (!StaticEndpointVapiConnectionManager.this._authenticator.isSupportedClientId(string)) {
                        _logger.warn((Object)"Obtained an unsupported clientId. Will not retry invocation.");
                        return null;
                    }
                    return this.createRetrySpec(retryContext.getExecutionContext(), string);
                }
                return null;
            }
            catch (RuntimeException runtimeException2) {
                _logger.error((Object)"Exception occurred while trying to handle exception. Will not retry.", (Throwable)runtimeException2);
                return null;
            }
        }

        private RetryPolicy.RetrySpec createRetrySpec(ExecutionContext executionContext, String string) {
            try {
                ExecutionContext.SecurityContext securityContext = StaticEndpointVapiConnectionManager.this._authenticator.createSecurityContext(string, new StubFactory(StaticEndpointVapiConnectionManager.this.getApiProvider()));
                if (securityContext == null) {
                    return null;
                }
                ExecutionContext executionContext2 = new ExecutionContext(executionContext.retrieveApplicationData(), securityContext);
                InvocationConfig invocationConfig = new InvocationConfig(executionContext2);
                RetryPolicy.RetrySpec retrySpec = new RetryPolicy.RetrySpec(invocationConfig);
                return retrySpec;
            }
            catch (RuntimeException runtimeException) {
                _logger.error((Object)"Could not configure vAPI operation re-attempt.", (Throwable)runtimeException);
                return null;
            }
        }
    };

    public StaticEndpointVapiConnectionManager(URI uRI, KeystoreService keystoreService, ExecutorService executorService, VapiConnectionAuthenticationStrategy vapiConnectionAuthenticationStrategy, VapiConnectionControl vapiConnectionControl) {
        Validate.notNull((Object)uRI);
        Validate.notNull((Object)keystoreService);
        Validate.notNull((Object)executorService);
        Validate.notNull((Object)vapiConnectionAuthenticationStrategy);
        this._endpointUrl = uRI;
        this._ksService = keystoreService;
        this._asyncCallExecutor = executorService;
        this._authenticator = vapiConnectionAuthenticationStrategy;
        this._connectionControl = vapiConnectionControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service createServiceStub(Class<? extends Service> clazz) {
        Validate.notNull(clazz);
        ApiProvider apiProvider = this.getApiProvider();
        if (apiProvider == null) {
            _logger.error((Object)String.format("vAPI service of type %s cannot be provided because vAPI connection is missing", clazz.toString()));
            return null;
        }
        StubFactory stubFactory = new StubFactory(apiProvider);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(clazz.getClassLoader());
        try {
            Service service = stubFactory.createStub(clazz, (StubConfigurationBase)this.getStubConfig());
            return service;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @Override
    public ApiProvider getApiProvider() {
        ProtocolConnection protocolConnection = this.vapiConnection();
        if (protocolConnection == null) {
            return null;
        }
        OpIdProxyApiProvider opIdProxyApiProvider = new OpIdProxyApiProvider(protocolConnection.getApiProvider());
        return this._connectionControl.getApiProvider(opIdProxyApiProvider);
    }

    @Override
    public StubConfiguration getStubConfig() {
        return this.createStubConfig();
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        this._authenticator.onUserSessionStarted(httpSessionEvent);
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        _logger.info((Object)("Logging out of vAPI service: " + this._endpointUrl));
        this._authenticator.onUserSessionEnded(httpSessionEvent, new StubFactory(this.getApiProvider()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtocolConnection vapiConnection() {
        ProtocolConnection protocolConnection = this._vapiConnection;
        if (protocolConnection == null) {
            Object object = this._connectionMonitor;
            synchronized (object) {
                protocolConnection = this._vapiConnection;
                if (protocolConnection == null) {
                    this._vapiConnection = protocolConnection = this.connect();
                }
            }
        }
        return protocolConnection;
    }

    private StubConfiguration createStubConfig() {
        HttpSession httpSession = SessionUtil.getHttpSession();
        Validate.notNull((Object)httpSession, (String)"Attempting login to a vAPI service without session context");
        ExecutionContext.SecurityContext securityContext = this._authenticator.createSecurityContext(SessionUtil.getClientId((HttpSession)httpSession), new StubFactory(this.getApiProvider()));
        StubConfiguration stubConfiguration = new StubConfiguration();
        stubConfiguration.setSecurityContext(securityContext);
        stubConfiguration.setRetryPolicy(this._retryPolicy);
        return stubConfiguration;
    }

    private ProtocolConnection connect() {
        ProtocolFactory protocolFactory = new ProtocolFactory();
        CertStore certStore = VecsUtil.getVecsCrlCertStore();
        HttpConfiguration.SslConfiguration sslConfiguration = new HttpConfiguration.SslConfiguration(this._ksService.getKeyStore(), null, null, certStore);
        HttpConfiguration.Builder builder = new HttpConfiguration.Builder().setSslConfiguration(sslConfiguration);
        if (Config.VAPI_SOCKET_CONNECTION_TIMEOUT != Timeout.DEFAULT) {
            builder.setConnectTimeout(Config.VAPI_SOCKET_CONNECTION_TIMEOUT.toIntMillis());
        }
        if (Config.VAPI_SOCKET_TIMEOUT != Timeout.DEFAULT) {
            builder.setSoTimeout(Config.VAPI_SOCKET_TIMEOUT.toIntMillis());
        }
        if (Config.VAPI_MAX_CONNECTIONS > 0) {
            builder.setMaxConnections(Config.VAPI_MAX_CONNECTIONS);
        }
        HttpConfiguration httpConfiguration = builder.getConfig();
        ProtocolConnection protocolConnection = protocolFactory.getHttpConnection(this._endpointUrl.toString(), new ClientConfiguration.Builder().setExecutor((Executor)this._asyncCallExecutor).getConfig(), httpConfiguration);
        _logger.info((Object)("Connected to vAPI endpoint " + this._endpointUrl));
        return protocolConnection;
    }
}

