/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vmca;

import com.vmware.certificate.VMCAClient;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.VimServicesUtil;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vise.vim.vmca.VmcaService;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmcaServiceImpl
implements VmcaService {
    private static final Log _logger = LogFactory.getLog(VmcaServiceImpl.class);
    private static final String VMCA_CLIENTS_CACHE_KEY = "vmcaclientlist";

    @Override
    public X509Spec[] getActiveCertificates(String string) {
        return this.getCertificates(string, VMCAClient.certFilters.ACTIVE_CERTIFICATES);
    }

    @Override
    public X509Spec[] getRevokedCertificates(String string) {
        return this.getCertificates(string, VMCAClient.certFilters.REVOKED_CERTIFICATES);
    }

    @Override
    public X509Spec[] getExpiredCertificates(String string) {
        return this.getCertificates(string, VMCAClient.certFilters.EXPIRED_CERTIFICATES);
    }

    private VMCAClient retrieveVMCAClient(String string) {
        ConcurrentHashMap concurrentHashMap = this.getVmcaClientMap();
        VMCAClient vMCAClient = null;
        vMCAClient = (VMCAClient)concurrentHashMap.get(string);
        return vMCAClient;
    }

    private synchronized void saveVmcaClient(ConcurrentHashMap concurrentHashMap) {
        SessionUtil.setData((String)VMCA_CLIENTS_CACHE_KEY, (Object)concurrentHashMap);
    }

    @Override
    public synchronized ConcurrentHashMap getVmcaClientMap() {
        return (ConcurrentHashMap)SessionUtil.getData((String)VMCA_CLIENTS_CACHE_KEY);
    }

    @Override
    public void createVmcaClient(String string, String string2, String string3, String string4) {
        VMCAClient vMCAClient = null;
        ConcurrentHashMap concurrentHashMap = this.getVmcaClientMap();
        if (concurrentHashMap == null) {
            ConcurrentHashMap<String, VMCAClient> concurrentHashMap2 = new ConcurrentHashMap<String, VMCAClient>();
            try {
                vMCAClient = new VMCAClient(string2, string4, string3, string);
                concurrentHashMap2.put(string, vMCAClient);
                this.saveVmcaClient(concurrentHashMap2);
                this.getRootCertificate(string);
            }
            catch (Exception exception) {
                _logger.error((Object)("Error when getting vmca client object on  " + string), (Throwable)exception);
                throw new RuntimeException(String.format(VimServicesUtil.getLocalizedString("vmca.getVMCAClientError", new String[0]), string), exception);
            }
        }
        try {
            vMCAClient = new VMCAClient(string2, string4, string3, string);
            concurrentHashMap.put(string, vMCAClient);
            this.saveVmcaClient(concurrentHashMap);
            this.getRootCertificate(string);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error when getting vmca client object on  " + string), (Throwable)exception);
            throw new RuntimeException(String.format(VimServicesUtil.getLocalizedString("vmca.getVMCAClientError", new String[0]), string), exception);
        }
    }

    @Override
    public X509Spec[][] getRootCertificate(String string) {
        X509Spec[][] x509SpecArray = null;
        try {
            VMCAClient vMCAClient = this.retrieveVMCAClient(string);
            if (vMCAClient != null) {
                X509Certificate x509Certificate = vMCAClient.getRootCertificate();
                X509Spec x509Spec = new X509Spec(x509Certificate);
                x509SpecArray = new X509Spec[1][1];
                x509SpecArray[0] = new X509Spec[]{x509Spec};
            }
        }
        catch (Throwable throwable) {
            _logger.error((Object)("Error when fetching root certificates from " + string), throwable);
            throw new RuntimeException(String.format(VimServicesUtil.getLocalizedString("vmca.fetchRootCertificateError", new String[0]), string), throwable);
        }
        return x509SpecArray;
    }

    private X509Spec[] getCertificates(String string, VMCAClient.certFilters certFilters2) {
        ArrayList<X509Spec> arrayList = new ArrayList<X509Spec>();
        try {
            VMCAClient vMCAClient = this.retrieveVMCAClient(string);
            vMCAClient.setEnumFilter(certFilters2);
            for (X509Certificate x509Certificate : vMCAClient) {
                X509Spec x509Spec = new X509Spec(x509Certificate);
                arrayList.add(x509Spec);
            }
        }
        catch (Throwable throwable) {
            _logger.error((Object)("Error when fetching certificates from " + string), throwable);
            throw new RuntimeException(String.format(VimServicesUtil.getLocalizedString("vmca.fetchCertificatesError", new String[0]), string), throwable);
        }
        return arrayList.toArray(new X509Spec[0]);
    }
}

