/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.validator;

import org.opensaml.saml2.metadata.Organization;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public class OrganizationSchemaValidator
implements Validator<Organization> {
    @Override
    public void validate(Organization organization) throws ValidationException {
        this.validateName(organization);
        this.validateDisplayName(organization);
        this.validateURL(organization);
    }

    protected void validateName(Organization organization) throws ValidationException {
        if (organization.getOrganizationNames() == null || organization.getOrganizationNames().size() < 1) {
            throw new ValidationException("Must have one or more Organization Names.");
        }
    }

    protected void validateDisplayName(Organization organization) throws ValidationException {
        if (organization.getDisplayNames() == null || organization.getDisplayNames().size() < 1) {
            throw new ValidationException("Must have one or more Display Names.");
        }
    }

    protected void validateURL(Organization organization) throws ValidationException {
        if (organization.getURLs() == null || organization.getURLs().size() < 1) {
            throw new ValidationException("Must have one or more Organization URLs.");
        }
    }
}

