/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.impl;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricStatValue;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceMetricTimeIntervals;
import com.vmware.opsmgmt.client.advperfcharts.UtilizationStat;
import com.vmware.opsmgmt.client.advperfcharts.util.Constants;
import com.vmware.opsmgmt.client.advperfcharts.util.FaultToleranceInfoCollector;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceCounterCollector;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceStatsCollector;
import com.vmware.opsmgmt.client.advperfcharts.util.builder.TotalFTPerformanceCounter;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceCountersPropertyProvider
implements PropertyProviderBean {
    private static final String RESOURCE_BUNDLE_NAME = "AdvPerfCharts";
    private static final String GROUP_ID_RESCPU = "rescpu";
    private static final String GROUP_ID_DISK = "disk";
    private static final String COUNTER_ID_CAPACITY = "capacity";
    private static final String COUNTER_ID_USED = "used";
    private static final String DELTAFILE = "DELTAFILE";
    private static final String DISKFILE = "DISKFILE";
    private static final String OTHERFILE = "OTHERFILE";
    private static final String SWAPFILE = "SWAPFILE";
    private static final String OTHER = "OTHER";
    private static final String CAPACITY = "CAPACITY";
    private static final String FREE = "FREE";
    private static final String TOTAL_USED = "";
    private static final String[] NOT_USED_KEY_NAMES = new String[]{"used", "provisioned", "unshared"};
    private static final HashSet<String> SPACE_UTILIZATION_COUNTERS = new HashSet<String>(Arrays.asList("capacity", "used"));
    private static final HashSet<String> DISK_USAGE_TYPE = new HashSet<String>(Arrays.asList("DELTAFILE", "DISKFILE", "OTHERFILE", "SWAPFILE", ""));
    private static final Log _logger = LogFactory.getLog(PerformanceCountersPropertyProvider.class);
    private final DataService _dataService;

    public PerformanceCountersPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="Datacenter,ResourcePool,ClusterComputeResource,HostSystem,VirtualMachine,VirtualApp")
    public PerformanceCounter[] getAvailablePerformanceCounters(ManagedObjectReference managedObjectReference) throws Exception {
        Object object3;
        List<PerformanceCounter> list;
        Object object2;
        ManagedObjectReference managedObjectReference2;
        PerformanceManager performanceManager = PerformanceCountersPropertyProvider.retrievePerfManager(managedObjectReference.getServerGuid());
        _logger.info((Object)("Performance counters requested for object " + managedObjectReference));
        PerformanceCounterCollector performanceCounterCollector = new PerformanceCounterCollector(managedObjectReference, this._dataService, performanceManager);
        List<PerformanceCounter> list2 = performanceCounterCollector.getAvailableCountersSorted();
        if (Constants.TYPE_VM.equals(managedObjectReference.getType()) && (managedObjectReference2 = ((FaultToleranceInfoCollector)(object2 = new FaultToleranceInfoCollector(this._dataService, managedObjectReference))).getSecondaryVmRef()) != null && (list = ((PerformanceCounterCollector)(object3 = new PerformanceCounterCollector(managedObjectReference2, this._dataService, performanceManager))).getAvailableCountersSorted()) != null) {
            TotalFTPerformanceCounter totalFTPerformanceCounter = new TotalFTPerformanceCounter();
            List<PerformanceCounter> list3 = totalFTPerformanceCounter.buildTotalCounters(list2, list);
            list2.addAll(list);
            list2.addAll(list3);
        }
        object2 = new ArrayList(list2.size());
        for (Object object3 : list2) {
            if (!this.isMeaningfulForUser((PerformanceCounter)((Object)object3))) continue;
            object2.add(object3);
        }
        return object2.toArray(new PerformanceCounter[0]);
    }

    @type(value="Datacenter,ResourcePool,ClusterComputeResource,HostSystem,VirtualMachine,VirtualApp")
    public Map<String, Map<String, List<PerformanceCounter>>> getPerformanceCounterGroups(ManagedObjectReference managedObjectReference) throws Exception {
        PerformanceCounter[] performanceCounterArray = this.getAvailablePerformanceCounters(managedObjectReference);
        HashMap<String, Map<String, List<PerformanceCounter>>> hashMap = new HashMap<String, Map<String, List<PerformanceCounter>>>();
        for (PerformanceCounter performanceCounter : performanceCounterArray) {
            List<PerformanceCounter> list;
            Map map;
            String string = performanceCounter.groupId;
            String string2 = performanceCounter.nameKey + "." + performanceCounter.rollupType;
            if (hashMap.containsKey(string)) {
                map = (Map)hashMap.get(string);
            } else {
                map = new HashMap();
                hashMap.put(string, map);
            }
            if (map.containsKey(string2)) {
                list = (List)map.get(string2);
            } else {
                list = new ArrayList();
                map.put(string2, list);
            }
            list.add(performanceCounter);
        }
        return hashMap;
    }

    @type(value="Datastore")
    public List<UtilizationStat> getSpaceUtilizationByType(ManagedObjectReference managedObjectReference) throws Exception {
        PerformanceManager performanceManager = PerformanceCountersPropertyProvider.retrievePerfManager(managedObjectReference.getServerGuid());
        PerformanceCounterCollector performanceCounterCollector = new PerformanceCounterCollector(managedObjectReference, this._dataService, performanceManager);
        List<PerformanceCounter> list = performanceCounterCollector.getAvailableCountersSorted();
        PerformanceInfoQuerySpec performanceInfoQuerySpec = PerformanceCountersPropertyProvider.getSpaceUtilizationQuerySpec(list);
        PerformanceStatsCollector performanceStatsCollector = new PerformanceStatsCollector(managedObjectReference, this._dataService, performanceInfoQuerySpec);
        List<PerformanceCounterStats> list2 = performanceStatsCollector.getStats();
        return PerformanceCountersPropertyProvider.getSpaceUtilizationStats(list2);
    }

    private static PerformanceInfoQuerySpec getSpaceUtilizationQuerySpec(List<PerformanceCounter> list) {
        ArrayList<PerformanceManager.MetricId> arrayList = new ArrayList<PerformanceManager.MetricId>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (PerformanceCounter performanceCounter : list) {
            if (!GROUP_ID_DISK.equals(performanceCounter.groupId) || !SPACE_UTILIZATION_COUNTERS.contains(performanceCounter.nameKey) || performanceCounter.metricId == null || !DISK_USAGE_TYPE.contains(performanceCounter.metricId.instance)) continue;
            arrayList.add(performanceCounter.metricId);
            if (performanceCounter.relatedDeviceId == null) continue;
            arrayList2.add(performanceCounter.relatedDeviceId);
        }
        Object object = new PerformanceInfoQuerySpec();
        ((PerformanceInfoQuerySpec)((Object)object)).interval = PerformanceMetricTimeIntervals.RAW_DATA_FEED;
        ((PerformanceInfoQuerySpec)((Object)object)).metricIds = arrayList.toArray(new PerformanceManager.MetricId[arrayList.size()]);
        ((PerformanceInfoQuerySpec)((Object)object)).relatedDeviceIds = arrayList2;
        ((PerformanceInfoQuerySpec)((Object)object)).availableCounters = list;
        ((PerformanceInfoQuerySpec)((Object)object)).format = PerformanceManager.Format.csv;
        return object;
    }

    private static List<UtilizationStat> getSpaceUtilizationStats(List<PerformanceCounterStats> list) {
        ArrayList<UtilizationStat> arrayList = new ArrayList<UtilizationStat>();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (PerformanceCounterStats performanceCounterStats : list) {
            String string;
            PerformanceMetricStatValue[] performanceMetricStatValueArray = performanceCounterStats.statistics;
            PerformanceMetricStatValue performanceMetricStatValue = !ArrayUtil.isNullOrEmpty((Object[])performanceMetricStatValueArray) ? performanceMetricStatValueArray[performanceMetricStatValueArray.length - 1] : null;
            Float f4 = performanceMetricStatValue != null ? Float.valueOf(performanceMetricStatValue.value) : null;
            PerformanceCounter performanceCounter = performanceCounterStats.performanceCounter;
            String string2 = performanceCounter.nameKey;
            if (COUNTER_ID_CAPACITY.equals(string2)) {
                f = f4.floatValue();
                continue;
            }
            if (!COUNTER_ID_USED.equals(string2)) continue;
            switch (string = performanceCounter.metricId.instance) {
                case "DISKFILE": 
                case "OTHERFILE": 
                case "DELTAFILE": 
                case "SWAPFILE": {
                    if (f4 == null || !(f4.floatValue() > 0.0f)) break;
                    f3 += f4 != null ? f4.floatValue() : 0.0f;
                    arrayList.add(PerformanceCountersPropertyProvider.createUtilizationStat(string, f4));
                    break;
                }
                case "": {
                    f2 = f4.floatValue();
                }
            }
        }
        float f5 = f2 - f3;
        if (f5 > 0.0f) {
            arrayList.add(PerformanceCountersPropertyProvider.createUtilizationStat(OTHER, Float.valueOf(f5)));
        }
        arrayList.add(PerformanceCountersPropertyProvider.createUtilizationStat(FREE, Float.valueOf(f - f2)));
        arrayList.add(PerformanceCountersPropertyProvider.createUtilizationStat(CAPACITY, Float.valueOf(f)));
        return arrayList;
    }

    private static UtilizationStat createUtilizationStat(String string, Float f) {
        String string2 = FormatUtil.getStorageFormatted((Long)(f != null ? f.longValue() : 0L), (long)1024L, (long)-1L);
        UtilizationStat utilizationStat = new UtilizationStat();
        utilizationStat.name = PerformanceCountersPropertyProvider.getString(string, string2);
        utilizationStat.ID = string;
        utilizationStat.y = f;
        return utilizationStat;
    }

    private static String getString(String string, String ... stringArray) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (String[])stringArray, (ClassLoader)PerformanceCountersPropertyProvider.class.getClassLoader());
    }

    private boolean isMeaningfulForUser(PerformanceCounter performanceCounter) {
        if (GROUP_ID_RESCPU.equals(performanceCounter.groupId)) {
            return false;
        }
        return !GROUP_ID_DISK.equals(performanceCounter.groupId) || !Arrays.asList(NOT_USED_KEY_NAMES).contains(performanceCounter.nameKey);
    }

    private static PerformanceManager retrievePerfManager(String string) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)string);
        ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
        return (PerformanceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceInstanceContent.perfManager);
    }
}

