/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounter;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.util.BasePerformanceStats;
import com.vmware.opsmgmt.client.advperfcharts.util.PerformanceMetricIdInfoCollector;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositePerformanceStats
extends BasePerformanceStats {
    private static final Log _logger = LogFactory.getLog(CompositePerformanceStats.class);

    public CompositePerformanceStats(ManagedObjectReference managedObjectReference, DataService dataService, PerformanceInfoQuerySpec performanceInfoQuerySpec) throws Exception {
        super(managedObjectReference, dataService, performanceInfoQuerySpec);
    }

    @Override
    protected PerformanceManager.QuerySpec prepareQuerySpec() {
        PerformanceManager.QuerySpec querySpec = this.initBaseQuerySpec();
        PerformanceManager.MetricId metricId = new PerformanceManager.MetricId();
        metricId.instance = "";
        if (this.hasCoutnerIdsItems()) {
            metricId.counterId = this.originalParams.counterIds.get(0);
        }
        querySpec.metricId = new PerformanceManager.MetricId[1];
        querySpec.metricId[0] = metricId;
        return querySpec;
    }

    @Override
    protected List<PerformanceCounterStats> executeQuery(PerformanceManager.QuerySpec querySpec) throws Exception {
        ArrayList<PerformanceCounterStats> arrayList = new ArrayList<PerformanceCounterStats>();
        if (querySpec.metricId.length == 0) {
            return arrayList;
        }
        _logger.debug((Object)("Calling PerformanceManager.queryCompositeStats(" + querySpec + ")"));
        PerformanceManager.CompositeEntityMetric compositeEntityMetric = this.perfManager.queryCompositeStats(querySpec);
        if (this.isHostStatsRequested()) {
            arrayList.addAll(this.retrieveHostStats(compositeEntityMetric));
        }
        arrayList.addAll(this.retrieveRequestedVMStats(compositeEntityMetric));
        return arrayList;
    }

    private List<PerformanceCounterStats> retrieveHostStats(PerformanceManager.CompositeEntityMetric compositeEntityMetric) {
        ArrayList<PerformanceCounterStats> arrayList = new ArrayList<PerformanceCounterStats>();
        PerformanceManager.EntityMetricBase entityMetricBase = compositeEntityMetric.entity;
        PerformanceManager.EntityMetric entityMetric = (PerformanceManager.EntityMetric)entityMetricBase;
        if (entityMetric != null && entityMetric.getValue() != null && entityMetric.getSampleInfo() != null) {
            PerformanceManager.MetricSeries[] metricSeriesArray;
            PerformanceManager.SampleInfo[] sampleInfoArray = entityMetric.getSampleInfo();
            for (PerformanceManager.MetricSeries metricSeries : metricSeriesArray = entityMetric.getValue()) {
                Date[] dateArray = new Date[sampleInfoArray.length];
                for (int i = 0; i < sampleInfoArray.length; ++i) {
                    dateArray[i] = sampleInfoArray[i].timestamp.getTime();
                }
                PerformanceCounterStats performanceCounterStats = new PerformanceCounterStats();
                performanceCounterStats.performanceCounter = this.findCounterInfo(metricSeries.getId());
                performanceCounterStats.statistics = this.createPerfMetricStatsValues(dateArray, ((PerformanceManager.IntSeries)metricSeries).value, performanceCounterStats.performanceCounter.statsUnitKey, performanceCounterStats.performanceCounter.isUptime);
                arrayList.add(performanceCounterStats);
            }
        }
        return arrayList;
    }

    private List<PerformanceCounterStats> retrieveRequestedVMStats(PerformanceManager.CompositeEntityMetric compositeEntityMetric) {
        ArrayList<PerformanceCounterStats> arrayList = new ArrayList<PerformanceCounterStats>();
        PerformanceManager.EntityMetricBase[] entityMetricBaseArray = compositeEntityMetric.childEntity;
        if (entityMetricBaseArray != null) {
            for (PerformanceManager.EntityMetricBase entityMetricBase : entityMetricBaseArray) {
                PerformanceManager.EntityMetric entityMetric = (PerformanceManager.EntityMetric)entityMetricBase;
                PerformanceManager.SampleInfo[] sampleInfoArray = entityMetric.getSampleInfo();
                if (entityMetric.getValue() == null) continue;
                for (PerformanceManager.MetricSeries metricSeries : entityMetric.getValue()) {
                    PerformanceMetricIdInfoCollector performanceMetricIdInfoCollector = new PerformanceMetricIdInfoCollector(this.perfManager, this.dataService, metricSeries.getId().counterId, entityMetric.entity);
                    PerformanceCounter performanceCounter = performanceMetricIdInfoCollector.getPerformanceCounters().get(0);
                    if (!this.isVmRequested(performanceCounter.relatedDeviceName)) continue;
                    Date[] dateArray = new Date[sampleInfoArray != null ? sampleInfoArray.length : 0];
                    if (sampleInfoArray != null) {
                        for (int i = 0; i < sampleInfoArray.length; ++i) {
                            dateArray[i] = sampleInfoArray[i].timestamp.getTime();
                        }
                    }
                    PerformanceCounterStats performanceCounterStats = new PerformanceCounterStats();
                    performanceCounterStats.performanceCounter = performanceCounter;
                    performanceCounterStats.statistics = this.createPerfMetricStatsValues(dateArray, ((PerformanceManager.IntSeries)metricSeries).value, performanceCounterStats.performanceCounter.statsUnitKey, performanceCounterStats.performanceCounter.isUptime);
                    arrayList.add(performanceCounterStats);
                }
            }
        }
        return arrayList;
    }

    private boolean isVmRequested(String string) {
        List<String> list = this.originalParams.relatedDeviceIds;
        return list.contains("*") || list.contains(string);
    }

    private boolean isHostStatsRequested() {
        List<String> list = this.originalParams.relatedDeviceIds;
        return list.contains("*") || list.contains("");
    }
}

