/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.FaultToleranceConfigInfo;
import com.vmware.vim.binding.vim.vm.FaultTolerancePrimaryConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FaultToleranceInfoCollector {
    private static final Log _logger = LogFactory.getLog(FaultToleranceInfoCollector.class);
    private static String PROPERTY_VM_FT_INFO = "config.ftInfo";
    private static String PROPERTY_VM_FT_STATE = "runtime.faultToleranceState";
    private DataService _dataService;
    private ManagedObjectReference _moRef;
    private FaultToleranceConfigInfo _ftInfo;
    private VirtualMachine.FaultToleranceState _ftState;

    public FaultToleranceInfoCollector(DataService dataService, ManagedObjectReference managedObjectReference) {
        this._dataService = dataService;
        this._moRef = managedObjectReference;
        try {
            PropertyValue[] propertyValueArray = QueryUtil.getProperties((DataService)dataService, (Object)managedObjectReference, (String[])new String[]{PROPERTY_VM_FT_INFO, PROPERTY_VM_FT_STATE});
            this._ftInfo = null;
            this._ftState = null;
            for (PropertyValue propertyValue : propertyValueArray) {
                if (propertyValue.propertyName.equals(PROPERTY_VM_FT_INFO)) {
                    this._ftInfo = (FaultToleranceConfigInfo)propertyValue.value;
                }
                if (!propertyValue.propertyName.equals(PROPERTY_VM_FT_STATE)) continue;
                this._ftState = (VirtualMachine.FaultToleranceState)propertyValue.value;
            }
        }
        catch (Exception exception) {
            this._ftInfo = null;
            this._ftState = null;
            _logger.error((Object)exception);
        }
    }

    public ManagedObjectReference getSecondaryVmRef() throws Exception {
        ManagedObjectReference managedObjectReference = null;
        if (this.isPrimary()) {
            FaultToleranceConfigInfo faultToleranceConfigInfo = (FaultToleranceConfigInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)this._moRef, (String)PROPERTY_VM_FT_INFO);
            if (!(faultToleranceConfigInfo instanceof FaultTolerancePrimaryConfigInfo)) {
                return managedObjectReference;
            }
            FaultTolerancePrimaryConfigInfo faultTolerancePrimaryConfigInfo = (FaultTolerancePrimaryConfigInfo)faultToleranceConfigInfo;
            if (faultTolerancePrimaryConfigInfo != null && faultTolerancePrimaryConfigInfo.secondaries != null && faultTolerancePrimaryConfigInfo.secondaries.length > 0) {
                managedObjectReference = faultTolerancePrimaryConfigInfo.secondaries[0];
            }
        }
        return managedObjectReference;
    }

    public boolean isFtConfigured() {
        return this._ftState != null && this._ftState != VirtualMachine.FaultToleranceState.notConfigured;
    }

    public boolean isPrimary() {
        return this.isFtConfigured() && this._ftInfo != null && this._ftInfo.role == 1;
    }

    public boolean isSecondaryVm() {
        return this.isFtConfigured() && this._ftInfo != null && this._ftInfo.role > 1;
    }
}

