/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.advperfcharts.util;

import com.vmware.opsmgmt.client.advperfcharts.PerformanceCounterStats;
import com.vmware.opsmgmt.client.advperfcharts.PerformanceInfoQuerySpec;
import com.vmware.opsmgmt.client.advperfcharts.util.BasePerformanceStats;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceStats
extends BasePerformanceStats {
    private static final Log _logger = LogFactory.getLog(PerformanceStats.class);

    public PerformanceStats(ManagedObjectReference managedObjectReference, DataService dataService, PerformanceInfoQuerySpec performanceInfoQuerySpec) throws Exception {
        super(managedObjectReference, dataService, performanceInfoQuerySpec);
    }

    @Override
    protected PerformanceManager.QuerySpec prepareQuerySpec() {
        PerformanceManager.QuerySpec querySpec = this.initBaseQuerySpec();
        ArrayList<PerformanceManager.MetricId> arrayList = new ArrayList<PerformanceManager.MetricId>();
        if (this.hasMetricIdsItems()) {
            arrayList.addAll(Arrays.asList(this.originalParams.metricIds));
        }
        if (this.hasCoutnerIdsItems() && this.hasRelatedDeviceIdsItems()) {
            List<PerformanceManager.MetricId> list = this.getAvailableMetricIds(this.originalParams.counterIds, this.originalParams.relatedDeviceIds, this.originalParams.interval);
            arrayList.addAll(list);
        }
        querySpec.metricId = arrayList.toArray(new PerformanceManager.MetricId[0]);
        return querySpec;
    }

    @Override
    protected List<PerformanceCounterStats> executeQuery(PerformanceManager.QuerySpec querySpec) {
        if (querySpec.metricId.length == 0) {
            return Collections.emptyList();
        }
        _logger.debug((Object)("Calling PerfomanceManager.queryStats([" + querySpec + "])"));
        PerformanceManager.EntityMetricBase[] entityMetricBaseArray = this.perfManager.queryStats(new PerformanceManager.QuerySpec[]{querySpec});
        if (entityMetricBaseArray == null) {
            return Collections.emptyList();
        }
        return this.processResults(entityMetricBaseArray);
    }

    private List<PerformanceCounterStats> processResults(PerformanceManager.EntityMetricBase[] entityMetricBaseArray) {
        ArrayList<PerformanceCounterStats> arrayList = new ArrayList<PerformanceCounterStats>();
        for (PerformanceManager.EntityMetricBase entityMetricBase : entityMetricBaseArray) {
            PerformanceManager.MetricSeries[] metricSeriesArray = null;
            if (entityMetricBase instanceof PerformanceManager.EntityMetric) {
                metricSeriesArray = ((PerformanceManager.EntityMetric)entityMetricBase).getValue();
            } else if (entityMetricBase instanceof PerformanceManager.EntityMetricCSV) {
                metricSeriesArray = ((PerformanceManager.EntityMetricCSV)entityMetricBase).getValue();
            }
            if (metricSeriesArray == null) continue;
            for (PerformanceManager.MetricSeries metricSeries : metricSeriesArray) {
                long[] lArray = PerformanceStats.extractValues(metricSeries);
                Date[] dateArray = PerformanceStats.extractSamples(entityMetricBase);
                PerformanceCounterStats performanceCounterStats = new PerformanceCounterStats();
                performanceCounterStats.performanceCounter = this.findCounterInfo(metricSeries.getId());
                performanceCounterStats.statistics = this.createPerfMetricStatsValues(dateArray, lArray, performanceCounterStats.performanceCounter.statsUnitKey, performanceCounterStats.performanceCounter.isUptime);
                arrayList.add(performanceCounterStats);
            }
        }
        return arrayList;
    }

    private static Date[] extractSamples(PerformanceManager.EntityMetricBase entityMetricBase) {
        Date[] dateArray;
        block4: {
            block3: {
                dateArray = new Date[]{};
                if (!(entityMetricBase instanceof PerformanceManager.EntityMetric)) break block3;
                PerformanceManager.SampleInfo[] sampleInfoArray = ((PerformanceManager.EntityMetric)entityMetricBase).getSampleInfo();
                if (sampleInfoArray == null) break block4;
                dateArray = new Date[sampleInfoArray.length];
                for (int i = 0; i < sampleInfoArray.length; ++i) {
                    dateArray[i] = sampleInfoArray[i].timestamp.getTime();
                }
                break block4;
            }
            if (entityMetricBase instanceof PerformanceManager.EntityMetricCSV) {
                PerformanceManager.EntityMetricCSV entityMetricCSV = (PerformanceManager.EntityMetricCSV)entityMetricBase;
                String[] stringArray = entityMetricCSV.getSampleInfoCSV().split(",");
                dateArray = new Date[stringArray.length / 2];
                for (int i = 1; i < stringArray.length; i += 2) {
                    dateArray[i / 2] = DatatypeConverter.parseDateTime((String)stringArray[i]).getTime();
                }
            }
        }
        return dateArray;
    }

    private static long[] extractValues(PerformanceManager.MetricSeries metricSeries) {
        long[] lArray = new long[]{};
        if (metricSeries instanceof PerformanceManager.IntSeries) {
            lArray = ((PerformanceManager.IntSeries)metricSeries).value;
        } else if (metricSeries instanceof PerformanceManager.MetricSeriesCSV) {
            PerformanceManager.MetricSeriesCSV metricSeriesCSV = (PerformanceManager.MetricSeriesCSV)metricSeries;
            String[] stringArray = metricSeriesCSV.getValue().split(",");
            lArray = new long[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                lArray[i] = StringUtil.isNullOrEmpty((String)string) ? 0L : Long.parseLong(string);
            }
        }
        return lArray;
    }
}

