/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.internal.provider.util.SchemaUtil;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.Validate;

public final class DefaultRequestPropertyValidator
implements RequestPropertyValidator {
    private final QuerySchema _schema;

    public DefaultRequestPropertyValidator(QuerySchema querySchema) {
        this._schema = querySchema;
    }

    @Override
    public List<String> getSelectableProperties(Collection<String> collection) {
        Validate.notNull(collection, (String)"Argument `coreProperties' is required.");
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (String string : collection) {
            if (!this.canSelectByProperty(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public boolean canSelectByProperty(String string) {
        Validate.notEmpty((String)string, (String)"Argument `coreProperty' is required.");
        QuerySchema.PropertyInfo propertyInfo = this.getPropertyInfo(string);
        return propertyInfo != null;
    }

    @Override
    public boolean canFilterByProperty(String string) {
        Validate.notEmpty((String)string, (String)"Argument `coreProperty' is required.");
        return this.isSupportedFilterableProperty(string);
    }

    @Override
    public boolean canUseUnsetOnProperty(String string) {
        Validate.notEmpty((String)string, (String)"Argument `coreProperty' is required.");
        QuerySchema.PropertyInfo propertyInfo = this.getPropertyInfo(string);
        if (propertyInfo == null) {
            return false;
        }
        return propertyInfo.getFilterable() || propertyInfo.getFilterableByUnset();
    }

    @Override
    public boolean canOrderByProperty(String string) {
        Validate.notEmpty((String)string, (String)"Argument `coreProperty' is required.");
        return this.isSupportedFilterableProperty(string);
    }

    @Override
    public boolean isModelSupported(String string) {
        Validate.notEmpty((String)string, (String)"Argument `model' is required.");
        return this._schema.getModels().containsKey(string);
    }

    @Override
    public QuerySchema.PropertyInfo getPropertyInfo(String string) {
        Validate.notEmpty((String)string, (String)"Argument `coreProperty' is required.");
        if (PropertyUtil.isModelKey((String)string)) {
            return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ID);
        }
        if (PropertyUtil.isType((String)string)) {
            return QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING);
        }
        return SchemaUtil.getPropertyInfoForQualifiedName((QuerySchema)this._schema, (String)string);
    }

    private boolean isSupportedFilterableProperty(String string) {
        QuerySchema.PropertyInfo propertyInfo = this.getPropertyInfo(string);
        if (propertyInfo == null) {
            return false;
        }
        return propertyInfo.getFilterable();
    }
}

