/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.vmware.vise.core.model.IdentifiableGenerationNumber;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectPropertyRequestReducerDecorator
implements DynamicProviderAdapter {
    private static final Logger _logger = LoggerFactory.getLogger(ObjectPropertyRequestReducerDecorator.class);
    private final DynamicProviderAdapter _delegate;

    public ObjectPropertyRequestReducerDecorator(DynamicProviderAdapter dynamicProviderAdapter) {
        this._delegate = dynamicProviderAdapter;
    }

    public Response getData(RequestSpec requestSpec) throws Exception {
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        if (ArrayUtils.getLength((Object)querySpecArray) <= 1) {
            return this._delegate.getData(requestSpec);
        }
        QuerySpecSplit querySpecSplit = this.extractObjectPropertyRequestQueries(querySpecArray);
        int n = querySpecSplit.nonReducibleQueries.size() + querySpecSplit.reducibleQueriesByObject.keySet().size();
        if (n >= querySpecArray.length) {
            return this._delegate.getData(requestSpec);
        }
        RequestSpec requestSpec2 = this.createReducedRequestSpec(requestSpec.enableProfiling, querySpecSplit);
        _logger.debug("Query batch reduced from {} to {}.", (Object)querySpecArray.length, (Object)requestSpec2.querySpec.length);
        _logger.trace("Start {}.getData() for reduced request.", (Object)this.getClass().getSimpleName());
        Response response = this._delegate.getData(requestSpec2);
        Response response2 = this.remapResultsToOriginalRequest(querySpecArray, querySpecSplit, requestSpec2, response);
        if (_logger.isTraceEnabled()) {
            _logger.trace("{}.getData() done. Original queries were: {}", (Object)this.getClass().getSimpleName(), (Object)Utils.renderQuerySpecs((QuerySpec[])requestSpec.querySpec));
            _logger.trace("Result mapped to original queries: " + Utils.renderResultSets((ResultSet[])response2.resultSet));
        }
        return response2;
    }

    private QuerySpecSplit extractObjectPropertyRequestQueries(QuerySpec[] querySpecArray) {
        assert (querySpecArray != null && querySpecArray.length > 1);
        ArrayList<QuerySpec> arrayList = new ArrayList<QuerySpec>();
        HashMultimap hashMultimap = HashMultimap.create();
        for (QuerySpec querySpec : querySpecArray) {
            ObjectIdentityConstraint objectIdentityConstraint = this.getSingleObjectConstraint(querySpec);
            if (objectIdentityConstraint != null) {
                hashMultimap.put((Object)objectIdentityConstraint, (Object)querySpec);
                continue;
            }
            arrayList.add(querySpec);
        }
        return new QuerySpecSplit(arrayList, (Multimap<ObjectIdentityConstraint, QuerySpec>)hashMultimap);
    }

    private RequestSpec createReducedRequestSpec(Boolean bl, QuerySpecSplit querySpecSplit) {
        QuerySpec[] querySpecArray = new QuerySpec[querySpecSplit.nonReducibleQueries.size() + querySpecSplit.reducibleQueriesByObject.keySet().size()];
        int n = 0;
        for (Map.Entry querySpec : querySpecSplit.reducibleQueriesByObject.asMap().entrySet()) {
            QuerySpec querySpec2;
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)querySpec.getKey();
            Collection collection = (Collection)querySpec.getValue();
            querySpecArray[n] = querySpec2 = this.createMergedPropertyRequest(objectIdentityConstraint, collection);
            ++n;
        }
        RequestSpec requestSpec = querySpecSplit.nonReducibleQueries.iterator();
        while (requestSpec.hasNext()) {
            QuerySpec querySpec;
            querySpecArray[n] = querySpec = (QuerySpec)requestSpec.next();
            ++n;
        }
        requestSpec = new RequestSpec();
        requestSpec.enableProfiling = bl;
        requestSpec.querySpec = querySpecArray;
        return requestSpec;
    }

    private QuerySpec createMergedPropertyRequest(ObjectIdentityConstraint objectIdentityConstraint, Collection<QuerySpec> collection) {
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        ArrayList<String> arrayList2 = new ArrayList<String>(collection.size());
        for (QuerySpec querySpec : collection) {
            arrayList2.add(querySpec.name);
            arrayList.addAll(ObjectPropertyRequestReducerDecorator.getPropertySpecList(querySpec));
        }
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = "combined(" + StringUtils.join(arrayList2, (String)",") + ")";
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.constraint = objectIdentityConstraint;
        querySpec.resourceSpec.propertySpecs = arrayList.toArray(new PropertySpec[arrayList.size()]);
        return querySpec;
    }

    private Response remapResultsToOriginalRequest(QuerySpec[] querySpecArray, QuerySpecSplit querySpecSplit, RequestSpec requestSpec, Response response) {
        ObjectPropertyResults objectPropertyResults = this.getObjectPropertiesFromReducedQueryResults(querySpecSplit, requestSpec, response);
        DynamicProviderResultSet[] dynamicProviderResultSetArray = new DynamicProviderResultSet[querySpecArray.length];
        for (int i = 0; i < querySpecArray.length; ++i) {
            QuerySpec querySpec = querySpecArray[i];
            dynamicProviderResultSetArray[i] = querySpecSplit.nonReducibleQueries.contains(querySpec) ? this.getResultForNonReducibleQuery(querySpec, requestSpec, response) : this.createResultForReducibleQuery(querySpec, objectPropertyResults);
        }
        Response response2 = new Response();
        response2.resultSet = dynamicProviderResultSetArray;
        response2.executionTimeByDescription = response.executionTimeByDescription;
        return response2;
    }

    private ResultSet getResultForNonReducibleQuery(QuerySpec querySpec, RequestSpec requestSpec, Response response) {
        int n = ArrayUtils.indexOf((Object[])requestSpec.querySpec, (Object)querySpec);
        assert (n != -1) : "Non-reducible query not found on the reduced RequestSpec";
        return response.resultSet[n];
    }

    private ResultSet createResultForReducibleQuery(QuerySpec querySpec, ObjectPropertyResults objectPropertyResults) {
        Exception exception;
        ResultItem[] resultItemArray;
        DynamicProviderResultSet dynamicProviderResultSet;
        Set set = Utils.getConstrainedObjects((Constraint)querySpec.resourceSpec.constraint);
        assert (set.size() == 1);
        Object e = set.iterator().next();
        List list = Utils.getPropertyNames((PropertySpec[])querySpec.resourceSpec.propertySpecs);
        if (objectPropertyResults.foundObjects.contains(e)) {
            dynamicProviderResultSet = new ArrayList(list.size());
            for (String string : list) {
                PropertyValue propertyValue = (PropertyValue)objectPropertyResults.propertyValuesByObject.get((Object)string, e);
                if (propertyValue == null) continue;
                dynamicProviderResultSet.add(propertyValue);
            }
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = e;
            resultItem.properties = new PropertyValue[dynamicProviderResultSet.size()];
            dynamicProviderResultSet.toArray(resultItem.properties);
            resultItem.currentGenerations = objectPropertyResults.generationsByObject.get(e);
            resultItemArray = new ResultItem[]{resultItem};
            exception = objectPropertyResults.errorsByObject.get(e);
        } else {
            resultItemArray = new ResultItem[]{};
            exception = null;
        }
        dynamicProviderResultSet = new DynamicProviderResultSet();
        dynamicProviderResultSet.queryName = querySpec.name;
        dynamicProviderResultSet.totalMatchedObjectCount = resultItemArray.length;
        dynamicProviderResultSet.items = resultItemArray;
        dynamicProviderResultSet.facets = Utils.EMPTY_FACET_INFOS;
        dynamicProviderResultSet.error = exception;
        dynamicProviderResultSet.sorted = true;
        dynamicProviderResultSet.paged = true;
        dynamicProviderResultSet.allowFallbackRequest = false;
        return dynamicProviderResultSet;
    }

    private ObjectPropertyResults getObjectPropertiesFromReducedQueryResults(QuerySpecSplit querySpecSplit, RequestSpec requestSpec, Response response) {
        HashSet<Object> hashSet = new HashSet<Object>();
        HashMap<Object, IdentifiableGenerationNumber[]> hashMap = new HashMap<Object, IdentifiableGenerationNumber[]>();
        HashBasedTable hashBasedTable = HashBasedTable.create();
        HashMap<Object, Exception> hashMap2 = new HashMap<Object, Exception>();
        for (int i = 0; i < requestSpec.querySpec.length; ++i) {
            QuerySpec querySpec = requestSpec.querySpec[i];
            ResultSet resultSet = response.resultSet[i];
            if (querySpecSplit.nonReducibleQueries.contains(querySpec) || resultSet == null || ArrayUtils.isEmpty((Object[])resultSet.items)) continue;
            for (ResultItem resultItem : resultSet.items) {
                Object object = resultItem.resourceObject;
                hashSet.add(object);
                if (resultSet.error != null) {
                    hashMap2.put(object, resultSet.error);
                }
                hashMap.put(object, resultItem.currentGenerations);
                if (!ArrayUtils.isNotEmpty((Object[])resultItem.properties)) continue;
                for (PropertyValue propertyValue : resultItem.properties) {
                    String string = propertyValue.propertyName;
                    hashBasedTable.put((Object)string, object, (Object)propertyValue);
                }
            }
        }
        return new ObjectPropertyResults(hashSet, hashMap, (Table<String, Object, PropertyValue>)hashBasedTable, hashMap2);
    }

    private ObjectIdentityConstraint getSingleObjectConstraint(QuerySpec querySpec) {
        if (this.isSimpleObjectConstrainedQuery(querySpec)) {
            Set set = Utils.getObjectConstraints((Constraint)querySpec.resourceSpec.constraint);
            if (set.size() == 1) {
                return (ObjectIdentityConstraint)set.iterator().next();
            }
            return null;
        }
        return null;
    }

    private boolean isSimpleObjectConstrainedQuery(QuerySpec querySpec) {
        ResourceSpec resourceSpec = querySpec.resourceSpec;
        ResultSpec resultSpec = querySpec.resultSpec;
        return resourceSpec != null && resourceSpec.constraint != null && Utils.isObjectConstrained((Constraint)resourceSpec.constraint) && (resultSpec == null || this.hasDefaultResultSpec(resultSpec));
    }

    private boolean hasDefaultResultSpec(ResultSpec resultSpec) {
        return !(!ArrayUtils.isEmpty((Object[])resultSpec.facets) || resultSpec.order != null && !resultSpec.order.equals((Object)Utils.DEFAULT_ORDERING_CRITERIA) || resultSpec.offset != null && resultSpec.offset != 0 || resultSpec.maxResultCount != null && resultSpec.maxResultCount >= 0);
    }

    private static List<PropertySpec> getPropertySpecList(QuerySpec querySpec) {
        PropertySpec[] propertySpecArray = querySpec.resourceSpec.propertySpecs;
        List<PropertySpec> list = propertySpecArray == null ? Collections.emptyList() : Arrays.asList(propertySpecArray);
        return list;
    }

    private static final class ObjectPropertyResults {
        public final Set<Object> foundObjects;
        public final Map<Object, IdentifiableGenerationNumber[]> generationsByObject;
        public final Table<String, Object, PropertyValue> propertyValuesByObject;
        public final Map<Object, Exception> errorsByObject;

        public ObjectPropertyResults(Set<Object> set, Map<Object, IdentifiableGenerationNumber[]> map, Table<String, Object, PropertyValue> table, Map<Object, Exception> map2) {
            this.foundObjects = set;
            this.generationsByObject = map;
            this.propertyValuesByObject = table;
            this.errorsByObject = map2;
        }
    }

    private static final class QuerySpecSplit {
        public final List<QuerySpec> nonReducibleQueries;
        public final Multimap<ObjectIdentityConstraint, QuerySpec> reducibleQueriesByObject;

        public QuerySpecSplit(List<QuerySpec> list, Multimap<ObjectIdentityConstraint, QuerySpec> multimap) {
            this.nonReducibleQueries = list;
            this.reducibleQueriesByObject = multimap;
        }
    }
}

