/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.adapters.core.tagging.InventoryServiceTaggingIdConverter;
import com.vmware.vise.data.uri.VapiUriSchemeUtil;
import java.net.URI;
import org.apache.commons.lang.Validate;

public final class ReferenceConverter {
    public static String getResourceObjectType(Object object) {
        Validate.notNull((Object)object);
        if (object instanceof ManagedObjectReference) {
            return ReferenceConverter.getResourceTypeFromMor((ManagedObjectReference)object);
        }
        if (object instanceof URI && VapiUriSchemeUtil.isVapiUri((URI)((URI)object))) {
            return VapiUriSchemeUtil.getType((URI)((URI)object));
        }
        String string = object == null ? "null" : String.format("[%s] %s", object.getClass().getName(), object.toString());
        throw new UnsupportedOperationException("Resource object unsupported by DS Core: " + string);
    }

    private static String getResourceTypeFromMor(ManagedObjectReference managedObjectReference) {
        assert (managedObjectReference != null);
        if (InventoryServiceTaggingIdConverter.isTaggingMor(managedObjectReference)) {
            return InventoryServiceTaggingIdConverter.getTaggingResourceType(managedObjectReference);
        }
        return managedObjectReference.getType();
    }
}

