/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.ReferenceConverter;
import com.vmware.vise.data.adapters.core.ViseQueryExecutor;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.FacetSpec;
import com.vmware.vise.data.query.FacetValue;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelatedObjectPropertyFacets {
    private static final Logger _logger = LoggerFactory.getLogger(RelatedObjectPropertyFacets.class);
    private final ViseQueryExecutor _queryExecutor;

    public RelatedObjectPropertyFacets(ViseQueryExecutor viseQueryExecutor) {
        this._queryExecutor = viseQueryExecutor;
    }

    public List<FacetInfo> get(CoreQueryService coreQueryService, List<ResultSet> list, ResultSpec resultSpec) {
        List<PropertySpec> list2 = this.getRelatedObjectFacetSpecs(resultSpec);
        if (list2.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        this.extractReturnedResourceObjects(list, hashSet);
        if (hashSet.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FacetInfo> arrayList = new ArrayList<FacetInfo>(list2.size());
        for (PropertySpec propertySpec : list2) {
            this.validateFacetPropSpec(propertySpec);
            RelatedObjectPropertyValueSet relatedObjectPropertyValueSet = this.retrieveRelatedObjectPropertyValueSet(coreQueryService, hashSet, propertySpec);
            List<FacetValue> list3 = this.createViseFacetValues(propertySpec, relatedObjectPropertyValueSet.propertyValueSet, relatedObjectPropertyValueSet.relatedObjectTypes);
            FacetInfo facetInfo = new FacetInfo();
            facetInfo.propSpec = propertySpec;
            facetInfo.facetValues = list3.toArray(new FacetValue[list3.size()]);
            arrayList.add(facetInfo);
        }
        return arrayList;
    }

    private List<PropertySpec> getRelatedObjectFacetSpecs(ResultSpec resultSpec) {
        if (resultSpec == null || ArrayUtils.isEmpty((Object[])resultSpec.facets)) {
            return Collections.emptyList();
        }
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>(resultSpec.facets.length);
        for (FacetSpec facetSpec : resultSpec.facets) {
            if (StringUtils.isEmpty((String)facetSpec.propSpec.relation)) continue;
            arrayList.add(facetSpec.propSpec);
        }
        return arrayList;
    }

    private void extractReturnedResourceObjects(List<ResultSet> list, Set<Object> set) {
        for (ResultSet resultSet : list) {
            if (resultSet.getItems().size() == 0) continue;
            List list2 = resultSet.getProperties();
            int n = this.getRequiredPropertyIndex(list2, "@modelKey");
            for (ResourceItem resourceItem : resultSet.getItems()) {
                Object e = resourceItem.getPropertyValues().get(n);
                set.add(e);
            }
        }
    }

    private int getRequiredPropertyIndex(List<String> list, String string) {
        int n = list.indexOf(string);
        if (n < 0) {
            throw new IllegalStateException("Required property not present in the ResultSet: " + string);
        }
        return n;
    }

    private RelatedObjectPropertyValueSet retrieveRelatedObjectPropertyValueSet(CoreQueryService coreQueryService, Set<Object> set, PropertySpec propertySpec) {
        assert (propertySpec.propertyNames.length == 1);
        String string = propertySpec.propertyNames[0];
        QuerySpec querySpec = RelatedObjectPropertyFacets.buildQueryForRelatedProperty(set, propertySpec.relation, string);
        if (_logger.isDebugEnabled()) {
            _logger.debug("Dispatching query to evaluate facet over related object property {}:\n{}", (Object)propertySpec, (Object)Utils.renderQuerySpec((QuerySpec)querySpec));
        }
        DynamicProviderResultSet dynamicProviderResultSet = this._queryExecutor.execute(coreQueryService, querySpec);
        RelatedObjectPropertyValueSet relatedObjectPropertyValueSet = this.gatherRelatedFacetValues(string, dynamicProviderResultSet);
        return relatedObjectPropertyValueSet;
    }

    private RelatedObjectPropertyValueSet gatherRelatedFacetValues(String string, DynamicProviderResultSet dynamicProviderResultSet) {
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<String> hashSet2 = new HashSet<String>();
        if (ArrayUtils.isEmpty((Object[])dynamicProviderResultSet.items)) {
            return new RelatedObjectPropertyValueSet(hashSet, hashSet2);
        }
        for (ResultItem resultItem : dynamicProviderResultSet.items) {
            if (resultItem == null || ArrayUtils.isEmpty((Object[])resultItem.properties)) continue;
            hashSet2.add(ReferenceConverter.getResourceObjectType(resultItem.resourceObject));
            for (PropertyValue propertyValue : resultItem.properties) {
                if (!string.equals(propertyValue.propertyName)) continue;
                hashSet.add(propertyValue.value);
            }
        }
        return new RelatedObjectPropertyValueSet(hashSet, hashSet2);
    }

    private List<FacetValue> createViseFacetValues(PropertySpec propertySpec, Set<Object> set, Set<String> set2) {
        ArrayList<FacetValue> arrayList = new ArrayList<FacetValue>(set.size());
        for (Object object : set) {
            PropertyConstraint propertyConstraint;
            ArrayList<Constraint> arrayList2 = new ArrayList<Constraint>(set2.size());
            for (String string : set2) {
                propertyConstraint = new PropertyConstraint();
                propertyConstraint.targetType = string;
                propertyConstraint.propertyName = propertySpec.propertyNames[0];
                propertyConstraint.comparator = Comparator.EQUALS;
                propertyConstraint.comparableValue = object;
                arrayList2.add((Constraint)propertyConstraint);
            }
            Constraint constraint = RelatedObjectPropertyFacets.union(arrayList2);
            String[] stringArray2 = propertySpec.relation.split(";");
            for (int i = stringArray2.length - 1; i >= 0; --i) {
                String string = stringArray2[i];
                RelationalConstraint relationalConstraint = new RelationalConstraint();
                String string2 = i == 0 ? propertySpec.type : null;
                relationalConstraint.targetType = string2;
                relationalConstraint.relation = string;
                relationalConstraint.constraintOnRelatedObject = constraint;
                constraint = relationalConstraint;
            }
            propertyConstraint = new FacetValue();
            propertyConstraint.constraint = constraint;
            propertyConstraint.value = object;
            arrayList.add((FacetValue)propertyConstraint);
        }
        return arrayList;
    }

    private static QuerySpec buildQueryForRelatedProperty(Set<Object> set, String string, String string2) {
        PropertySpec propertySpec = StringUtils.split((String)string, (String)";");
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Object[])set.toArray(), (Conjoiner)Conjoiner.OR);
        for (String string3 : propertySpec) {
            RelationalConstraint relationalConstraint = new RelationalConstraint();
            relationalConstraint.targetType = null;
            relationalConstraint.hasInverseRelation = true;
            relationalConstraint.relation = string3;
            relationalConstraint.constraintOnRelatedObject = constraint;
            constraint = relationalConstraint;
        }
        PropertySpec propertySpec2 = new PropertySpec();
        propertySpec2.propertyNames = new String[]{string2};
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec2};
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = "Property values for " + string + ";" + string2;
        querySpec.resourceSpec = resourceSpec;
        return querySpec;
    }

    private static Constraint union(List<Constraint> list) {
        assert (list.size() > 0);
        if (list.size() == 1) {
            return list.get(0);
        }
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.OR;
        compositeConstraint.nestedConstraints = list.toArray(new Constraint[list.size()]);
        return compositeConstraint;
    }

    private void validateFacetPropSpec(PropertySpec propertySpec) {
        if (ArrayUtils.getLength((Object)propertySpec.propertyNames) != 1) {
            throw new IllegalArgumentException("Invalid FacetSpec.propSpec.propertyNames: must contain exactly one property name");
        }
    }

    private static final class RelatedObjectPropertyValueSet {
        public final Set<Object> propertyValueSet;
        public final Set<String> relatedObjectTypes;

        public RelatedObjectPropertyValueSet(Set<Object> set, Set<String> set2) {
            this.propertyValueSet = set;
            this.relatedObjectTypes = set2;
        }
    }
}

