/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.CoreRequest;
import com.vmware.vise.data.adapters.core.ViseQueryExecutor;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;

final class RelatedObjectPropertyValues {
    private final ViseQueryExecutor _queryExecutor;

    RelatedObjectPropertyValues(ViseQueryExecutor viseQueryExecutor) {
        this._queryExecutor = viseQueryExecutor;
    }

    Multimap<Object, PropertyValue> gatherRelatedPropertyValues(CoreQueryService coreQueryService, ResultSet resultSet, Multimap<String, CoreRequest.RelatedPropertyInfo> multimap) {
        assert (coreQueryService != null);
        assert (resultSet != null);
        assert (multimap != null);
        if (multimap.isEmpty()) {
            return ImmutableMultimap.of();
        }
        HashMultimap hashMultimap = HashMultimap.create();
        for (String string : multimap.keySet()) {
            Multimap<Object, Object> multimap2 = RelatedObjectPropertyValues.gatherRelatedObjectIds(resultSet, string);
            if (multimap2.isEmpty()) continue;
            Collection collection = multimap.get((Object)string);
            Set set = multimap2.keySet();
            for (CoreRequest.RelatedPropertyInfo relatedPropertyInfo : collection) {
                String[] stringArray = relatedPropertyInfo.viseProperties.toArray(new String[relatedPropertyInfo.viseProperties.size()]);
                QuerySpec querySpec = RelatedObjectPropertyValues.buildQueryFor(set, relatedPropertyInfo.viseRelation, stringArray);
                DynamicProviderResultSet dynamicProviderResultSet = this._queryExecutor.execute(coreQueryService, querySpec);
                this.gatherRelatedPropertyValues((Multimap<Object, PropertyValue>)hashMultimap, multimap2, dynamicProviderResultSet);
            }
        }
        return hashMultimap;
    }

    private void gatherRelatedPropertyValues(Multimap<Object, PropertyValue> multimap, Multimap<Object, Object> multimap2, DynamicProviderResultSet dynamicProviderResultSet) {
        if (ArrayUtils.isEmpty((Object[])dynamicProviderResultSet.items)) {
            return;
        }
        for (ResultItem resultItem : dynamicProviderResultSet.items) {
            if (resultItem == null || ArrayUtils.isEmpty((Object[])resultItem.properties) || resultItem.resourceObject == null) continue;
            Collection collection = multimap2.get(resultItem.resourceObject);
            for (PropertyValue propertyValue : resultItem.properties) {
                for (Object e : collection) {
                    multimap.put(e, (Object)propertyValue);
                }
            }
        }
    }

    static QuerySpec buildQueryFor(Collection<Object> collection, String string, String ... stringArray) {
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Object[])collection.toArray(), (Conjoiner)Conjoiner.OR);
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.relation = string;
        propertySpec.propertyNames = stringArray;
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = resourceSpec;
        return querySpec;
    }

    static Multimap<Object, Object> gatherRelatedObjectIds(ResultSet resultSet, String string) {
        int n = resultSet.getProperties().indexOf(string);
        int n2 = resultSet.getProperties().indexOf("@modelKey");
        if (n == -1) {
            return ImmutableMultimap.of();
        }
        HashMultimap hashMultimap = HashMultimap.create();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Object object = resourceItem.getPropertyValues().get(n);
            if (object == null) continue;
            if (object.getClass().isArray()) {
                if (Array.getLength(object) == 0) continue;
                object = Array.get(object, 0);
            }
            Object e = resourceItem.getPropertyValues().get(n2);
            hashMultimap.put(object, e);
        }
        return hashMultimap;
    }
}

