/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import com.vmware.cis.data.internal.provider.ext.aggregated.DefaultAggregatedModels;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.adapters.core.ChunkQueryBuilder;
import com.vmware.vise.data.adapters.core.CorePropertyConverter;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.CoreRequest;
import com.vmware.vise.data.adapters.core.DefaultRequestPropertyValidator;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.ConstraintTranslatorDispatcher;
import com.vmware.vise.data.adapters.core.translator.CoreResourceModelResolver;
import com.vmware.vise.data.adapters.core.translator.QuerySpecPreprocessor;
import com.vmware.vise.data.adapters.core.translator.RelationshipRegistry;
import com.vmware.vise.data.adapters.core.translator.RelationshipRegistryLoader;
import com.vmware.vise.data.adapters.core.translator.StaticResourceModelResolver;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.adapters.core.translator.TranslatorResolver;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestConverter {
    private static final Logger logger = LoggerFactory.getLogger(RequestConverter.class);
    private static final AggregatedModelLookup AGGREGATED_MODELS = DefaultAggregatedModels.getModelLookup();
    private static final RelationshipRegistry RELATIONSHIP_REGISTRY = RelationshipRegistryLoader.createFromResource("/metadata/relationship-infos.xml");
    private final CoreResourceModelResolver _resourceModelResolver;
    private final CorePropertyConverter _propertyConverter;
    private final TranslatorResolver _constraintTranslator;
    private final RequestPropertyValidator _propertyValidator;

    public RequestConverter(QuerySchema querySchema) {
        assert (querySchema != null);
        this._resourceModelResolver = new StaticResourceModelResolver();
        this._propertyConverter = new CorePropertyConverter(this._resourceModelResolver);
        this._propertyValidator = new DefaultRequestPropertyValidator(querySchema);
        this._constraintTranslator = new ConstraintTranslatorDispatcher(this._propertyValidator, this._propertyConverter, this._resourceModelResolver, AGGREGATED_MODELS, RELATIONSHIP_REGISTRY);
    }

    public CoreRequest toCoreRequest(CoreQueryService coreQueryService, QuerySpec querySpec) {
        Object object;
        Validate.notNull((Object)querySpec, (String)"querySpec is required.");
        Validate.notNull((Object)querySpec.resourceSpec, (String)"querySpec.resourceSpec is required.");
        Validate.notNull((Object)querySpec.resourceSpec.constraint, (String)"querySpec.resourceSpec.constraint is required.");
        querySpec = new QuerySpecPreprocessor(this._resourceModelResolver).prepareQuerySpec(querySpec);
        Map<String, TranslationResult> map = this.translateConstraint(coreQueryService, querySpec.resourceSpec.constraint, querySpec.options);
        ResultSpec resultSpec = querySpec.resultSpec;
        boolean bl = map.size() > 1;
        ArrayList<CoreRequest.ChunkQuery> arrayList = new ArrayList<CoreRequest.ChunkQuery>(map.size());
        for (Map.Entry<String, TranslationResult> entry : map.entrySet()) {
            TranslationResult translationResult;
            object = entry.getKey();
            CoreRequest.ChunkQuery chunkQuery = new ChunkQueryBuilder(this._propertyConverter, this._propertyValidator, this._resourceModelResolver, (String)object, translationResult = entry.getValue(), bl, querySpec.options).setReturnClause(querySpec.resourceSpec.propertySpecs).setResultSpec(resultSpec).create();
            if (chunkQuery == null) continue;
            arrayList.add(chunkQuery);
        }
        int n = RequestConverter.toCoreQueryOffset(resultSpec);
        if (!bl && arrayList.size() > 0 && ((CoreRequest.ChunkQuery)arrayList.get(0)).getCoreQuery().getOffset() > 0) {
            n = 0;
        }
        int n2 = RequestConverter.toCoreQueryLimit(resultSpec);
        object = new CoreRequest(arrayList, n, n2);
        logger.debug("RequestConvert.toCoreRequest query `{}' converted to: {}", (Object)querySpec.name, object);
        return object;
    }

    private Map<String, TranslationResult> translateConstraint(CoreQueryService coreQueryService, Constraint constraint, Map<String, Object> map) {
        Map<String, TranslationResult> map2 = this._constraintTranslator.getTranslator(constraint).translate(coreQueryService, constraint, map);
        return this.removeEmptyResults(map2);
    }

    private Map<String, TranslationResult> removeEmptyResults(Map<String, TranslationResult> map) {
        HashMap<String, TranslationResult> hashMap = new HashMap<String, TranslationResult>(map.size());
        for (Map.Entry<String, TranslationResult> entry : map.entrySet()) {
            if (entry.getValue().getOutcome() == TranslationResult.Outcome.MatchesNothing) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    public static int toCoreQueryOffset(ResultSpec resultSpec) {
        int n = resultSpec == null || resultSpec.offset == null || Integer.valueOf(0).equals(resultSpec.maxResultCount) ? 0 : resultSpec.offset;
        if (n < 0) {
            throw new IllegalArgumentException("ResultSpec.offset must be positive.");
        }
        return n;
    }

    public static int toCoreQueryLimit(ResultSpec resultSpec) {
        if (resultSpec == null || resultSpec.maxResultCount == null || resultSpec.maxResultCount < 0) {
            return -1;
        }
        return resultSpec.maxResultCount;
    }
}

