/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.UnmodifiableIterator;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.merge.DefaultItemComparator;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.vise.data.adapters.core.CoreRequest;
import com.vmware.vise.data.adapters.core.CoreResponse;
import com.vmware.vise.data.adapters.core.ResultChunkIteration;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseConverter {
    private static final Logger logger = LoggerFactory.getLogger(ResponseConverter.class);
    private static final Set<String> PC_ARRAY_PROPERTIES = ResponseConverter.getPcArrayProperties();

    public DynamicProviderResultSet toViseResponse(String string, CoreResponse coreResponse, List<FacetInfo> list, Exception exception) {
        boolean bl;
        Iterator<ResultChunkIteration.ResultChunkItem> iterator;
        Object object;
        Object object2;
        logger.debug("ResponseConverter.toViseResponse for query `{}' : {}", (Object)string, (Object)coreResponse);
        CoreRequest.ChunkOrdering chunkOrdering = this.determineCombinedOrdering(coreResponse);
        int n = 0;
        ArrayList<Iterator<ResultChunkIteration.ResultChunkItem>> arrayList = new ArrayList<Iterator<ResultChunkIteration.ResultChunkItem>>();
        for (CoreResponse.ResultChunk resultChunk : coreResponse.getResultChunks()) {
            object2 = resultChunk.getCoreResult();
            n += ResponseConverter.getTotalCount(object2);
            if (object2.getItems().size() <= 0 || coreResponse.getLimit() == 0) continue;
            object = resultChunk.getChunkOrdering() == CoreRequest.ChunkOrdering.CLIENT_SIDE && chunkOrdering != CoreRequest.ChunkOrdering.NONE ? this.sortAtClientSide(resultChunk) : resultChunk;
            arrayList.add(new ResultChunkIteration.ResultChunkIterator((CoreResponse.ResultChunk)object));
        }
        if (chunkOrdering == CoreRequest.ChunkOrdering.NONE) {
            iterator = Iterators.concat(arrayList.iterator());
            bl = false;
        } else {
            iterator = this.mergeAndApplyPaging(coreResponse, arrayList);
            bl = true;
        }
        object2 = Iterators.transform(iterator, (Function)new Function<ResultChunkIteration.ResultChunkItem, ResultItem>(){

            public ResultItem apply(ResultChunkIteration.ResultChunkItem resultChunkItem) {
                return ResponseConverter.this.toViseResultItem(resultChunkItem);
            }
        });
        object = this.createViseResult(string);
        object.totalMatchedObjectCount = n;
        object.items = (ResultItem[])Iterators.toArray((Iterator)object2, ResultItem.class);
        object.facets = list.toArray(new FacetInfo[list.size()]);
        object.paged = bl;
        object.sorted = bl;
        object.error = exception;
        return object;
    }

    private CoreRequest.ChunkOrdering determineCombinedOrdering(CoreResponse coreResponse) {
        boolean bl = false;
        boolean bl2 = false;
        block5: for (CoreResponse.ResultChunk resultChunk : coreResponse.getResultChunks()) {
            CoreRequest.ChunkOrdering chunkOrdering = resultChunk.getChunkOrdering();
            switch (chunkOrdering) {
                case NONE: {
                    bl = true;
                    continue block5;
                }
                case CLIENT_SIDE: {
                    bl2 = true;
                    continue block5;
                }
                case SORTED: {
                    continue block5;
                }
            }
            throw new IllegalStateException("BUG: unexpectdd chunkOrdering = " + (Object)((Object)chunkOrdering));
        }
        Object object = bl ? CoreRequest.ChunkOrdering.NONE : (bl2 ? CoreRequest.ChunkOrdering.CLIENT_SIDE : CoreRequest.ChunkOrdering.SORTED);
        return object;
    }

    private CoreResponse.ResultChunk sortAtClientSide(CoreResponse.ResultChunk resultChunk) {
        ResultSet resultSet = resultChunk.getCoreResult();
        ResultSet resultSet2 = this.sortAtClientSide(resultSet, resultChunk.getSortClauseProjection());
        return new CoreResponse.ResultChunk(resultSet2, resultChunk.getReturnByCoreNameMapping(), resultChunk.getRelatedValuesByItemKey(), CoreRequest.ChunkOrdering.SORTED, resultChunk.getSortClauseProjection());
    }

    private ResultSet sortAtClientSide(ResultSet resultSet, List<SortCriterion> list) {
        assert (!list.isEmpty());
        DefaultItemComparator defaultItemComparator = new DefaultItemComparator(resultSet.getProperties(), list);
        List list2 = Ordering.from((Comparator)defaultItemComparator).sortedCopy((Iterable)resultSet.getItems());
        ResultSet.Builder builder = ResultSet.Builder.properties((List)resultSet.getProperties());
        for (ResourceItem resourceItem : list2) {
            builder.item(resourceItem.getKey(), resourceItem.getPropertyValues());
        }
        return builder.totalCount(resultSet.getTotalCount()).build();
    }

    private Iterator<ResultChunkIteration.ResultChunkItem> mergeAndApplyPaging(CoreResponse coreResponse, List<Iterator<ResultChunkIteration.ResultChunkItem>> list) {
        Iterator iterator;
        UnmodifiableIterator unmodifiableIterator;
        if (list.size() == 1) {
            unmodifiableIterator = list.get(0);
        } else {
            iterator = new ResultChunkIteration.ResultChunkItemComparator();
            unmodifiableIterator = Iterators.mergeSorted(list, (Comparator)((Object)iterator));
        }
        Iterators.advance((Iterator)unmodifiableIterator, (int)coreResponse.getOffset());
        iterator = coreResponse.getLimit() > 0 ? Iterators.limit((Iterator)unmodifiableIterator, (int)coreResponse.getLimit()) : unmodifiableIterator;
        return iterator;
    }

    private static int getTotalCount(ResultSet resultSet) {
        return resultSet.getTotalCount() != null ? resultSet.getTotalCount().intValue() : resultSet.getItems().size();
    }

    public DynamicProviderResultSet toViseResponse(String string, RuntimeException runtimeException) {
        DynamicProviderResultSet dynamicProviderResultSet = this.createViseResult(string);
        dynamicProviderResultSet.error = runtimeException;
        return dynamicProviderResultSet;
    }

    private DynamicProviderResultSet createViseResult(String string) {
        DynamicProviderResultSet dynamicProviderResultSet = new DynamicProviderResultSet();
        dynamicProviderResultSet.queryName = string;
        return dynamicProviderResultSet;
    }

    private ResultItem toViseResultItem(ResultChunkIteration.ResultChunkItem resultChunkItem) {
        return this.toViseResultItem(resultChunkItem.getResourceItem(), resultChunkItem.getItemType(), resultChunkItem.getSourceChunk().getCoreResult(), resultChunkItem.getSourceChunk().getReturnByCoreNameMapping(), resultChunkItem.getSourceChunk().getRelatedValuesByItemKey());
    }

    private ResultItem toViseResultItem(ResourceItem resourceItem, String string, ResultSet resultSet, Multimap<String, String> multimap, Multimap<Object, PropertyValue> multimap2) {
        Validate.notNull((Object)resourceItem);
        List list = resultSet.getProperties();
        ResultItem resultItem = new ResultItem();
        Object object = resourceItem.getKey();
        Collection collection = multimap2.get(object);
        resultItem.properties = this.toVisePropertyValues(string, multimap, object, resourceItem.getPropertyValues(), list, collection);
        resultItem.resourceObject = object;
        return resultItem;
    }

    private PropertyValue[] toVisePropertyValues(String string, Multimap<String, String> multimap, Object object, List<Object> list, List<String> list2, Collection<PropertyValue> collection) {
        if (list == null) {
            return new PropertyValue[0];
        }
        if (list2 == null || list2.size() != list.size()) {
            throw new IllegalStateException("The list with requested properties is not with the same size as the result properties list!");
        }
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list2.get(i);
            if (PropertyUtil.isModelKey((String)string2)) continue;
            Object object2 = list.get(i);
            Collection collection2 = multimap.get((Object)string2);
            if (collection2 == null || collection2.isEmpty() || ResponseConverter.shouldOmitPropertyValue(string2, object2)) continue;
            for (String string3 : collection2) {
                PropertyValue propertyValue = ResponseConverter.toVisePropertyValue(object, object2, string3);
                arrayList.add(propertyValue);
            }
        }
        arrayList.addAll(collection);
        return arrayList.toArray(new PropertyValue[arrayList.size()]);
    }

    private static boolean shouldOmitPropertyValue(String string, Object object) {
        if (object == null) {
            return true;
        }
        return ResponseConverter.isEmptyVmodl1Array(string, object) && !PC_ARRAY_PROPERTIES.contains(string);
    }

    private static boolean isEmptyVmodl1Array(String string, Object object) {
        assert (object != null);
        if (!string.contains(".")) {
            return object.getClass().isArray() && ArrayUtils.getLength((Object)object) == 0;
        }
        return false;
    }

    private static PropertyValue toVisePropertyValue(Object object, Object object2, String string) {
        Validate.notEmpty((String)string);
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.resourceObject = object;
        propertyValue.propertyName = string;
        propertyValue.value = object2;
        return propertyValue;
    }

    private static Set<String> getPcArrayProperties() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add("ClusterComputeResource/recommendation");
        linkedHashSet.add("ClusterComputeResource/drsRecommendation");
        linkedHashSet.add("ClusterComputeResource/availableField");
        linkedHashSet.add("ClusterComputeResource/recentTask");
        linkedHashSet.add("ClusterComputeResource/effectiveRole");
        linkedHashSet.add("ClusterComputeResource/disabledMethod");
        linkedHashSet.add("ClusterComputeResource/declaredAlarmState");
        linkedHashSet.add("ClusterComputeResource/triggeredAlarmState");
        linkedHashSet.add("ClusterComputeResource/configIssue");
        linkedHashSet.add("ClusterComputeResource/drsFault");
        linkedHashSet.add("DistributedVirtualSwitch/availableField");
        linkedHashSet.add("DistributedVirtualSwitch/recentTask");
        linkedHashSet.add("DistributedVirtualSwitch/effectiveRole");
        linkedHashSet.add("DistributedVirtualSwitch/disabledMethod");
        linkedHashSet.add("DistributedVirtualSwitch/declaredAlarmState");
        linkedHashSet.add("DistributedVirtualSwitch/triggeredAlarmState");
        linkedHashSet.add("DistributedVirtualSwitch/configIssue");
        linkedHashSet.add("VmwareDistributedVirtualSwitch/availableField");
        linkedHashSet.add("VmwareDistributedVirtualSwitch/recentTask");
        linkedHashSet.add("VmwareDistributedVirtualSwitch/effectiveRole");
        linkedHashSet.add("VmwareDistributedVirtualSwitch/disabledMethod");
        linkedHashSet.add("VmwareDistributedVirtualSwitch/declaredAlarmState");
        linkedHashSet.add("VmwareDistributedVirtualSwitch/triggeredAlarmState");
        linkedHashSet.add("VmwareDistributedVirtualSwitch/configIssue");
        linkedHashSet.add("ComputeResource/effectiveRole");
        linkedHashSet.add("ResourcePool/availableField");
        linkedHashSet.add("ResourcePool/recentTask");
        linkedHashSet.add("ResourcePool/effectiveRole");
        linkedHashSet.add("ResourcePool/disabledMethod");
        linkedHashSet.add("ResourcePool/declaredAlarmState");
        linkedHashSet.add("ResourcePool/triggeredAlarmState");
        linkedHashSet.add("ResourcePool/configIssue");
        linkedHashSet.add("Folder/availableField");
        linkedHashSet.add("Folder/recentTask");
        linkedHashSet.add("Folder/effectiveRole");
        linkedHashSet.add("Folder/disabledMethod");
        linkedHashSet.add("Folder/declaredAlarmState");
        linkedHashSet.add("Folder/triggeredAlarmState");
        linkedHashSet.add("Folder/configIssue");
        linkedHashSet.add("DistributedVirtualPortgroup/availableField");
        linkedHashSet.add("DistributedVirtualPortgroup/recentTask");
        linkedHashSet.add("DistributedVirtualPortgroup/effectiveRole");
        linkedHashSet.add("DistributedVirtualPortgroup/disabledMethod");
        linkedHashSet.add("DistributedVirtualPortgroup/declaredAlarmState");
        linkedHashSet.add("DistributedVirtualPortgroup/triggeredAlarmState");
        linkedHashSet.add("DistributedVirtualPortgroup/configIssue");
        linkedHashSet.add("VirtualApp/availableField");
        linkedHashSet.add("VirtualApp/recentTask");
        linkedHashSet.add("VirtualApp/effectiveRole");
        linkedHashSet.add("VirtualApp/disabledMethod");
        linkedHashSet.add("VirtualApp/declaredAlarmState");
        linkedHashSet.add("VirtualApp/triggeredAlarmState");
        linkedHashSet.add("VirtualApp/configIssue");
        linkedHashSet.add("StoragePod/declaredAlarmState");
        linkedHashSet.add("StoragePod/triggeredAlarmState");
        linkedHashSet.add("StoragePod/configIssue");
        linkedHashSet.add("StoragePod/effectiveRole");
        linkedHashSet.add("Datastore/availableField");
        linkedHashSet.add("Datastore/recentTask");
        linkedHashSet.add("Datastore/effectiveRole");
        linkedHashSet.add("Datastore/disabledMethod");
        linkedHashSet.add("Datastore/declaredAlarmState");
        linkedHashSet.add("Datastore/triggeredAlarmState");
        linkedHashSet.add("Datastore/configIssue");
        linkedHashSet.add("Network/availableField");
        linkedHashSet.add("Network/recentTask");
        linkedHashSet.add("Network/effectiveRole");
        linkedHashSet.add("Network/disabledMethod");
        linkedHashSet.add("Network/declaredAlarmState");
        linkedHashSet.add("Network/triggeredAlarmState");
        linkedHashSet.add("Network/configIssue");
        linkedHashSet.add("HostSystem/availableField");
        linkedHashSet.add("HostSystem/recentTask");
        linkedHashSet.add("HostSystem/effectiveRole");
        linkedHashSet.add("HostSystem/disabledMethod");
        linkedHashSet.add("HostSystem/declaredAlarmState");
        linkedHashSet.add("HostSystem/triggeredAlarmState");
        linkedHashSet.add("HostSystem/configIssue");
        linkedHashSet.add("HostSystem/config/network/vswitch/pnic");
        linkedHashSet.add("Datacenter/availableField");
        linkedHashSet.add("Datacenter/recentTask");
        linkedHashSet.add("Datacenter/effectiveRole");
        linkedHashSet.add("Datacenter/disabledMethod");
        linkedHashSet.add("Datacenter/declaredAlarmState");
        linkedHashSet.add("Datacenter/triggeredAlarmState");
        linkedHashSet.add("Datacenter/configIssue");
        linkedHashSet.add("OpaqueNetwork/effectiveRole");
        linkedHashSet.add("VirtualMachine/availableField");
        linkedHashSet.add("VirtualMachine/recentTask");
        linkedHashSet.add("VirtualMachine/effectiveRole");
        linkedHashSet.add("VirtualMachine/disabledMethod");
        linkedHashSet.add("VirtualMachine/declaredAlarmState");
        linkedHashSet.add("VirtualMachine/triggeredAlarmState");
        linkedHashSet.add("VirtualMachine/configIssue");
        linkedHashSet.add("VirtualMachine/summary/runtime/device");
        linkedHashSet.add("VirtualMachine/runtime.device");
        return Collections.unmodifiableSet(linkedHashSet);
    }
}

