/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.vapi.bindings.type.ListType;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.SetType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeReference;
import org.apache.commons.lang.Validate;

final class VapiPropertyTypeResolver {
    VapiPropertyTypeResolver() {
    }

    public static Type resolvePropertyType(StructType structType, String string) {
        String string2;
        Validate.notNull((Object)structType);
        Validate.notEmpty((String)string);
        String[] stringArray = string.split(Character.toString('/'));
        if (stringArray.length == 0) {
            throw new IllegalArgumentException(String.format("Invalid property path '%s': contains no simple property names.", string));
        }
        StructType structType2 = structType;
        int n = stringArray.length - 1;
        for (int i = 0; i < n; ++i) {
            string2 = stringArray[i];
            if ((structType2 = VapiPropertyTypeResolver.resolveStructTypeOfFieldBySimpleName(structType2, string2)) != null) continue;
            return null;
        }
        String string3 = stringArray[n];
        string2 = VapiPropertyTypeResolver.resolveTypeOfFieldBySimpleName(structType2, string3);
        if (string2 instanceof TypeReference) {
            TypeReference typeReference = (TypeReference)string2;
            string2 = typeReference.resolve();
        }
        return string2;
    }

    private static Type resolveTypeOfFieldBySimpleName(StructType structType, String string) {
        Type type = structType.getFieldByJavaName(string);
        if (type == null) {
            return null;
        }
        return type;
    }

    private static StructType resolveStructTypeOfFieldBySimpleName(StructType structType, String string) {
        Type type = VapiPropertyTypeResolver.resolveTypeOfFieldBySimpleName(structType, string);
        if (type == null) {
            return null;
        }
        StructType structType2 = null;
        while (structType2 == null) {
            OptionalType optionalType;
            if (type instanceof StructType) {
                structType2 = (StructType)type;
                continue;
            }
            if (type instanceof OptionalType) {
                optionalType = (OptionalType)type;
                type = optionalType.getElementType();
                continue;
            }
            if (type instanceof ListType) {
                optionalType = (ListType)type;
                type = optionalType.getElementType();
                continue;
            }
            if (type instanceof SetType) {
                optionalType = (SetType)type;
                type = optionalType.getElementType();
                continue;
            }
            if (type instanceof TypeReference) {
                optionalType = (TypeReference)type;
                type = optionalType.resolve();
                continue;
            }
            throw new IllegalArgumentException(String.format("Field '%s' of structure '%s' cannot be resolved to a structure type", string, structType.getName()));
        }
        return structType2;
    }
}

