/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.alien;

import com.vmware.cis.data.internal.adapters.lookup.KeyStoreMaker;
import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LinkedVcGroupBasedServiceLocator
implements ServiceLocator {
    private static final Logger _logger = LoggerFactory.getLogger(LinkedVcGroupBasedServiceLocator.class);
    private static final String ENDPOINT_DATA_PROVIDER = "com.vmware.cis.data.provider";
    private static final String ENDPOINT_VIM = "com.vmware.vim";
    private static final String PROTOCOL_VMOMI = "vmomi";
    private static final String PROVIDER_TYPE_VC = "com.vmware.cis:vcenterserver";
    private final Collection<VcService> _vcServices;

    LinkedVcGroupBasedServiceLocator(Collection<VcService> collection) {
        assert (collection != null);
        this._vcServices = collection;
    }

    public Collection<ServiceEndpointInfo> findServiceEndpoints(String string, String string2, String string3, String string4) {
        List<ServiceEndpointInfo> list = Collections.emptyList();
        if (ENDPOINT_DATA_PROVIDER.equals(string3) || ENDPOINT_VIM.equals(string3)) {
            list = LinkedVcGroupBasedServiceLocator.getVcEndpoints(this._vcServices);
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace("Endpoints with productId={} serviceType={} endpointType={} endpointProtocol={} : {}", new Object[]{string, string2, string3, string4, list.size()});
        }
        return list;
    }

    private static Collection<ServiceEndpointInfo> getVcEndpoints(Collection<VcService> collection) {
        assert (collection != null);
        ArrayList<ServiceEndpointInfo> arrayList = new ArrayList<ServiceEndpointInfo>(collection.size());
        for (VcService vcService : collection) {
            ServiceEndpointInfo serviceEndpointInfo = LinkedVcGroupBasedServiceLocator.getVcEndpointInfo(vcService);
            arrayList.add(serviceEndpointInfo);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static ServiceEndpointInfo getVcEndpointInfo(VcService vcService) {
        assert (vcService != null);
        ServiceEndpointEx serviceEndpointEx = LinkedVcGroupBasedServiceLocator.getVcEndpointEx(vcService);
        if (serviceEndpointEx.getCertificate() == null) {
            throw new IllegalArgumentException(String.format("Alien VcService for '%s' has no SSL certificate for endpoint: %s", vcService.getServiceUrl(), serviceEndpointEx));
        }
        KeyStore keyStore = KeyStoreMaker.fromTrustedCertificates((String[])new String[]{serviceEndpointEx.getCertificate()});
        String string = serviceEndpointEx.getInstanceUuid();
        return new ServiceEndpointInfo(PROVIDER_TYPE_VC, URI.create(vcService.getServiceUrl()), serviceEndpointEx.getLduGuid(), keyStore, ENDPOINT_DATA_PROVIDER, PROTOCOL_VMOMI, string, vcService.getVmodlVersion());
    }

    private static ServiceEndpointEx getVcEndpointEx(VcService vcService) {
        assert (vcService != null);
        assert (vcService.getServiceGuid() != null);
        String string = vcService.getServiceGuid();
        for (ServiceEndpointEx serviceEndpointEx : vcService.getServiceEndPoints()) {
            if (!string.equals(serviceEndpointEx.getInstanceUuid())) continue;
            return serviceEndpointEx;
        }
        _logger.error("Could not find VC among the endpoints of alien VcService for '{}': {}", (Object)vcService.getServiceUrl(), (Object)Arrays.toString(vcService.getServiceEndPoints()));
        throw new IllegalArgumentException("Could not find VC among the endpoints of alien VcService for " + vcService.getServiceUrl());
    }
}

