/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.mixfed;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.adapters.core.mixfed.MixedFederationInventoryServiceTracker;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.TypeDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataServiceMixedFederationAdapter
implements DynamicProviderAdapter {
    private static final Logger _logger = LoggerFactory.getLogger(DataServiceMixedFederationAdapter.class);
    private final DynamicProviderAdapter _isa;
    private final DynamicProviderAdapter _rise;
    private final ExecutorService _executor;
    private final MetadataDirectory _metadataDirectory;
    private final MixedFederationInventoryServiceTracker _invSvcTracker;

    public static DynamicProviderAdapter federateWithLegacyNodes(DynamicProviderAdapter dynamicProviderAdapter, DynamicProviderAdapter dynamicProviderAdapter2, ExecutorService executorService, MetadataDirectory metadataDirectory, MixedFederationInventoryServiceTracker mixedFederationInventoryServiceTracker) {
        assert (dynamicProviderAdapter != null);
        assert (dynamicProviderAdapter2 != null);
        assert (executorService != null);
        assert (metadataDirectory != null);
        assert (mixedFederationInventoryServiceTracker != null);
        return new DataServiceMixedFederationAdapter(dynamicProviderAdapter, dynamicProviderAdapter2, executorService, metadataDirectory, mixedFederationInventoryServiceTracker);
    }

    DataServiceMixedFederationAdapter(DynamicProviderAdapter dynamicProviderAdapter, DynamicProviderAdapter dynamicProviderAdapter2, ExecutorService executorService, MetadataDirectory metadataDirectory, MixedFederationInventoryServiceTracker mixedFederationInventoryServiceTracker) {
        assert (dynamicProviderAdapter != null);
        assert (dynamicProviderAdapter2 != null);
        assert (executorService != null);
        assert (metadataDirectory != null);
        assert (mixedFederationInventoryServiceTracker != null);
        this._isa = dynamicProviderAdapter;
        this._rise = dynamicProviderAdapter2;
        this._executor = executorService;
        this._metadataDirectory = metadataDirectory;
        this._invSvcTracker = mixedFederationInventoryServiceTracker;
    }

    public Response getData(RequestSpec requestSpec) throws Exception {
        Validate.notNull((Object)requestSpec);
        if (this._invSvcTracker.noInventoryServices()) {
            _logger.debug("No legacy nodes found. Will not use mixed federation with InventoryService.");
            return this._rise.getData(requestSpec);
        }
        _logger.debug("Using mixed federation with InventoryService.");
        MixedFederationRequest mixedFederationRequest = this.federate(requestSpec);
        assert (mixedFederationRequest.isaRequest.querySpec.length == mixedFederationRequest.riseRequest.querySpec.length);
        Future<Response> future = this.submit(this._rise, mixedFederationRequest.riseRequest);
        Response response = DataServiceMixedFederationAdapter.getData(this._isa, mixedFederationRequest.isaRequest);
        Response response2 = future.get();
        return DataServiceMixedFederationAdapter.merge(requestSpec, response, response2);
    }

    private Future<Response> submit(final DynamicProviderAdapter dynamicProviderAdapter, final RequestSpec requestSpec) {
        return this._executor.submit(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                return DataServiceMixedFederationAdapter.getData(dynamicProviderAdapter, requestSpec);
            }
        });
    }

    private MixedFederationRequest federate(RequestSpec requestSpec) {
        assert (requestSpec != null);
        assert (requestSpec.querySpec != null);
        QuerySpec[] querySpecArray = new QuerySpec[requestSpec.querySpec.length];
        QuerySpec[] querySpecArray2 = new QuerySpec[requestSpec.querySpec.length];
        for (int i = 0; i < requestSpec.querySpec.length; ++i) {
            QuerySpec querySpec;
            QuerySpec querySpec2 = requestSpec.querySpec[i];
            if (this.traverseOnlyThroughGlobalResources(querySpec2)) {
                querySpecArray[i] = null;
                querySpecArray2[i] = querySpec2;
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug("Query for global resources will be sent only to RISE: \n{}", (Object)Utils.renderQuerySpec((QuerySpec)querySpec2));
                continue;
            }
            querySpecArray[i] = querySpec = DataServiceMixedFederationAdapter.federate(querySpec2);
            querySpecArray2[i] = querySpec;
        }
        MixedFederationRequest mixedFederationRequest = new MixedFederationRequest(DataServiceMixedFederationAdapter.requestWithQueries(requestSpec, querySpecArray), DataServiceMixedFederationAdapter.requestWithQueries(requestSpec, querySpecArray2));
        return mixedFederationRequest;
    }

    private static QuerySpec federate(QuerySpec querySpec) {
        QuerySpec querySpec2;
        assert (querySpec != null);
        if (querySpec.resultSpec == null) {
            return querySpec;
        }
        boolean bl = querySpec.resultSpec.offset == null || querySpec.resultSpec.offset <= 0;
        List<PropertySpec> list = DataServiceMixedFederationAdapter.getOrderingPropertiesForAdditionalReturn(querySpec);
        if (bl && list.isEmpty()) {
            return querySpec;
        }
        try {
            querySpec2 = querySpec.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Could not clone QuerySpec", cloneNotSupportedException);
        }
        if (!bl) {
            querySpec2.resultSpec.offset = 0;
            querySpec2.resultSpec.maxResultCount = DataServiceMixedFederationAdapter.federateMaxResultCount(querySpec.resultSpec);
        }
        if (!list.isEmpty()) {
            int n = ArrayUtils.getLength((Object)querySpec.resourceSpec.propertySpecs);
            int n2 = list.size() + n;
            PropertySpec[] propertySpecArray = new PropertySpec[n2];
            list.toArray(propertySpecArray);
            if (n > 0) {
                System.arraycopy(querySpec.resourceSpec.propertySpecs, 0, propertySpecArray, list.size(), n);
            }
            querySpec2.resourceSpec.propertySpecs = propertySpecArray;
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace("Modified query for federation purposes:\n  Original Query:{}\n  Modified Query:{}\n", (Object)Utils.renderQuerySpec((QuerySpec)querySpec), (Object)Utils.renderQuerySpec((QuerySpec)querySpec2));
        }
        return querySpec2;
    }

    private static List<PropertySpec> getOrderingPropertiesForAdditionalReturn(QuerySpec querySpec) {
        if (querySpec.resultSpec.order == null || ArrayUtils.isEmpty((Object[])querySpec.resultSpec.order.orderingProperties)) {
            return Collections.emptyList();
        }
        List list = Utils.getPropertyNames((PropertySpec[])querySpec.resourceSpec.propertySpecs);
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        for (OrderingPropertySpec orderingPropertySpec : querySpec.resultSpec.order.orderingProperties) {
            if (ArrayUtils.isEmpty((Object[])orderingPropertySpec.propertyNames)) continue;
            for (String string : orderingPropertySpec.propertyNames) {
                if (Utils.isObjectIdProperty((String)orderingPropertySpec.type, (String)string) || list.contains(string)) continue;
                PropertySpec propertySpec = new PropertySpec();
                propertySpec.type = orderingPropertySpec.type;
                propertySpec.propertyNames = new String[]{string};
                propertySpec.relation = orderingPropertySpec.relation;
                arrayList.add(propertySpec);
            }
        }
        return arrayList;
    }

    private static Integer federateMaxResultCount(ResultSpec resultSpec) {
        assert (resultSpec != null);
        Integer n = resultSpec.maxResultCount;
        Integer n2 = resultSpec.offset;
        if (n2 == null || n2 <= 0) {
            return n;
        }
        if (n == null || n <= 0) {
            return n;
        }
        int n3 = n + n2;
        if (n3 < 0) {
            return -1;
        }
        return n3;
    }

    private static Response merge(RequestSpec requestSpec, Response response, Response response2) {
        assert (response != null);
        assert (response2 != null);
        Response response3 = new Response();
        response3.executionTimeByDescription = response.executionTimeByDescription;
        response3.resultSet = DataServiceMixedFederationAdapter.merge(requestSpec, response.resultSet, response2.resultSet);
        if (_logger.isTraceEnabled()) {
            _logger.trace("Results from IS: \n{}", (Object)Utils.renderResultSets((ResultSet[])response.resultSet));
            _logger.trace("Results from RISE: \n{}", (Object)Utils.renderResultSets((ResultSet[])response2.resultSet));
            _logger.trace("Merged results from IS and RISE: \n{}", (Object)Utils.renderResultSets((ResultSet[])response3.resultSet));
        }
        return response3;
    }

    private static ResultSet[] merge(RequestSpec requestSpec, ResultSet[] resultSetArray, ResultSet[] resultSetArray2) {
        if (resultSetArray == null) {
            return resultSetArray2;
        }
        if (resultSetArray2 == null) {
            return resultSetArray;
        }
        assert (resultSetArray != null);
        assert (resultSetArray2 != null);
        assert (resultSetArray.length == resultSetArray2.length);
        DynamicProviderResultSet[] dynamicProviderResultSetArray = new DynamicProviderResultSet[resultSetArray2.length];
        for (int i = 0; i < resultSetArray2.length; ++i) {
            ResultSpec resultSpec = requestSpec.querySpec[i].resultSpec;
            DynamicProviderResultSet dynamicProviderResultSet = (DynamicProviderResultSet)resultSetArray[i];
            DynamicProviderResultSet dynamicProviderResultSet2 = (DynamicProviderResultSet)resultSetArray2[i];
            dynamicProviderResultSetArray[i] = DataServiceMixedFederationAdapter.merge(resultSpec, dynamicProviderResultSet, dynamicProviderResultSet2);
        }
        return dynamicProviderResultSetArray;
    }

    private static DynamicProviderResultSet merge(ResultSpec resultSpec, DynamicProviderResultSet dynamicProviderResultSet, DynamicProviderResultSet dynamicProviderResultSet2) {
        if (DataServiceMixedFederationAdapter.isEmpty((ResultSet)dynamicProviderResultSet)) {
            return dynamicProviderResultSet2;
        }
        if (DataServiceMixedFederationAdapter.isEmpty((ResultSet)dynamicProviderResultSet2)) {
            return dynamicProviderResultSet;
        }
        DynamicProviderResultSet dynamicProviderResultSet3 = new DynamicProviderResultSet();
        dynamicProviderResultSet3.allowFallbackRequest = false;
        dynamicProviderResultSet3.queryName = dynamicProviderResultSet.queryName;
        dynamicProviderResultSet3.totalMatchedObjectCount = DataServiceMixedFederationAdapter.mergeTotalMatchedObjectCount(dynamicProviderResultSet.totalMatchedObjectCount, dynamicProviderResultSet2.totalMatchedObjectCount);
        dynamicProviderResultSet3.items = DataServiceMixedFederationAdapter.mergeItems(dynamicProviderResultSet.items, dynamicProviderResultSet2.items);
        dynamicProviderResultSet3.facets = DataServiceMixedFederationAdapter.mergeFacets(dynamicProviderResultSet.facets, dynamicProviderResultSet2.facets);
        dynamicProviderResultSet3.error = DataServiceMixedFederationAdapter.mergeExceptions(dynamicProviderResultSet.error, dynamicProviderResultSet2.error);
        dynamicProviderResultSet3.sorted = dynamicProviderResultSet.sorted && dynamicProviderResultSet2.sorted;
        boolean bl = dynamicProviderResultSet3.paged = dynamicProviderResultSet.paged && dynamicProviderResultSet2.paged;
        if (dynamicProviderResultSet3.sorted) {
            ResultUtil.sortResult((ResultSet)dynamicProviderResultSet3, (ResultSpec)resultSpec);
        }
        if (dynamicProviderResultSet3.paged) {
            ResultUtil.pageResult((ResultSet)dynamicProviderResultSet3, (ResultSpec)resultSpec);
        }
        return dynamicProviderResultSet3;
    }

    private static Integer mergeTotalMatchedObjectCount(Integer n, Integer n2) {
        if (n == null) {
            return n2;
        }
        if (n2 == null) {
            return n;
        }
        assert (n >= 0);
        assert (n2 >= 0);
        return n + n2;
    }

    private static ResultItem[] mergeItems(ResultItem[] resultItemArray, ResultItem[] resultItemArray2) {
        if (resultItemArray == null) {
            return resultItemArray2;
        }
        if (resultItemArray2 == null) {
            return resultItemArray;
        }
        int n = resultItemArray.length + resultItemArray2.length;
        ResultItem[] resultItemArray3 = new ResultItem[n];
        int n2 = 0;
        for (ResultItem resultItem : resultItemArray) {
            resultItemArray3[n2++] = resultItem;
        }
        for (ResultItem resultItem : resultItemArray2) {
            resultItemArray3[n2++] = resultItem;
        }
        return resultItemArray3;
    }

    private static FacetInfo[] mergeFacets(FacetInfo[] facetInfoArray, FacetInfo[] facetInfoArray2) {
        if (facetInfoArray == null) {
            return facetInfoArray2;
        }
        if (facetInfoArray2 == null) {
            return facetInfoArray;
        }
        int n = facetInfoArray.length + facetInfoArray2.length;
        FacetInfo[] facetInfoArray3 = new FacetInfo[n];
        int n2 = 0;
        for (FacetInfo facetInfo : facetInfoArray) {
            facetInfoArray3[n2++] = facetInfo;
        }
        for (FacetInfo facetInfo : facetInfoArray2) {
            facetInfoArray3[n2++] = facetInfo;
        }
        return facetInfoArray3;
    }

    private static Exception mergeExceptions(Exception exception, Exception exception2) {
        if (exception == null) {
            return exception2;
        }
        if (exception2 == null) {
            return exception;
        }
        exception2.addSuppressed(exception);
        return exception2;
    }

    private static boolean isEmpty(ResultSet resultSet) {
        if (resultSet == null) {
            return true;
        }
        if (resultSet.error != null) {
            return false;
        }
        if (resultSet.items != null && resultSet.items.length > 0) {
            return false;
        }
        if (resultSet.facets != null && resultSet.facets.length > 0) {
            return false;
        }
        return resultSet.totalMatchedObjectCount == null;
    }

    private boolean traverseOnlyThroughGlobalResources(QuerySpec querySpec) {
        assert (querySpec != null);
        Constraint constraint = querySpec.resourceSpec.constraint;
        String[] stringArray = Utils.getTypeNamesFromConstraint((Constraint)constraint);
        if (!this.containOnlyGlobalResources(stringArray)) {
            return false;
        }
        String[] stringArray2 = Utils.getAllTypeNamesFromConstraint((Constraint)constraint);
        return this.containOnlyGlobalResources(stringArray2);
    }

    private boolean containOnlyGlobalResources(String[] stringArray) {
        if (ArrayUtils.isEmpty((Object[])stringArray)) {
            return false;
        }
        for (String string : stringArray) {
            TypeDescriptor typeDescriptor = this._metadataDirectory.getTypeDescriptor(string);
            if (typeDescriptor.isGlobalResource()) continue;
            return false;
        }
        return true;
    }

    private static Response getData(DynamicProviderAdapter dynamicProviderAdapter, RequestSpec requestSpec) throws Exception {
        QuerySpec querySpec;
        QuerySpec[] querySpecArray = new QuerySpec[requestSpec.querySpec.length];
        int[] nArray = new int[requestSpec.querySpec.length];
        int n = 0;
        for (int i = 0; i < requestSpec.querySpec.length; ++i) {
            querySpec = requestSpec.querySpec[i];
            if (querySpec == null) continue;
            querySpecArray[n] = querySpec;
            nArray[n] = i;
            ++n;
        }
        RequestSpec requestSpec2 = new RequestSpec();
        requestSpec2.enableProfiling = requestSpec.enableProfiling;
        requestSpec2.querySpec = Arrays.copyOf(querySpecArray, n);
        querySpec = dynamicProviderAdapter.getData(requestSpec2);
        ResultSet[] resultSetArray = querySpec.resultSet;
        ResultSet[] resultSetArray2 = new ResultSet[requestSpec.querySpec.length];
        for (int i = 0; i < resultSetArray.length; ++i) {
            resultSetArray2[nArray[i]] = resultSetArray[i];
        }
        Response response = new Response();
        response.executionTimeByDescription = querySpec.executionTimeByDescription;
        response.resultSet = resultSetArray2;
        return response;
    }

    private static RequestSpec requestWithQueries(RequestSpec requestSpec, QuerySpec[] querySpecArray) {
        assert (requestSpec != null);
        assert (querySpecArray != null);
        RequestSpec requestSpec2 = new RequestSpec();
        requestSpec2.enableProfiling = requestSpec.enableProfiling;
        requestSpec2.querySpec = querySpecArray;
        return requestSpec2;
    }

    private static final class MixedFederationRequest {
        final RequestSpec isaRequest;
        final RequestSpec riseRequest;

        MixedFederationRequest(RequestSpec requestSpec, RequestSpec requestSpec2) {
            assert (requestSpec != null);
            assert (requestSpec2 != null);
            this.isaRequest = requestSpec;
            this.riseRequest = requestSpec2;
        }
    }
}

