/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.mixfed;

import com.vmware.cis.data.internal.adapters.federation.VersionAnalyzer;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistryListener;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MixedFederationInventoryServiceTracker
implements LinkedVcGroupRegistryListener {
    private final ConcurrentMap<LinkedVcGroup, LinkedVcGroup> _invSvcVcGroups = new ConcurrentHashMap<LinkedVcGroup, LinkedVcGroup>();
    private final ConcurrentMap<LinkedVcGroup, LinkedVcGroup> _riseVcGroups = new ConcurrentHashMap<LinkedVcGroup, LinkedVcGroup>();

    public static MixedFederationInventoryServiceTracker forSession(String string) {
        assert (string != null);
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistryByClientId((String)string);
        MixedFederationInventoryServiceTracker mixedFederationInventoryServiceTracker = new MixedFederationInventoryServiceTracker();
        linkedVcGroupRegistry.addLinkedVcGroupRegistryListener((LinkedVcGroupRegistryListener)mixedFederationInventoryServiceTracker);
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupRegistry.getLinkedVcGroups()) {
            mixedFederationInventoryServiceTracker.onAddVcGroup(linkedVcGroup);
        }
        return mixedFederationInventoryServiceTracker;
    }

    public boolean noInventoryServices() {
        return this._invSvcVcGroups.isEmpty();
    }

    public boolean onlyInvSvcNodes() {
        return this._riseVcGroups.isEmpty();
    }

    public void onGroupEvent(LinkedVcGroupRegistryListener.Event event) {
        assert (event != null);
        if (LinkedVcGroupRegistryListener.Event.GroupOp.add.equals((Object)event.operation)) {
            this.onAddVcGroup(event.group);
        } else if (LinkedVcGroupRegistryListener.Event.GroupOp.remove.equals((Object)event.operation)) {
            this.onRemoveVcGroup(event.group);
        }
    }

    private void onAddVcGroup(LinkedVcGroup linkedVcGroup) {
        assert (linkedVcGroup != null);
        boolean bl = false;
        boolean bl2 = false;
        for (VcService vcService : linkedVcGroup.getVcServices()) {
            if (VersionAnalyzer.isVersionBeforeRise((String)vcService.getServiceVersion())) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (bl) {
            this._invSvcVcGroups.putIfAbsent(linkedVcGroup, linkedVcGroup);
        }
        if (bl2) {
            this._riseVcGroups.putIfAbsent(linkedVcGroup, linkedVcGroup);
        }
    }

    private void onRemoveVcGroup(LinkedVcGroup linkedVcGroup) {
        assert (linkedVcGroup != null);
        this._invSvcVcGroups.remove(linkedVcGroup);
        this._riseVcGroups.remove(linkedVcGroup);
    }
}

