/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.google.common.collect.ImmutableMap;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.data.adapters.core.CorePropertyConverter;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.ClientSideFiltering;
import com.vmware.vise.data.adapters.core.translator.PropertyConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.PropertyConstraint;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

final class ChildTypePropertyTranslator
implements PropertyConstraintTranslator.PropertyConstraintTranslationHandler {
    public static final String FOLDER_CHILD_TYPE = "Folder/childType";
    private static final String DATACENTER = "Datacenter";
    private static final String DATASTORE = "Datastore";
    private static final String COMPUTE_RESOURCE = "ComputeResource";
    private static final String CLUSTER_COMPUTE_RESOURCE = "ClusterComputeResource";
    private static final String VIRTUAL_MACHINE = "VirtualMachine";
    private static final String VIRTUAL_APP = "VirtualApp";
    private static final String HOST_SYSTEM = "HostSystem";
    private static final String NETWORK = "Network";
    private static final String IS_DATACENTER_FOLDER = "Folder/isDatacenterOrRootFolder";
    private static final String IS_DATASTORE_FOLDER = "Folder/isDatastoreFolder";
    private static final String IS_COMPUTE_RESOURCE_FOLDER = "Folder/isComputeResourceFolder";
    private static final String IS_VM_FOLDER = "Folder/isVirtualMachineFolder";
    private static final String IS_VAPP_FOLDER = "Folder/isVirtualAppFolder";
    private static final String IS_NETWORK_FOLDER = "Folder/isNetworkFolder";
    private final Map<String, String> _equivalentPropertyByType;
    private final RequestPropertyValidator _propertyValidator;
    private final CorePropertyConverter _propertyConverter;

    public ChildTypePropertyTranslator(RequestPropertyValidator requestPropertyValidator, CorePropertyConverter corePropertyConverter) {
        this._propertyValidator = requestPropertyValidator;
        this._propertyConverter = corePropertyConverter;
        this._equivalentPropertyByType = ImmutableMap.builder().put((Object)DATACENTER, (Object)IS_DATACENTER_FOLDER).put((Object)DATASTORE, (Object)IS_DATASTORE_FOLDER).put((Object)COMPUTE_RESOURCE, (Object)IS_COMPUTE_RESOURCE_FOLDER).put((Object)CLUSTER_COMPUTE_RESOURCE, (Object)IS_COMPUTE_RESOURCE_FOLDER).put((Object)VIRTUAL_MACHINE, (Object)IS_VM_FOLDER).put((Object)VIRTUAL_APP, (Object)IS_VAPP_FOLDER).put((Object)HOST_SYSTEM, (Object)IS_COMPUTE_RESOURCE_FOLDER).put((Object)NETWORK, (Object)IS_NETWORK_FOLDER).build();
    }

    @Override
    public Map<String, TranslationResult> tryTranslateConstraint(CoreQueryService coreQueryService, PropertyConstraint propertyConstraint, Map<String, Object> map) {
        String string = this._propertyConverter.toCoreProperty(propertyConstraint.targetType, propertyConstraint.propertyName);
        if (!string.equals(FOLDER_CHILD_TYPE)) {
            return null;
        }
        if (!ClientSideFiltering.isClientSideFilteringEnabled(string, map)) {
            throw new UnsupportedOperationException("Cannot filter by non-filterable property: " + string);
        }
        Filter filter = this.getFilterForFolderChildType(propertyConstraint.comparator, propertyConstraint.comparableValue);
        TranslationResult translationResult = TranslationResult.filter(filter);
        return Collections.singletonMap(propertyConstraint.targetType, translationResult);
    }

    private Filter getFilterForFolderChildType(Comparator comparator, Object object) {
        assert (comparator != null);
        assert (object != null);
        if (!comparator.equals((Object)Comparator.EQUALS) && !comparator.equals((Object)Comparator.CONTAINS)) {
            throw new UnsupportedOperationException(String.format("Unsupported comparator '%s' for property '%s'", comparator, FOLDER_CHILD_TYPE));
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException(String.format("Comparator '%s' requires comparable value of type String for property '%s', but got '%s'", comparator, FOLDER_CHILD_TYPE, object.getClass().getName()));
        }
        String string = this._equivalentPropertyByType.get(object);
        if (!this._propertyValidator.canFilterByProperty(string)) {
            throw new IllegalStateException(String.format("Required filterable property %s is not advertised by RISE", string));
        }
        if (string == null) {
            throw new UnsupportedOperationException(String.format("Unsupported comparator '%s' for property '%s' with comparable value '%s'", Comparator.CONTAINS.name(), FOLDER_CHILD_TYPE, object));
        }
        PropertyPredicate propertyPredicate = new PropertyPredicate(string, PropertyPredicate.ComparisonOperator.EQUAL, (Object)Boolean.TRUE);
        Filter filter = new Filter(Arrays.asList(propertyPredicate));
        return filter;
    }
}

