/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vise.data.adapters.core.CorePropertyConverter;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.ClientSideTypeCoercer;
import com.vmware.vise.data.adapters.core.translator.CoreResourceModelResolver;
import com.vmware.vise.data.adapters.core.translator.PropertyConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.TextSearchTools;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.adapters.core.translator.TranslatorTools;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QueryOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientSideFiltering
implements PropertyConstraintTranslator.PropertyConstraintTranslationHandler {
    private static final Logger _logger = LoggerFactory.getLogger(ClientSideFiltering.class);
    private static final String MAGIC_NULL_CHECK = "null";
    private static final Predicate<Object> PREDICATE_MATCH_EVERYTHING = Predicates.alwaysTrue();
    private final RequestPropertyValidator _propertyValidator;
    private final CorePropertyConverter _propertyConverter;
    private final CoreResourceModelResolver _resourceModelResolver;

    public ClientSideFiltering(RequestPropertyValidator requestPropertyValidator, CorePropertyConverter corePropertyConverter, CoreResourceModelResolver coreResourceModelResolver) {
        this._propertyValidator = requestPropertyValidator;
        this._propertyConverter = corePropertyConverter;
        this._resourceModelResolver = coreResourceModelResolver;
    }

    @Override
    public Map<String, TranslationResult> tryTranslateConstraint(CoreQueryService coreQueryService, PropertyConstraint propertyConstraint, Map<String, Object> map) {
        String string = this._propertyConverter.toCoreProperty(propertyConstraint.targetType, propertyConstraint.propertyName);
        if (!this._propertyValidator.canSelectByProperty(string)) {
            return Collections.emptyMap();
        }
        if (!ClientSideFiltering.isClientSideFilteringEnabled(string, map)) {
            throw new UnsupportedOperationException("Cannot filter by non-filterable property: " + string);
        }
        _logger.warn("Client-side filtering requested by property {} (PropertyConstraint[{}; {}; {}])", new Object[]{string, propertyConstraint.targetType, propertyConstraint.comparator, propertyConstraint.comparableValue});
        TranslationResult translationResult = this.fitlerAtClientSide(coreQueryService, propertyConstraint, string);
        return Collections.singletonMap(propertyConstraint.targetType, translationResult);
    }

    public static boolean isClientSideFilteringEnabled(String string, Map<String, Object> map) {
        assert (string != null);
        boolean bl = ClientSideFiltering.isStrictModeEnabled(map);
        return !bl;
    }

    public static boolean isClientSideSortingEnabled(String string, Map<String, Object> map) {
        assert (string != null);
        boolean bl = ClientSideFiltering.isStrictModeEnabled(map);
        return !bl;
    }

    private TranslationResult fitlerAtClientSide(CoreQueryService coreQueryService, PropertyConstraint propertyConstraint, String string) {
        if (this.isInequalityComparator(propertyConstraint.comparator)) {
            return this.filterByInequalityComparator(coreQueryService, propertyConstraint, string);
        }
        Predicate<Object> predicate = this.tryCreatePredicateForConstraint(propertyConstraint);
        if (predicate == null) {
            return null;
        }
        if (predicate == PREDICATE_MATCH_EVERYTHING) {
            return TranslationResult.all();
        }
        ResultSet resultSet = this.selectResultForFiltering(coreQueryService, propertyConstraint, string);
        return this.filterResultByPredicate(predicate, resultSet, string);
    }

    private Predicate<Object> tryCreatePredicateForConstraint(PropertyConstraint propertyConstraint) {
        assert (propertyConstraint.comparableValue != null);
        String string = propertyConstraint.comparableValue.toString();
        switch (propertyConstraint.comparator) {
            case CONTAINS: {
                return this.createPredicateForContains(string);
            }
            case EQUALS: {
                return this.createPredicateForEquals(string);
            }
            case NOT_EQUALS: {
                return Predicates.not(this.createPredicateForEquals(string));
            }
            case STARTS_WITH: {
                return this.createPredicateForStartsWith(string, false);
            }
            case ENDS_WITH: {
                return this.createPredicateForEndsWith(string, false);
            }
        }
        return null;
    }

    private TranslationResult filterByInequalityComparator(CoreQueryService coreQueryService, PropertyConstraint propertyConstraint, String string) {
        Object object;
        ResultSet resultSet = this.selectResultForFiltering(coreQueryService, propertyConstraint, string);
        if (resultSet.getItems().isEmpty()) {
            return TranslationResult.empty();
        }
        int n = resultSet.getProperties().indexOf(string);
        Object var6_6 = null;
        QuerySchema.PropertyType propertyType = resultSet.getItems().iterator();
        while (propertyType.hasNext() && (var6_6 = (object = (ResourceItem)propertyType.next()).getPropertyValues().get(n)) == null) {
        }
        if (var6_6 == null) {
            return TranslationResult.empty();
        }
        propertyType = ClientSideTypeCoercer.getPropertyType(var6_6);
        object = ClientSideTypeCoercer.tryToCoerce(propertyConstraint.comparableValue, propertyType);
        Predicate<Object> predicate = this.createPredicateForOrdering(propertyConstraint.comparator, object);
        return this.filterResultByPredicate(predicate, resultSet, string);
    }

    private ResultSet selectResultForFiltering(CoreQueryService coreQueryService, PropertyConstraint propertyConstraint, String string) {
        String string2 = String.format("Comparator.%s client-side", propertyConstraint.comparator.name());
        TranslatorTools.Select select = new TranslatorTools.Select(string2, this._propertyValidator, this._resourceModelResolver, coreQueryService);
        ResultSet resultSet = select.execute(propertyConstraint.targetType, TranslationResult.all(), "@modelKey", string);
        return resultSet;
    }

    private TranslationResult filterResultByPredicate(Predicate<Object> predicate, ResultSet resultSet, String string) {
        int n = resultSet.getProperties().indexOf(string);
        int n2 = resultSet.getProperties().indexOf("@modelKey");
        ArrayList arrayList = new ArrayList(resultSet.getItems().size());
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Object e = resourceItem.getPropertyValues().get(n);
            if (!this.deepApplyPredicate(predicate, e)) continue;
            arrayList.add(resourceItem.getPropertyValues().get(n2));
        }
        TranslationResult translationResult = TranslatorTools.toEqualityPredicateResult("@modelKey", arrayList, false);
        return translationResult;
    }

    private boolean deepApplyPredicate(Predicate<Object> predicate, Object object) {
        if (ClientSideFiltering.isArray(object)) {
            return Iterables.any(Arrays.asList((Object[])object), predicate);
        }
        if (object instanceof Collection) {
            return Iterables.any((Iterable)((Collection)object), predicate);
        }
        return predicate.apply(object);
    }

    private Predicate<Object> createPredicateForEquals(final String string) {
        if (string.equalsIgnoreCase(MAGIC_NULL_CHECK)) {
            return new Predicate<Object>(){

                public boolean apply(Object object) {
                    return object == null;
                }
            };
        }
        return new Predicate<Object>(){

            public boolean apply(Object object) {
                return object != null && string.equalsIgnoreCase(object.toString());
            }
        };
    }

    private Predicate<Object> createPredicateForContains(String string) {
        if (StringUtils.strip((String)string, (String)"*").isEmpty()) {
            return PREDICATE_MATCH_EVERYTHING;
        }
        TextSearchTools.SearchTermWildcardInfo searchTermWildcardInfo = TextSearchTools.getSearchTermWildcardInfo(string);
        String string2 = TextSearchTools.unescapeSearchTemplate(searchTermWildcardInfo.getBaseTerm());
        if (!(searchTermWildcardInfo.hasLeadingWildcard() ^ searchTermWildcardInfo.hasTrailingWildcard())) {
            return this.createContainsPredicate(string2);
        }
        if (searchTermWildcardInfo.hasLeadingWildcard()) {
            return this.createPredicateForEndsWith(string2, true);
        }
        assert (searchTermWildcardInfo.hasTrailingWildcard());
        return this.createPredicateForStartsWith(string2, true);
    }

    private Predicate<Object> createContainsPredicate(final String string) {
        return new Predicate<Object>(){

            public boolean apply(Object object) {
                return object != null && StringUtils.containsIgnoreCase((String)object.toString(), (String)string);
            }
        };
    }

    private Predicate<Object> createPredicateForStartsWith(final String string, final boolean bl) {
        return new Predicate<Object>(){

            public boolean apply(Object object) {
                if (object == null) {
                    return false;
                }
                if (bl) {
                    return StringUtils.startsWithIgnoreCase((String)object.toString(), (String)string);
                }
                return StringUtils.startsWith((String)object.toString(), (String)string);
            }
        };
    }

    private Predicate<Object> createPredicateForEndsWith(final String string, final boolean bl) {
        return new Predicate<Object>(){

            public boolean apply(Object object) {
                if (object == null) {
                    return false;
                }
                if (bl) {
                    return StringUtils.endsWithIgnoreCase((String)object.toString(), (String)string);
                }
                return StringUtils.endsWith((String)object.toString(), (String)string);
            }
        };
    }

    private boolean isInequalityComparator(Comparator comparator) {
        switch (comparator) {
            case SMALLER: 
            case SMALLER_OR_EQUALS: 
            case GREATER_OR_EQUALS: 
            case GREATER: {
                return true;
            }
        }
        return false;
    }

    private Predicate<Object> createPredicateForOrdering(Comparator comparator, Object object) {
        if (object instanceof Comparable) {
            return this.createPredicateForComparableInstance(comparator, object);
        }
        String string = object.toString();
        final Predicate<Object> predicate = this.createPredicateForComparableInstance(comparator, string);
        return new Predicate<Object>(){

            public boolean apply(Object object) {
                if (object != null) {
                    return predicate.apply((Object)object.toString());
                }
                return false;
            }
        };
    }

    private Predicate<Object> createPredicateForComparableInstance(final Comparator comparator, Object object) {
        assert (object instanceof Comparable);
        final Comparable comparable = (Comparable)object;
        return new Predicate<Object>(){

            public boolean apply(Object object) {
                if (object == null) {
                    return false;
                }
                int n = -comparable.compareTo(object);
                switch (comparator) {
                    case GREATER: {
                        return n > 0;
                    }
                    case GREATER_OR_EQUALS: {
                        return n >= 0;
                    }
                    case SMALLER: {
                        return n < 0;
                    }
                    case SMALLER_OR_EQUALS: {
                        return n <= 0;
                    }
                }
                throw new IllegalStateException("BUG: unexpected comparator for this predicate: " + comparator);
            }
        };
    }

    private static boolean isStrictModeEnabled(Map<String, Object> map) {
        if (map == null) {
            return false;
        }
        Object object = map.get(QueryOption.VISE_TO_RISE_TRANSLATOR_STRICT_MODE.name());
        return Boolean.TRUE.equals(object);
    }

    private static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }
}

