/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;

final class ClientSideTypeCoercer {
    ClientSideTypeCoercer() {
    }

    static QuerySchema.PropertyType getPropertyType(Object object) {
        if (object instanceof String) {
            return QuerySchema.PropertyType.STRING;
        }
        if (object instanceof Byte) {
            return QuerySchema.PropertyType.BYTE;
        }
        if (object instanceof Short) {
            return QuerySchema.PropertyType.SHORT;
        }
        if (object instanceof Integer) {
            return QuerySchema.PropertyType.INT;
        }
        if (object instanceof Long) {
            return QuerySchema.PropertyType.LONG;
        }
        if (object instanceof Float) {
            return QuerySchema.PropertyType.FLOAT;
        }
        if (object instanceof Double) {
            return QuerySchema.PropertyType.DOUBLE;
        }
        if (object instanceof Boolean) {
            return QuerySchema.PropertyType.BOOLEAN;
        }
        if (object instanceof ManagedObjectReference) {
            return QuerySchema.PropertyType.ID;
        }
        if (object instanceof Enum) {
            return QuerySchema.PropertyType.ENUM;
        }
        return null;
    }

    static Object tryToCoerce(Object object, QuerySchema.PropertyType propertyType) {
        if (object == null || propertyType == null) {
            return object;
        }
        if (object instanceof String) {
            return ClientSideTypeCoercer.tryCoerceStringTo((String)object, propertyType);
        }
        if (object instanceof Byte) {
            return ClientSideTypeCoercer.tryCoerceByteTo((Byte)object, propertyType);
        }
        if (object instanceof Short) {
            return ClientSideTypeCoercer.tryCoerceShortTo((Short)object, propertyType);
        }
        if (object instanceof Integer) {
            return ClientSideTypeCoercer.tryCoerceIntTo((Integer)object, propertyType);
        }
        if (object instanceof Long) {
            return ClientSideTypeCoercer.tryCoerceLongTo((Long)object, propertyType);
        }
        if (object instanceof Float) {
            return ClientSideTypeCoercer.tryCoerceFloatTo((Float)object, propertyType);
        }
        if (object instanceof Double) {
            return ClientSideTypeCoercer.tryCoerceDoubleTo((Double)object, propertyType);
        }
        if (object instanceof Boolean) {
            return ClientSideTypeCoercer.tryCoerceBooleanTo((Boolean)object, propertyType);
        }
        if (object instanceof Enum) {
            return ClientSideTypeCoercer.tryCoerceEnumTo((Enum)object, propertyType);
        }
        if (propertyType.equals((Object)QuerySchema.PropertyType.STRING)) {
            return object.toString();
        }
        return object;
    }

    private static Object tryCoerceEnumTo(Enum<?> enum_, QuerySchema.PropertyType propertyType) {
        switch (propertyType) {
            case STRING: {
                return enum_.toString();
            }
        }
        return enum_;
    }

    private static Object tryCoerceStringTo(String string, QuerySchema.PropertyType propertyType) {
        switch (propertyType) {
            case BYTE: {
                return Byte.valueOf(string);
            }
            case SHORT: {
                return Short.valueOf(string);
            }
            case INT: {
                return Integer.valueOf(string);
            }
            case LONG: {
                return Long.valueOf(string);
            }
            case FLOAT: {
                return Float.valueOf(string);
            }
            case DOUBLE: {
                return Double.valueOf(string);
            }
            case BOOLEAN: {
                return Boolean.valueOf(string);
            }
        }
        return string;
    }

    private static Object tryCoerceByteTo(Byte by, QuerySchema.PropertyType propertyType) {
        switch (propertyType) {
            case STRING: {
                return Byte.toString(by);
            }
            case SHORT: {
                return by.shortValue();
            }
            case INT: {
                return by.intValue();
            }
            case LONG: {
                return by.longValue();
            }
            case FLOAT: {
                return Float.valueOf(by.floatValue());
            }
            case DOUBLE: {
                return by.doubleValue();
            }
        }
        return by;
    }

    private static Object tryCoerceShortTo(Short s, QuerySchema.PropertyType propertyType) {
        switch (propertyType) {
            case STRING: {
                return Short.toString(s);
            }
            case BYTE: {
                return s.byteValue();
            }
            case INT: {
                return s.intValue();
            }
            case LONG: {
                return s.longValue();
            }
            case FLOAT: {
                return Float.valueOf(s.floatValue());
            }
            case DOUBLE: {
                return s.doubleValue();
            }
        }
        return s;
    }

    private static Object tryCoerceIntTo(Integer n, QuerySchema.PropertyType propertyType) {
        switch (propertyType) {
            case STRING: {
                return Integer.toString(n);
            }
            case BYTE: {
                return n.byteValue();
            }
            case SHORT: {
                return n.shortValue();
            }
            case LONG: {
                return n.longValue();
            }
            case FLOAT: {
                return Float.valueOf(n.floatValue());
            }
            case DOUBLE: {
                return n.doubleValue();
            }
        }
        return n;
    }

    private static Object tryCoerceLongTo(Long l, QuerySchema.PropertyType propertyType) {
        switch (propertyType) {
            case STRING: {
                return Long.toString(l);
            }
            case BYTE: {
                return l.byteValue();
            }
            case SHORT: {
                return l.shortValue();
            }
            case INT: {
                return l.intValue();
            }
            case FLOAT: {
                return Float.valueOf(l.floatValue());
            }
            case DOUBLE: {
                return l.doubleValue();
            }
        }
        return l;
    }

    private static Object tryCoerceFloatTo(Float f, QuerySchema.PropertyType propertyType) {
        switch (propertyType) {
            case STRING: {
                return Float.toString(f.floatValue());
            }
            case BYTE: {
                return f.byteValue();
            }
            case SHORT: {
                return f.shortValue();
            }
            case INT: {
                return f.intValue();
            }
            case LONG: {
                return f.longValue();
            }
            case DOUBLE: {
                return f.doubleValue();
            }
        }
        return f;
    }

    private static Object tryCoerceDoubleTo(Double d, QuerySchema.PropertyType propertyType) {
        switch (propertyType) {
            case STRING: {
                return Double.toString(d);
            }
            case BYTE: {
                return d.byteValue();
            }
            case SHORT: {
                return d.shortValue();
            }
            case INT: {
                return d.intValue();
            }
            case LONG: {
                return d.longValue();
            }
            case FLOAT: {
                return Float.valueOf(d.floatValue());
            }
        }
        return d;
    }

    private static Object tryCoerceBooleanTo(Boolean bl, QuerySchema.PropertyType propertyType) {
        switch (propertyType) {
            case STRING: {
                return Boolean.toString(bl);
            }
        }
        return bl;
    }
}

