/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.adapters.core.CorePropertyConverter;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.ReferenceConverter;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.ClientSideFiltering;
import com.vmware.vise.data.adapters.core.translator.CompositeConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.ConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.CoreResourceModelResolver;
import com.vmware.vise.data.adapters.core.translator.PropertyConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.RelationalConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.RelationshipRegistry;
import com.vmware.vise.data.adapters.core.translator.TextSearchConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.adapters.core.translator.TranslatorResolver;
import com.vmware.vise.data.adapters.core.translator.cornercase.RelationalConstraintSpecialCases;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConstraintTranslatorDispatcher
implements TranslatorResolver,
ConstraintTranslator<Constraint> {
    private static final Logger _logger = LoggerFactory.getLogger(ConstraintTranslatorDispatcher.class);
    private final RequestPropertyValidator _propertyValidator;
    private final ConstraintTranslator<RelationalConstraint> _relationalConstraintTranslator;
    private final ConstraintTranslator<CompositeConstraint> _compositeConstraintTranslator;
    private final ConstraintTranslator<PropertyConstraint> _propertyConstraintTranslator;
    private final CoreResourceModelResolver _resourceModelResolver;

    public ConstraintTranslatorDispatcher(RequestPropertyValidator requestPropertyValidator, CorePropertyConverter corePropertyConverter, CoreResourceModelResolver coreResourceModelResolver, AggregatedModelLookup aggregatedModelLookup, RelationshipRegistry relationshipRegistry) {
        Validate.notNull((Object)requestPropertyValidator, (String)"propertyValidator");
        Validate.notNull((Object)relationshipRegistry, (String)"relationshipRegistry");
        this._propertyValidator = requestPropertyValidator;
        this._relationalConstraintTranslator = new RelationalConstraintSpecialCases(this, new RelationalConstraintTranslator(this, this._propertyValidator, corePropertyConverter, coreResourceModelResolver, aggregatedModelLookup, relationshipRegistry));
        this._compositeConstraintTranslator = new CompositeConstraintTranslator(this, this._propertyValidator, aggregatedModelLookup, coreResourceModelResolver);
        this._propertyConstraintTranslator = new PropertyConstraintTranslator(this._propertyValidator, corePropertyConverter, aggregatedModelLookup, new TextSearchConstraintTranslator(this), new ClientSideFiltering(this._propertyValidator, corePropertyConverter, coreResourceModelResolver));
        this._resourceModelResolver = coreResourceModelResolver;
    }

    @Override
    public <T extends Constraint> ConstraintTranslator<T> getTranslator(T t) {
        ConstraintTranslator<Constraint> constraintTranslator = t instanceof CompositeConstraint ? this._compositeConstraintTranslator : (t instanceof RelationalConstraint ? this._relationalConstraintTranslator : (t instanceof PropertyConstraint ? this._propertyConstraintTranslator : this));
        ConstraintTranslatorDispatcher constraintTranslatorDispatcher = constraintTranslator;
        return constraintTranslatorDispatcher;
    }

    @Override
    public Map<String, TranslationResult> translate(CoreQueryService coreQueryService, Constraint constraint, Map<String, Object> map) {
        if (constraint instanceof ObjectIdentityConstraint) {
            return this.translateObjIdConstraint((ObjectIdentityConstraint)constraint);
        }
        if (constraint.getClass().equals(Constraint.class)) {
            return this.translateResTypeConstraint(constraint);
        }
        _logger.warn("Constraint type is unknown to Data Service: {}", constraint.getClass());
        return Collections.emptyMap();
    }

    private Map<String, TranslationResult> translateResTypeConstraint(Constraint constraint) {
        String string = constraint.targetType;
        if (this.isResourceTypeSupported(string)) {
            return Collections.singletonMap(string, TranslationResult.all());
        }
        return Collections.emptyMap();
    }

    private Map<String, TranslationResult> translateObjIdConstraint(ObjectIdentityConstraint objectIdentityConstraint) {
        assert (objectIdentityConstraint != null);
        Validate.notNull((Object)objectIdentityConstraint.target);
        Object object = objectIdentityConstraint.target;
        String string = ConstraintTranslatorDispatcher.tryGetResourceObjectType(object);
        if (object != null && string != null && this.isResourceTypeSupported(string)) {
            PropertyPredicate propertyPredicate = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, object);
            Filter filter = new Filter(Collections.singletonList(propertyPredicate), LogicalOperator.AND);
            return Collections.singletonMap(string, TranslationResult.filter(filter));
        }
        return Collections.emptyMap();
    }

    private boolean isResourceTypeSupported(String string) {
        String string2;
        try {
            string2 = this._resourceModelResolver.getDefaultModel(string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
        return this._propertyValidator.isModelSupported(string2);
    }

    private static String tryGetResourceObjectType(Object object) {
        try {
            return ReferenceConverter.getResourceObjectType(object);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }
}

