/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.vise.data.adapters.core.translator.RelationshipInfo;
import com.vmware.vise.data.adapters.core.translator.RelationshipRegistry;
import com.vmware.vise.search.model.ModelUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;

public final class RelationshipRegistryLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RelationshipRegistry createFromResource(String string) {
        InputStream inputStream = RelationshipRegistryLoader.class.getResourceAsStream(string);
        if (inputStream != null) {
            try {
                List<RelationshipInfo> list = RelationshipRegistryLoader.populateFromStream(inputStream);
                RelationshipRegistry relationshipRegistry = new RelationshipRegistry(list);
                return relationshipRegistry;
            }
            finally {
                RelationshipRegistryLoader.closeQuietly(inputStream);
            }
        }
        throw new IllegalArgumentException("Can't load RelationRegistry from non-existent resource: " + string);
    }

    private static List<RelationshipInfo> populateFromStream(InputStream inputStream) {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{RelationshipInfoMirror.class, InfoListMirror.class});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            JAXBElement jAXBElement = unmarshaller.unmarshal((Source)new StreamSource(inputStream), InfoListMirror.class);
            return RelationshipRegistryLoader.populateFromInfoList((JAXBElement<InfoListMirror>)jAXBElement);
        }
        catch (JAXBException jAXBException) {
            throw new IllegalStateException("Internal error: failed to create JAXB unmarshaller while loading the relation registry.", jAXBException);
        }
    }

    private static List<RelationshipInfo> populateFromInfoList(JAXBElement<InfoListMirror> jAXBElement) {
        Object object;
        InfoListMirror infoListMirror = (InfoListMirror)jAXBElement.getValue();
        RelationshipInfoMirror[] relationshipInfoMirrorArray = infoListMirror != null && infoListMirror.relationshipInfos != null ? infoListMirror.relationshipInfos : new RelationshipInfoMirror[]{};
        HashMultimap hashMultimap = HashMultimap.create();
        for (RelationshipInfoMirror relationshipInfoMirror : relationshipInfoMirrorArray) {
            RelationshipRegistryLoader.validateLoadedRelationInfo(relationshipInfoMirror);
            hashMultimap.putAll((Object)relationshipInfoMirror.name, relationshipInfoMirror.inverseRelationships);
            for (String object2 : relationshipInfoMirror.inverseRelationships) {
                hashMultimap.put((Object)object2, (Object)relationshipInfoMirror.name);
            }
        }
        HashSet hashSet = new HashSet();
        ArrayList<RelationshipInfo> arrayList = new ArrayList<RelationshipInfo>(hashMultimap.size());
        for (RelationshipInfoMirror relationshipInfoMirror : relationshipInfoMirrorArray) {
            object = hashMultimap.get((Object)relationshipInfoMirror.name);
            if (object.isEmpty()) {
                throw new IllegalStateException(String.format("No inverse relationships defined for relationship %s. (Shoudl be removed from the registry if such doesn't exist.)", relationshipInfoMirror.name));
            }
            RelationshipInfo relationshipInfo = new RelationshipInfo(relationshipInfoMirror.name, RelationshipRegistryLoader.getSourceType(relationshipInfoMirror), relationshipInfoMirror.multiCardinality, hashMultimap.get((Object)relationshipInfoMirror.name));
            arrayList.add(relationshipInfo);
            hashSet.add(relationshipInfoMirror.name);
        }
        for (String string : hashMultimap.keySet()) {
            if (hashSet.contains(string)) continue;
            String string2 = RelationshipRegistryLoader.getSourceTypeFromImplicitDef(string);
            boolean bl = false;
            object = new RelationshipInfo(string, string2, bl, hashMultimap.get((Object)string));
            arrayList.add((RelationshipInfo)object);
        }
        return arrayList;
    }

    private static String getSourceType(RelationshipInfoMirror relationshipInfoMirror) {
        if (ModelUtils.isVmodl2Name((String)relationshipInfoMirror.name)) {
            return relationshipInfoMirror.sourceType;
        }
        return QualifiedProperty.forQualifiedName((String)relationshipInfoMirror.name).getResourceModel();
    }

    private static String getSourceTypeFromImplicitDef(String string) {
        if (ModelUtils.isVmodl2Name((String)string)) {
            throw new IllegalStateException(String.format("VMODL2 relationship %s need to be defined explictly with its source type.", string));
        }
        return QualifiedProperty.forQualifiedName((String)string).getResourceModel();
    }

    private static void validateLoadedRelationInfo(RelationshipInfoMirror relationshipInfoMirror) {
        RelationshipRegistryLoader.validateRelationInfoField(relationshipInfoMirror.name, "name");
        RelationshipRegistryLoader.validateRelationInfoField(relationshipInfoMirror.multiCardinality, "multiCardinality");
        if (ModelUtils.isVmodl2Name((String)relationshipInfoMirror.name) && relationshipInfoMirror.sourceType == null) {
            throw new IllegalStateException("Failed to load RelationshipInfo due to missing sourceType for VMODL2 relationship: " + relationshipInfoMirror.name);
        }
    }

    private static void validateRelationInfoField(Object object, String string) {
        if (object == null) {
            throw new IllegalStateException("Failed to load RelationshipInfo due to missing required field: " + string);
        }
    }

    private static void closeQuietly(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @XmlRootElement(name="relationship-infos")
    private static final class InfoListMirror {
        @XmlElement(name="RelationshipInfo")
        public RelationshipInfoMirror[] relationshipInfos;

        private InfoListMirror() {
        }
    }

    private static final class RelationshipInfoMirror {
        public String name;
        public String sourceType;
        public Boolean multiCardinality;
        @XmlJavaTypeAdapter(value=TokenizerAdapter.class)
        public Set<String> inverseRelationships = Collections.emptySet();

        private RelationshipInfoMirror() {
        }
    }

    private static final class TokenizerAdapter
    extends XmlAdapter<String, Set<String>> {
        private TokenizerAdapter() {
        }

        public Set<String> unmarshal(String string) throws Exception {
            Object[] objectArray = StringUtils.split((String)string, (String)" \t\r\n");
            return Sets.newHashSet((Object[])objectArray);
        }

        public String marshal(Set<String> set) throws Exception {
            return StringUtils.join(set, (String)"\n");
        }
    }
}

