/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.vmware.vise.data.adapters.core.translator.CoreResourceModelResolver;
import com.vmware.vise.data.adapters.core.translator.ViseResourceTypeResolver;
import com.vmware.vise.search.model.ModelUtils;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class StaticResourceModelResolver
implements CoreResourceModelResolver,
ViseResourceTypeResolver {
    private static final Map<String, String> DEFAULT_MODELS_BY_TYPE = ImmutableMap.builder().put((Object)"com.vmware.content.Library", (Object)"com.vmware.content.LibraryModel").put((Object)"com.vmware.content.library.Item", (Object)"com.vmware.content.library.ItemModel").build();
    private static final Map<String, String> TYPE_BY_MODEL = ImmutableMap.builder().put((Object)"com.vmware.content.LibraryModel", (Object)"com.vmware.content.Library").put((Object)"com.vmware.content.library.ItemModel", (Object)"com.vmware.content.library.Item").put((Object)"com.vmware.content.type.ovf.OvfTemplate", (Object)"com.vmware.content.library.Item").put((Object)"com.vmware.vcenter.vm_template.LibraryItems.Info", (Object)"com.vmware.content.library.Item").put((Object)"com.vmware.cis.tagging.CategoryModel", (Object)"com.vmware.cis.tagging.Category").put((Object)"com.vmware.cis.tagging.TagModel", (Object)"com.vmware.cis.tagging.Tag").put((Object)"com.vmware.cis.tagging.TagAssociationModel", (Object)"com.vmware.cis.tagging.TagAssociation").build();
    private static final ImmutableBiMap<String, String> CORE_MODELS_BY_VISE_TYPE = ImmutableBiMap.builder().put((Object)"ResourcePool", (Object)"AnyResourcePool").put((Object)"ComputeResource", (Object)"AnyComputeResource").put((Object)"DistributedVirtualSwitch", (Object)"AnyDistributedVirtualSwitch").put((Object)"AuthenticationManager", (Object)"HostAuthenticationManager").put((Object)"CacheConfigurationManager", (Object)"HostCacheConfigurationManager").put((Object)"DatastoreSystem", (Object)"HostDatastoreSystem").put((Object)"DiagnosticSystem", (Object)"HostDiagnosticSystem").put((Object)"FirewallSystem", (Object)"HostFirewallSystem").put((Object)"NetworkSystem", (Object)"HostNetworkSystem").put((Object)"PciPassthruSystem", (Object)"HostPciPassthruSystem").put((Object)"PowerSystem", (Object)"HostPowerSystem").put((Object)"StorageSystem", (Object)"HostStorageSystem").build();
    private static final Map<String, String> VISE_TYPES_BY_CORE_MODEL = CORE_MODELS_BY_VISE_TYPE.inverse();

    @Override
    public String getDefaultModel(String string) {
        Validate.notEmpty((String)string, (String)"resourceType is required.");
        if (!ModelUtils.isVmodl2Name((String)string)) {
            return string;
        }
        String string2 = DEFAULT_MODELS_BY_TYPE.get(string);
        if (string2 == null) {
            throw new UnsupportedOperationException("Deftault model not known for resource type: " + string);
        }
        return string2;
    }

    @Override
    public String toCoreResourceType(String string) {
        String string2 = (String)CORE_MODELS_BY_VISE_TYPE.get((Object)string);
        return string2 == null ? string : string2;
    }

    @Override
    public String toViseResourceType(String string) {
        String string2 = VISE_TYPES_BY_CORE_MODEL.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = TYPE_BY_MODEL.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }
}

