/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.risetovise;

import com.google.common.collect.ImmutableSet;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.vise.data.adapters.core.translator.ViseResourceTypeResolver;
import com.vmware.vise.data.adapters.risetovise.RiseToViseProperty;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

final class RiseToViseFromClause {
    private static final String OBJECT_TYPE = "Object";
    private static final Set<String> ABSTRACT_BASE_TYPES = ImmutableSet.of((Object)"Object", (Object)"ManagedObject", (Object)"ManagedEntity");
    private final ViseResourceTypeResolver _viseTypeResolver;

    public RiseToViseFromClause(ViseResourceTypeResolver viseResourceTypeResolver) {
        assert (viseResourceTypeResolver != null);
        this._viseTypeResolver = viseResourceTypeResolver;
    }

    public String getResourceType(Query query) {
        assert (query != null);
        assert (query.getResourceModels() != null);
        assert (!query.getResourceModels().isEmpty());
        if (RiseToViseFromClause.targetObjectType(query.getResourceModels()) && RiseToViseFromClause.hasInverseRelation(query)) {
            return null;
        }
        Collection<String> collection = this.getResourceTypes(query.getResourceModels());
        assert (!collection.isEmpty());
        if (collection.size() > 1) {
            throw new IllegalArgumentException("Query uses models from multiple resource types: " + collection);
        }
        return collection.iterator().next();
    }

    private Collection<String> getResourceTypes(Collection<String> collection) {
        assert (collection != null);
        assert (!collection.isEmpty());
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : collection) {
            String string2 = this.getResourceType(string);
            linkedHashSet.add(string2);
        }
        return linkedHashSet;
    }

    private String getResourceType(String string) {
        assert (string != null);
        if (ABSTRACT_BASE_TYPES.contains(string)) {
            throw new IllegalArgumentException("Abstract base types cannot be used as resource models: " + string);
        }
        String string2 = this._viseTypeResolver.toViseResourceType(string);
        return string2;
    }

    private static boolean hasInverseRelation(Query query) {
        Filter filter = query.getFilter();
        if (filter == null) {
            return false;
        }
        for (PropertyPredicate propertyPredicate : filter.getCriteria()) {
            if (!RiseToViseProperty.isInverseRelation(propertyPredicate.getProperty())) continue;
            return true;
        }
        return false;
    }

    private static boolean targetObjectType(Collection<String> collection) {
        if (collection.size() > 1) {
            return false;
        }
        String string = collection.iterator().next();
        return OBJECT_TYPE.equals(string);
    }
}

