/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.common;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.search.SearchService;
import com.vmware.vise.search.metadata.Descriptor;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.TypeDescriptor;
import com.vmware.vise.util.StringUtil;
import org.apache.commons.lang.Validate;

public final class SearchMetadataQueryCriteria {
    private final ObjectReferenceService _objRefSvc;
    private final MetadataDirectory _metadataDirectory;

    public SearchMetadataQueryCriteria(ObjectReferenceService objectReferenceService, SearchService searchService) {
        Validate.notNull((Object)objectReferenceService);
        Validate.notNull((Object)searchService);
        this._objRefSvc = objectReferenceService;
        this._metadataDirectory = searchService.getMetadataDirectory();
    }

    public MetadataDirectory getMetadataDirectory() {
        return this._metadataDirectory;
    }

    public boolean consistsOnlyOfUnsupportedTypes(QuerySpec querySpec) {
        Validate.notNull((Object)querySpec);
        ResourceSpec resourceSpec = querySpec.resourceSpec;
        if (resourceSpec.constraint != null) {
            return this.consistsOnlyOfUnsupportedTypes(resourceSpec.constraint);
        }
        return this.consistsOnlyOfUnsupportedTypes(resourceSpec.propertySpecs);
    }

    private boolean consistsOnlyOfUnsupportedTypes(PropertySpec[] propertySpecArray) {
        if (propertySpecArray == null) {
            return false;
        }
        boolean bl = false;
        for (PropertySpec propertySpec : propertySpecArray) {
            if (propertySpec == null || propertySpec.type == null) continue;
            if (this.isSupportedType(propertySpec.type)) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    private boolean consistsOnlyOfUnsupportedTypes(Constraint constraint) {
        String string = this.getTargetType(constraint);
        if (string != null && !this.isSupportedType(string)) {
            return true;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            boolean bl = true;
            for (Constraint constraint2 : compositeConstraint.nestedConstraints) {
                bl = bl && this.consistsOnlyOfUnsupportedTypes(constraint2);
            }
            return bl;
        }
        if (constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            return this.consistsOnlyOfUnsupportedTypes(relationalConstraint.constraintOnRelatedObject);
        }
        return false;
    }

    private String getTargetType(Constraint constraint) {
        String string = constraint.targetType;
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            if (objectIdentityConstraint.target != null) {
                string = this._objRefSvc.getResourceObjectType(objectIdentityConstraint.target);
            }
        }
        return string;
    }

    private boolean isSupportedType(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return false;
        }
        TypeDescriptor typeDescriptor = this._metadataDirectory.getTypeDescriptor(string);
        return typeDescriptor != null && MetadataUtil.isSupported((Descriptor)typeDescriptor);
    }
}

