/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.common;

import com.vmware.vise.util.OpIdUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class SessionPropagatingExecutorService
implements ExecutorService {
    private final ExecutorService _delegate;

    public SessionPropagatingExecutorService(ExecutorService executorService) {
        this._delegate = executorService;
    }

    @Override
    public void execute(Runnable runnable) {
        this._delegate.execute(this.wrapWithSessionPropagation(runnable));
    }

    @Override
    public void shutdown() {
        this._delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this._delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this._delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this._delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this._delegate.awaitTermination(l, timeUnit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this._delegate.submit(this.wrapWithSessionPropagation(callable));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this._delegate.submit(this.wrapWithSessionPropagation(runnable), t);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this._delegate.submit(this.wrapWithSessionPropagation(runnable));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        return this._delegate.invokeAll(this.wrapAll(collection));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        return this._delegate.invokeAll(this.wrapAll(collection), l, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        return (T)this._delegate.invokeAny(this.wrapAll(collection));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this._delegate.invokeAny(this.wrapAll(collection), l, timeUnit);
    }

    private <V> Collection<Callable<V>> wrapAll(Collection<? extends Callable<V>> collection) {
        ArrayList<Callable<V>> arrayList = new ArrayList<Callable<V>>();
        for (Callable<V> callable : collection) {
            arrayList.add(this.wrapWithSessionPropagation(callable));
        }
        return arrayList;
    }

    private Runnable wrapWithSessionPropagation(final Runnable runnable) {
        final long l = Thread.currentThread().getId();
        final String string = OpIdUtil.getCustomOpIdPrefix();
        final SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext();
        return new Runnable(){

            @Override
            public void run() {
                long l2 = Thread.currentThread().getId();
                if (l2 != l) {
                    SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                    OpIdUtil.setCustomOpIdPrefix((String)string);
                }
                try {
                    runnable.run();
                }
                finally {
                    if (l2 != l) {
                        SessionUtil.setThreadContext(null);
                        OpIdUtil.setCustomOpIdPrefix(null);
                    }
                }
            }
        };
    }

    private <V> Callable<V> wrapWithSessionPropagation(final Callable<V> callable) {
        final long l = Thread.currentThread().getId();
        final String string = OpIdUtil.getCustomOpIdPrefix();
        final SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext();
        return new Callable<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V call() throws Exception {
                long l2 = Thread.currentThread().getId();
                if (l2 != l) {
                    SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                    OpIdUtil.setCustomOpIdPrefix((String)string);
                }
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    if (l2 != l) {
                        SessionUtil.setThreadContext(null);
                        OpIdUtil.setCustomOpIdPrefix(null);
                    }
                }
            }
        };
    }
}

