/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResourceObjectReferenceAdapter;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.ObjectReferenceServiceImpl;
import com.vmware.vise.data.query.internal.DataServiceExtensionRegistryFactory;
import com.vmware.vise.data.uri.DefaultUriSchemeResolver;
import com.vmware.vise.data.uri.InventoryServiceResourceTypeResolver;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.data.uri.UriRefTypeAdapter;
import com.vmware.vise.search.SearchService;
import com.vmware.vise.search.impl.SearchServiceFactory;
import com.vmware.vise.search.util.QueryGenerator;
import com.vmware.vise.vim.data.adapters.search.QueryRequest;
import com.vmware.vise.vim.data.adapters.search.impl.MorRefTypeAdapter;
import com.vmware.vise.vim.data.adapters.search.impl.QueryRequestTransformer;

public class VimXQueryGenerator {
    private final SearchService _searchService;
    private final QueryRequestTransformer _queryRequestTransformer;

    public VimXQueryGenerator() {
        DataServiceExtensionRegistryInternal dataServiceExtensionRegistryInternal = (DataServiceExtensionRegistryInternal)DataServiceExtensionRegistryFactory.createDataServiceExtensionRegistry((boolean)true);
        UriRefTypeAdapter uriRefTypeAdapter = UriRefTypeAdapter.getUriRefTypeAdapter((DataServiceExtensionRegistry)dataServiceExtensionRegistryInternal);
        this.setUpDataServiceRegistry((DataServiceExtensionRegistry)dataServiceExtensionRegistryInternal, uriRefTypeAdapter);
        this._searchService = SearchServiceFactory.newSearchService(null, null);
        ObjectReferenceServiceImpl objectReferenceServiceImpl = new ObjectReferenceServiceImpl(dataServiceExtensionRegistryInternal);
        this._queryRequestTransformer = new QueryRequestTransformer(this._searchService, (ObjectReferenceService)objectReferenceServiceImpl);
    }

    public String generate(QuerySpec querySpec) {
        QueryRequest queryRequest = this._queryRequestTransformer.toQueryRequest(querySpec);
        if (queryRequest == null) {
            throw new IllegalArgumentException("The given query spec is invalid.");
        }
        QueryGenerator queryGenerator = this._searchService.getQueryGenerator();
        String string = queryGenerator.generate(queryRequest.getQuerySpec(), queryRequest.getResponseSpec());
        return string;
    }

    private void setUpDataServiceRegistry(DataServiceExtensionRegistry dataServiceExtensionRegistry, UriRefTypeAdapter uriRefTypeAdapter) {
        assert (dataServiceExtensionRegistry != null);
        assert (uriRefTypeAdapter != null);
        DefaultUriSchemeResolver defaultUriSchemeResolver = DefaultUriSchemeResolver.getDefaultUriSchemeResolver((ResourceTypeResolverRegistry)uriRefTypeAdapter);
        InventoryServiceResourceTypeResolver inventoryServiceResourceTypeResolver = InventoryServiceResourceTypeResolver.getResolver((ResourceTypeResolverRegistry)uriRefTypeAdapter);
        dataServiceExtensionRegistry.registerObjectRefTypeAdapter((ResourceObjectReferenceAdapter)new MorRefTypeAdapter(), ManagedObjectReference.class, "urn:vmomi");
    }
}

