/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.FacetValue;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.search.impl.NamespaceUtils;
import com.vmware.vise.util.ValidationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class AtTypePropertyResultTransformerUtil {
    private static final Log _logger = LogFactory.getLog(AtTypePropertyResultTransformerUtil.class);
    private static final String AT_TYPE_PROP = "@type";
    private static final String DEFAULT_IS_NAMESPACE = "urn:" + NamespaceUtils.DEFAULT_NAMESPACE;

    private AtTypePropertyResultTransformerUtil() {
    }

    static void transform(QuerySpec querySpec, ResultSet resultSet) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{querySpec, resultSet});
        AtTypePropertyResultTransformerUtil.transformResultItems(querySpec.resourceSpec.propertySpecs, resultSet.items);
        if (querySpec.resultSpec != null) {
            AtTypePropertyResultTransformerUtil.transformFacets(resultSet.facets);
        }
    }

    private static void transformFacets(FacetInfo[] facetInfoArray) {
        if (facetInfoArray == null || facetInfoArray.length == 0) {
            return;
        }
        for (FacetInfo facetInfo : facetInfoArray) {
            assert (facetInfo.propSpec != null);
            assert (facetInfo.propSpec.propertyNames.length > 0);
            for (String string : facetInfo.propSpec.propertyNames) {
                if (!AtTypePropertyResultTransformerUtil.needsTransform(string)) continue;
                AtTypePropertyResultTransformerUtil.transformFacetInfo(facetInfo);
            }
        }
    }

    private static void transformFacetInfo(FacetInfo facetInfo) {
        FacetValue[] facetValueArray;
        for (FacetValue facetValue : facetValueArray = facetInfo.facetValues) {
            facetValue.value = AtTypePropertyResultTransformerUtil.transformValue(facetValue.value);
        }
    }

    private static void transformResultItems(PropertySpec[] propertySpecArray, ResultItem[] resultItemArray) {
        if (resultItemArray == null || resultItemArray.length == 0 || propertySpecArray == null || propertySpecArray.length == 0) {
            return;
        }
        for (PropertySpec propertySpec : propertySpecArray) {
            for (String string : propertySpec.propertyNames) {
                if (!AtTypePropertyResultTransformerUtil.needsTransform(string)) continue;
                AtTypePropertyResultTransformerUtil.transformResultItems(resultItemArray);
            }
        }
    }

    private static void transformResultItems(ResultItem[] resultItemArray) {
        for (ResultItem resultItem : resultItemArray) {
            PropertyValue[] propertyValueArray;
            for (PropertyValue propertyValue : propertyValueArray = resultItem.properties) {
                if (!propertyValue.propertyName.equals(AT_TYPE_PROP)) continue;
                propertyValue.value = AtTypePropertyResultTransformerUtil.transformValue(propertyValue.value);
            }
        }
    }

    private static Object transformValue(Object object) {
        if (!(object instanceof String)) {
            _logger.error((Object)(object.toString() + " is not a String. It is " + object.getClass().getName()));
            return "";
        }
        String string = (String)object;
        if (string.startsWith(DEFAULT_IS_NAMESPACE)) {
            string = string.substring(DEFAULT_IS_NAMESPACE.length() + 1);
        }
        if (string.startsWith("urn")) {
            string = string.substring("urn".length() + 1);
        }
        return string;
    }

    private static boolean needsTransform(String string) {
        assert (string != null);
        return string.equals(AT_TYPE_PROP);
    }
}

