/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vise.data.query.ResourceObjectReferenceAdapter;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorRefTypeAdapter
implements ResourceObjectReferenceAdapter {
    private static final Logger _logger = LoggerFactory.getLogger(MorRefTypeAdapter.class);

    public String getUid(Object object) {
        if (!(object instanceof ManagedObjectReference)) {
            return null;
        }
        return ManagedObjectUtil.morefToString((ManagedObjectReference)((ManagedObjectReference)object));
    }

    public String getServerGuid(Object object) {
        if (!(object instanceof ManagedObjectReference)) {
            return null;
        }
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
        return managedObjectReference.getServerGuid();
    }

    public String getResourceType(Object object) {
        if (!(object instanceof ManagedObjectReference)) {
            return null;
        }
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
        String string = MorRefTypeAdapter.getQualifiedType(managedObjectReference.getType());
        return string;
    }

    public Object getReference(String string) {
        return ManagedObjectUtil.stringToMoref((String)string);
    }

    private static String getQualifiedType(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(58) != -1) {
            return string;
        }
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(string);
        if (vmodlType == null) {
            _logger.warn("Could not find ManagedObjectReference type in the global VMODL1 type map: '{}'", (Object)string);
            return null;
        }
        String string2 = string;
        String string3 = vmodlType.getVersion().getNamespace();
        if (!ManagedObjectUtil.isDefaultNamespace((String)string3)) {
            string2 = string3 + ":" + string;
        }
        return string2;
    }
}

