/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.messaging.amf;

import com.vmware.vise.messaging.amf.EnumWrapper;
import flex.messaging.io.SerializationContext;
import java.io.IOException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class Amf3Output
extends flex.messaging.io.amf.Amf3Output {
    private static final Log _logger = LogFactory.getLog(Amf3Output.class);

    public Amf3Output(SerializationContext serializationContext) {
        super(serializationContext);
    }

    public void writeObject(Object object) throws IOException {
        if (object instanceof Enum) {
            object = new EnumWrapper((Enum)object);
        }
        super.writeObject(object);
    }

    protected String documentToString(Object object) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendNode(stringBuilder, (Node)object);
        return stringBuilder.toString();
    }

    private void appendNode(StringBuilder stringBuilder, Node node) {
        switch (node.getNodeType()) {
            case 1: {
                Element element = (Element)node;
                stringBuilder.append("<").append(element.getTagName());
                NamedNodeMap namedNodeMap = element.getAttributes();
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node2 = namedNodeMap.item(i);
                    stringBuilder.append(" ").append(node2.getNodeName()).append("=\"").append(StringEscapeUtils.escapeXml((String)node2.getNodeValue())).append("\"");
                }
                Node node3 = element.getFirstChild();
                if (node3 != null) {
                    stringBuilder.append(">");
                    while (node3 != null) {
                        this.appendNode(stringBuilder, node3);
                        node3 = node3.getNextSibling();
                    }
                    stringBuilder.append("</").append(element.getTagName()).append(">");
                    break;
                }
                stringBuilder.append("/>");
                break;
            }
            case 3: {
                Text text = (Text)node;
                String string = text.getData();
                if (string == null || string.length() == 0) break;
                stringBuilder.append(StringEscapeUtils.escapeXml((String)string));
                break;
            }
            case 4: {
                CDATASection cDATASection = (CDATASection)node;
                stringBuilder.append("<![CDATA[").append(cDATASection.getData()).append("]]>");
                break;
            }
            case 5: {
                stringBuilder.append("&").append(node.getNodeName()).append(";");
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                stringBuilder.append("<?").append(processingInstruction.getTarget()).append(" ").append(processingInstruction.getData()).append("?>");
                break;
            }
            case 8: {
                Comment comment = (Comment)node;
                stringBuilder.append("<!--").append(comment.getData()).append("-->");
                break;
            }
            case 9: {
                Document document = (Document)node;
                for (Node node4 = document.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    this.appendNode(stringBuilder, node4);
                }
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                stringBuilder.append("<!DOCTYPE ").append(documentType.getName()).append(">");
                break;
            }
            default: {
                _logger.error((Object)("Invalid node: " + node.getClass().getName()));
            }
        }
    }
}

