/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.cdc.vcenter.listener.AlarmChangeListener;
import com.vmware.cdc.vcenter.listener.ChangeNotifier;
import com.vmware.cdc.vcenter.listener.ChangeNotifierFactory;
import com.vmware.cdc.vcenter.listener.ListenerSpecBuilder;
import com.vmware.cdc.vcenter.listener.ResourceChangeListener;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.liveupdates.LiveUpdatesUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.messaging.ChangeNotifierManager;
import com.vmware.vise.vim.messaging.ChangeNotifierStateContext;
import com.vmware.vise.vim.messaging.ListenerKind;
import com.vmware.vise.vim.messaging.context.support.Session;
import com.vmware.vise.vim.messaging.listeners.AlarmListener;
import com.vmware.vise.vim.messaging.listeners.ResourceListener;
import com.vmware.vise.vim.messaging.util.WebUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;

public class ChangeNotifierManagerImpl
implements DisposableBean,
ChangeNotifierManager {
    private static final Log _logger = LogFactory.getLog(ChangeNotifierManagerImpl.class);
    private final ConfigurationService _configurationService;
    private final ChangeNotifierFactory _changeNotifierFactory;
    private final LinkedVcGroupRegistry _linkedVcGroupRegistry;
    private final ObjectFactory<AlarmListener> _alarmChangeListenerFactory;
    private final ObjectFactory<ResourceListener> _resourceChangeListenerFactory;
    private final Executor _liveUpdatesExecutor;
    private HttpServletRequest _fakeHttpRequest;
    private final ConcurrentMap<String, ChangeNotifierStateContext> _changeNotifierByVcId = new ConcurrentHashMap<String, ChangeNotifierStateContext>();
    private boolean _changeNotifiersCommitted = false;
    private boolean _changeNotifiersClosed = false;

    public ChangeNotifierManagerImpl(ConfigurationService configurationService, ChangeNotifierFactory changeNotifierFactory, LinkedVcGroupRegistry linkedVcGroupRegistry, ObjectFactory<AlarmListener> objectFactory, ObjectFactory<ResourceListener> objectFactory2, Executor executor) {
        this._configurationService = configurationService;
        this._changeNotifierFactory = changeNotifierFactory;
        this._linkedVcGroupRegistry = linkedVcGroupRegistry;
        this._alarmChangeListenerFactory = objectFactory;
        this._resourceChangeListenerFactory = objectFactory2;
        this._liveUpdatesExecutor = executor;
    }

    public void startup() throws Exception {
        this._fakeHttpRequest = Session.createFakeHttpRequest((String)WebUtils.getCurrentClientId());
        this._changeNotifiersCommitted = false;
        this._changeNotifiersClosed = false;
    }

    @Override
    public void configure() {
        if (!LiveUpdatesUtil.changeLogEnabled((ConfigurationService)this._configurationService)) {
            return;
        }
        this._liveUpdatesExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ChangeNotifierManagerImpl.this._changeNotifiersCommitted) {
                    return;
                }
                SessionUtil.setHttpRequest((HttpServletRequest)ChangeNotifierManagerImpl.this._fakeHttpRequest);
                try {
                    LinkedVcGroup[] linkedVcGroupArray;
                    for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray = ChangeNotifierManagerImpl.this._linkedVcGroupRegistry.getLinkedVcGroups()) {
                        if (linkedVcGroup == null) continue;
                        for (VcService vcService : linkedVcGroup.getVcServices()) {
                            if (vcService == null || !ChangeNotifierManagerImpl.this.shouldRegisterChangeNotifier(vcService)) continue;
                            ChangeNotifierManagerImpl.this.registerNotifier(vcService);
                        }
                    }
                }
                finally {
                    SessionUtil.setHttpRequest(null);
                }
            }
        });
    }

    @Override
    public void openInventory(final String string) {
        if (StringUtil.isNullOrEmpty((String)string) || !LiveUpdatesUtil.resourceChangesEnabled((ConfigurationService)this._configurationService)) {
            return;
        }
        this._liveUpdatesExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SessionUtil.setHttpRequest((HttpServletRequest)ChangeNotifierManagerImpl.this._fakeHttpRequest);
                try {
                    ChangeNotifierStateContext changeNotifierStateContext = (ChangeNotifierStateContext)ChangeNotifierManagerImpl.this._changeNotifierByVcId.get(string);
                    if (changeNotifierStateContext == null) {
                        return;
                    }
                    if (changeNotifierStateContext.registeredListeners.contains((Object)ListenerKind.INVENTORY)) {
                        return;
                    }
                    if (changeNotifierStateContext.resourceChangeListener == null) {
                        changeNotifierStateContext.resourceChangeListener = (ResourceListener)ChangeNotifierManagerImpl.this._resourceChangeListenerFactory.getObject();
                    }
                    changeNotifierStateContext.registeredListeners.add(ListenerKind.INVENTORY);
                    ChangeNotifierManagerImpl.this.reconfigureAndCommit(string, (EnumSet<ListenerKind>)changeNotifierStateContext.registeredListeners);
                }
                finally {
                    SessionUtil.setHttpRequest(null);
                }
            }
        });
    }

    @Override
    public void closeInventory(final String string) {
        if (StringUtil.isNullOrEmpty((String)string) || !LiveUpdatesUtil.resourceChangesEnabled((ConfigurationService)this._configurationService)) {
            return;
        }
        this._liveUpdatesExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SessionUtil.setHttpRequest((HttpServletRequest)ChangeNotifierManagerImpl.this._fakeHttpRequest);
                try {
                    ChangeNotifierStateContext changeNotifierStateContext = (ChangeNotifierStateContext)ChangeNotifierManagerImpl.this._changeNotifierByVcId.get(string);
                    if (changeNotifierStateContext == null) {
                        return;
                    }
                    if (!changeNotifierStateContext.registeredListeners.contains((Object)ListenerKind.INVENTORY)) {
                        return;
                    }
                    changeNotifierStateContext.registeredListeners.remove((Object)ListenerKind.INVENTORY);
                    ChangeNotifierManagerImpl.this.reconfigureAndCommit(string, (EnumSet<ListenerKind>)changeNotifierStateContext.registeredListeners);
                }
                finally {
                    SessionUtil.setHttpRequest(null);
                }
            }
        });
    }

    private void registerNotifier(VcService vcService) {
        ChangeNotifierStateContext changeNotifierStateContext = new ChangeNotifierStateContext();
        changeNotifierStateContext.changeNotifier = this._changeNotifierFactory.forVmomiProvider(vcService.getVmomiClient());
        changeNotifierStateContext.listenerSpecBuilder = changeNotifierStateContext.changeNotifier.listeners();
        if (LiveUpdatesUtil.alarmsEnabled((ConfigurationService)this._configurationService)) {
            changeNotifierStateContext.alarmChangeListener = (AlarmListener)this._alarmChangeListenerFactory.getObject();
            changeNotifierStateContext.listenerSpecBuilder.add((AlarmChangeListener)changeNotifierStateContext.alarmChangeListener);
            changeNotifierStateContext.registeredListeners.add(ListenerKind.ALARMS);
        }
        this._changeNotifierByVcId.put(vcService.getServiceGuid(), changeNotifierStateContext);
    }

    @Override
    public void reconfigureAndCommit(final ChangeNotifier changeNotifier, final EnumSet<ListenerKind> enumSet) {
        this._liveUpdatesExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SessionUtil.setHttpRequest((HttpServletRequest)ChangeNotifierManagerImpl.this._fakeHttpRequest);
                try {
                    ChangeNotifierManagerImpl.this.doReconfigureAndCommit(changeNotifier, enumSet);
                }
                finally {
                    SessionUtil.setHttpRequest(null);
                }
            }
        });
    }

    private void reconfigureAndCommit(String string, EnumSet<ListenerKind> enumSet) {
        ChangeNotifierStateContext changeNotifierStateContext = (ChangeNotifierStateContext)this._changeNotifierByVcId.get(string);
        if (changeNotifierStateContext == null) {
            return;
        }
        this.doReconfigureAndCommit(changeNotifierStateContext.changeNotifier, enumSet);
    }

    private void doReconfigureAndCommit(ChangeNotifier changeNotifier, EnumSet<ListenerKind> enumSet) {
        changeNotifier.close();
        for (Map.Entry entry : this._changeNotifierByVcId.entrySet()) {
            LinkedVcGroup[] linkedVcGroupArray;
            ChangeNotifierStateContext changeNotifierStateContext = (ChangeNotifierStateContext)entry.getValue();
            if (changeNotifierStateContext.changeNotifier != changeNotifier) continue;
            for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray = this._linkedVcGroupRegistry.getLinkedVcGroups()) {
                if (linkedVcGroup == null) continue;
                for (VcService vcService : linkedVcGroup.getVcServices()) {
                    ChangeNotifier changeNotifier2;
                    if (vcService == null || !vcService.getServiceGuid().equals(entry.getKey())) continue;
                    changeNotifierStateContext.changeNotifier = changeNotifier2 = this._changeNotifierFactory.forVmomiProvider(vcService.getVmomiClient());
                    ListenerSpecBuilder listenerSpecBuilder = changeNotifierStateContext.changeNotifier.listeners();
                    if (changeNotifierStateContext.alarmChangeListener != null) {
                        listenerSpecBuilder.add((AlarmChangeListener)changeNotifierStateContext.alarmChangeListener);
                    }
                    if (enumSet.contains((Object)ListenerKind.INVENTORY) && changeNotifierStateContext.resourceChangeListener != null) {
                        listenerSpecBuilder.add((ResourceChangeListener)changeNotifierStateContext.resourceChangeListener);
                    }
                    if (!enumSet.isEmpty()) {
                        listenerSpecBuilder.commit();
                    }
                    return;
                }
            }
        }
    }

    @Override
    public void commitConfiguration() {
        if (!LiveUpdatesUtil.changeLogEnabled((ConfigurationService)this._configurationService)) {
            return;
        }
        this._liveUpdatesExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ChangeNotifierManagerImpl.this._changeNotifiersCommitted) {
                    return;
                }
                SessionUtil.setHttpRequest((HttpServletRequest)ChangeNotifierManagerImpl.this._fakeHttpRequest);
                try {
                    Collection collection = ChangeNotifierManagerImpl.this._changeNotifierByVcId.values();
                    if (collection.isEmpty()) {
                        return;
                    }
                    for (ChangeNotifierStateContext changeNotifierStateContext : collection) {
                        if (changeNotifierStateContext.listenerSpecBuilder == null || changeNotifierStateContext.registeredListeners.isEmpty()) continue;
                        changeNotifierStateContext.listenerSpecBuilder.commit();
                    }
                    ChangeNotifierManagerImpl.this._changeNotifiersCommitted = true;
                    ChangeNotifierManagerImpl.this._changeNotifiersClosed = false;
                }
                finally {
                    SessionUtil.setHttpRequest(null);
                }
            }
        });
    }

    @Override
    public void closeNotifiers() {
        this._liveUpdatesExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ChangeNotifierManagerImpl.this._changeNotifiersClosed) {
                    return;
                }
                SessionUtil.setHttpRequest((HttpServletRequest)ChangeNotifierManagerImpl.this._fakeHttpRequest);
                try {
                    ChangeNotifierManagerImpl.this._changeNotifiersCommitted = false;
                    for (ChangeNotifierStateContext changeNotifierStateContext : ChangeNotifierManagerImpl.this._changeNotifierByVcId.values()) {
                        try {
                            changeNotifierStateContext.changeNotifier.close();
                        }
                        catch (Exception exception) {
                            _logger.error((Object)"Error closing notifier:", (Throwable)exception);
                        }
                    }
                    ChangeNotifierManagerImpl.this._changeNotifierByVcId.clear();
                    ChangeNotifierManagerImpl.this._changeNotifiersClosed = true;
                }
                finally {
                    SessionUtil.setHttpRequest(null);
                }
            }
        });
    }

    public void destroy() throws Exception {
        this.closeNotifiers();
        _logger.debug((Object)"unregistered available change notifiers");
        this._fakeHttpRequest = null;
    }

    private boolean shouldRegisterChangeNotifier(VcService vcService) {
        return !this._changeNotifierByVcId.containsKey(vcService.getServiceGuid()) && VcServiceUtil.is65VcOrLaterByVersion((String)vcService.getServiceVersion());
    }
}

