/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.messaging.AbsoluteDataValuesProvider;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.messaging.ChangeNotifierManager;
import com.vmware.vise.vim.messaging.Monitor;
import com.vmware.vise.vim.messaging.context.support.ClientIdHolder;
import com.vmware.vise.vim.messaging.context.support.Session;
import com.vmware.vise.vim.messaging.websocket.Controller;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectFactory;

public class LiveUpdatesSubscriptionController
implements Controller {
    private static final Log _logger = LogFactory.getLog(LiveUpdatesSubscriptionController.class);
    private final Monitor _monitor;
    private final Map<String, List<AbsoluteDataValuesProvider<?>>> _absoluteDataValuesProvidersByDestination;
    private final ChangeNotifierManager _changeNotifierManager;
    private final ObjectFactory<MessageSender> _messageSenderFactory;
    private static final String OPEN_INVENTORY = "OPEN_INVENTORY";
    private static final String CLOSE_INVENTORY = "CLOSE_INVENTORY";

    public LiveUpdatesSubscriptionController(Monitor monitor, Map<String, List<AbsoluteDataValuesProvider<?>>> map, ChangeNotifierManager changeNotifierManager, ObjectFactory<MessageSender> objectFactory) {
        this._monitor = monitor;
        this._absoluteDataValuesProvidersByDestination = map;
        this._changeNotifierManager = changeNotifierManager;
        this._messageSenderFactory = objectFactory;
    }

    public Object handleRequest(String string, javax.websocket.Session session) {
        String string2 = string;
        if (this.isListenerChange(string2)) {
            return this.changeListener(string2);
        }
        return this.subscribe(string2, session);
    }

    private Object changeListener(String string) {
        Object[] objectArray = string.split(":");
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || objectArray.length < 2) {
            return null;
        }
        Object object = objectArray[1];
        if (StringUtil.isNullOrEmpty((String)object)) {
            return null;
        }
        if (string.startsWith(OPEN_INVENTORY)) {
            this._changeNotifierManager.openInventory((String)object);
            return null;
        }
        if (string.startsWith(CLOSE_INVENTORY)) {
            this._changeNotifierManager.closeInventory((String)object);
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object subscribe(String string, javax.websocket.Session session) {
        Object[] objectArray = string.split("destination:");
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || objectArray.length < 2) {
            _logger.error((Object)"Request is not in the expected format.");
            return null;
        }
        Object object = objectArray[1];
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Initializing Live Updates Pipeline ..." + (String)object));
        }
        this._changeNotifierManager.configure();
        this._monitor.monitorEvents((String)object);
        this._changeNotifierManager.commitConfiguration();
        _logger.debug((Object)"Live Updates Pipeline Ready!");
        String string2 = ClientIdHolder.getClientId();
        HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        SessionUtil.setHttpRequest((HttpServletRequest)Session.createFakeHttpRequest((String)string2));
        try {
            PartialUpdate<?> partialUpdate = this.getAvailableDataValuesByDestination((String)object);
            if (partialUpdate == null || partialUpdate.isEmpty()) {
                Object var8_8 = null;
                return var8_8;
            }
            partialUpdate.destination = object;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Available absolute values for " + (String)object + " are retrieved!"));
            }
            ((MessageSender)this._messageSenderFactory.getObject()).sendToSession(partialUpdate, session);
        }
        finally {
            SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
        }
        return null;
    }

    private boolean isListenerChange(String string) {
        return string.startsWith(OPEN_INVENTORY) || string.startsWith(CLOSE_INVENTORY);
    }

    private PartialUpdate<?> getAvailableDataValuesByDestination(String string) {
        List<AbsoluteDataValuesProvider<?>> list = this._absoluteDataValuesProvidersByDestination.get(string);
        AbsoluteDataValuesProvider<Object> absoluteDataValuesProvider = null;
        absoluteDataValuesProvider = list == null || list.isEmpty() ? new AbsoluteDataValuesProvider<Object>(){

            public PartialUpdate<Object> getAvailableDataValues() {
                return PartialUpdate.empty();
            }
        } : list.get(0);
        PartialUpdate partialUpdate = absoluteDataValuesProvider.getAvailableDataValues();
        return partialUpdate;
    }
}

