/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.messaging.Monitor;
import com.vmware.vise.vim.messaging.UpdatesManager;
import com.vmware.vise.vim.messaging.util.WebUtils;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;

public class MonitorImpl
implements Monitor,
DisposableBean {
    private static final Log _logger = LogFactory.getLog(MonitorImpl.class);
    private final UpdatesManager _updatesManager;
    private final MessageSender _messageSender;
    private final Set<String> _subscribedDestinations;
    private final String _clientId;
    private final AtomicBoolean _updatesProcessingCancelled;

    public MonitorImpl(UpdatesManager updatesManager, MessageSender messageSender) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{updatesManager, messageSender});
        this._updatesManager = updatesManager;
        this._messageSender = messageSender;
        this._subscribedDestinations = new CopyOnWriteArraySet<String>();
        this._clientId = WebUtils.getCurrentClientId();
        this._updatesProcessingCancelled = new AtomicBoolean(false);
    }

    public void init() {
        this._updatesManager.init(this._clientId);
        this._messageSender.onClose(new Runnable(){

            @Override
            public void run() {
                try {
                    MonitorImpl.this._updatesManager.cancelUpdates();
                    MonitorImpl.this._updatesProcessingCancelled.set(true);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)String.format("[LiveRefresh] [%s] closed his Websocket.", MonitorImpl.this._updatesManager.getUsername()));
                    }
                }
                catch (Exception exception) {
                    _logger.error((Object)"Error closing the notifiers:", (Throwable)exception);
                }
            }
        });
    }

    @Override
    public void monitorEvents(String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        if (this._updatesProcessingCancelled.compareAndSet(true, false)) {
            this.logRefreshDetected();
            this.init();
        }
        if (this._subscribedDestinations.add(string)) {
            this._updatesManager.subscribe(string);
            this.logSubscription(string);
        }
    }

    private void logRefreshDetected() {
        if (!_logger.isDebugEnabled()) {
            return;
        }
        _logger.debug((Object)String.format("[LiveRefresh] Detected browser refresh for username [%s], clientId [%s], re-init the streams...", this._updatesManager.getUsername(), this._clientId));
    }

    private void logSubscription(String string) {
        if (!_logger.isDebugEnabled()) {
            return;
        }
        _logger.debug((Object)String.format("[LiveRefresh] Subscribe to destination [%s]: for session with clientId: [%s], thread id: [%d]username: [%s]", string, this._clientId, Thread.currentThread().getId(), this._updatesManager.getUsername()));
    }

    @Override
    public void cancelEvents(String string) {
    }

    public void destroy() throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("[LiveRefresh] Destroying monitor for username [%s], clientId [%s]", this._updatesManager.getUsername(), this._clientId));
        }
        this._messageSender.onClose(null);
        this._updatesManager.cancelUpdates();
    }
}

