/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.cdc.vcenter.ResourceChange;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.data.uri.VapiUriSchemeUtil;
import com.vmware.vise.vim.commons.messaging.CdcProcessor;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectDetailsUpdatesProcessor
implements CdcProcessor<Object> {
    static final String HAS_OBJECT_STATE_METADATA_ATTRIBUTE = "hasObjectStateProperty";
    private static final Map<String, Set<String>> _objectStatePropertiesByType = Collections.unmodifiableMap(ObjectDetailsUpdatesProcessor.initObjectRepresenationPropertiesMap());

    public ObjectDetailsUpdatesProcessor() {
        ObjectDetailsUpdatesProcessor.initObjectRepresenationPropertiesMap();
    }

    public PartialUpdate<Object> process(List<ResourceChange> list) {
        HashSet hashSet;
        Object object;
        PartialUpdate partialUpdate = PartialUpdate.empty();
        if (list == null || list.isEmpty()) {
            return partialUpdate;
        }
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        HashMap hashMap2 = new HashMap();
        for (ResourceChange object2 : list) {
            object = object2.getResource();
            if (object2.getKind() != ResourceChange.Kind.UPDATE) continue;
            if (object instanceof String) {
                object = VapiUriSchemeUtil.createUri((String)object2.getResourceType(), (String)((String)object2.getResource()));
            }
            if (!hashMap.containsKey(object)) {
                hashMap.put(object, this.hasObjectStateProperty(object2));
            } else {
                hashMap.put(object, (Boolean)hashMap.get(object) | this.hasObjectStateProperty(object2));
            }
            hashSet = (Set)hashMap2.get(object);
            if (hashSet == null) {
                hashSet = new HashSet();
                hashMap2.put(object, hashSet);
            }
            hashSet.addAll(object2.getProperties());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = PartialUpdateItem.of(entry.getKey(), null);
            hashSet = (HashSet)hashMap2.get(entry.getKey());
            assert (hashSet != null);
            ((PartialUpdateItem)object).deltaProperties = new ArrayList(hashSet);
            object.assignMetadata(HAS_OBJECT_STATE_METADATA_ATTRIBUTE, entry.getValue());
            partialUpdate.updates.add(object);
        }
        return partialUpdate;
    }

    private static Map<String, Set<String>> initObjectRepresenationPropertiesMap() {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashMap.put(ClusterComputeResource.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashMap.put(Datacenter.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("hostMount");
        hashSet.add("summary.accessible");
        hashSet.add("overallStatus");
        hashSet.add("summary.maintenanceMode");
        hashMap.put(Datastore.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashSet.add("isUplinkPortgroup");
        hashSet.add("tag");
        hashMap.put(DistributedVirtualPortgroup.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashMap.put(DistributedVirtualSwitch.class.getSimpleName(), hashSet);
        hashMap.put(VmwareDistributedVirtualSwitch.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("isRootFolder");
        hashMap.put(Folder.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("runtime.connectionState");
        hashSet.add("runtime.powerState");
        hashSet.add("overallStatus");
        hashSet.add("summary.rebootRequired");
        hashSet.add("runtime");
        hashMap.put(HostSystem.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashMap.put(Network.class.getSimpleName(), hashSet);
        hashMap.put(OpaqueNetwork.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashMap.put(ResourcePool.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("overallStatus");
        hashMap.put(StoragePod.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("vAppConfig.managedBy");
        hashSet.add("isSuspended");
        hashSet.add("summary.suspended");
        hashSet.add("powerState");
        hashSet.add("summary.vAppState");
        hashSet.add("summary");
        hashMap.put(VirtualApp.class.getSimpleName(), hashSet);
        hashSet = new HashSet();
        hashSet.add("name");
        hashSet.add("config.template");
        hashSet.add("runtime.connectionState");
        hashSet.add("ftRole");
        hashSet.add("config.ftInfo.role");
        hashSet.add("config.managedBy");
        hashSet.add("runtime.question");
        hashSet.add("overallStatus");
        hashSet.add("runtime.powerState");
        hashSet.add("runtime.faultToleranceState");
        hashMap.put(VirtualMachine.class.getSimpleName(), hashSet);
        return hashMap;
    }

    private boolean hasObjectStateProperty(ResourceChange resourceChange) {
        List list = resourceChange.getProperties();
        if (list == null) {
            return false;
        }
        Set<String> set = _objectStatePropertiesByType.get(resourceChange.getResourceType());
        if (set == null) {
            return false;
        }
        for (String string : list) {
            if (!set.contains(string)) continue;
            return true;
        }
        return false;
    }
}

