/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging;

import com.vmware.vim.binding.vim.UserSession;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.InvalidProperty;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.liveupdates.LiveUpdatesUtil;
import com.vmware.vise.util.session.SessionDataContainerMissingException;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.messaging.UpdatesProcessor;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceConnectionInfo;
import com.vmware.vise.vim.messaging.ChangeNotifierManager;
import com.vmware.vise.vim.messaging.FilterRegistry;
import com.vmware.vise.vim.messaging.context.support.Session;
import com.vmware.vise.vim.messaging.pollers.AlarmIssuePollerFactory;
import com.vmware.vise.vim.messaging.pollers.Poller;
import com.vmware.vise.vim.messaging.pollers.PropertyCollectorPollerFactory;
import com.vmware.vise.vim.messaging.pollers.TaskRegistryPoller;
import com.vmware.vise.vim.messaging.updates.MutationOperationUpdatesHandler;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;

public final class UpdatesManager
implements DisposableBean {
    private static final Log _logger = LogFactory.getLog(UpdatesManager.class);
    private final LinkedVcGroupRegistry _linkedVcGroupRegistry;
    private HttpServletRequest _fakeHttpRequest = null;
    private String _userName;
    private final FilterRegistry _filterRegistry;
    private final ConfigurationService _configurationService;
    private final PropertyCollectorPollerFactory _propertyCollectorPollerFactory;
    private final TaskRegistryPoller _taskRegistryPoller;
    private final AlarmIssuePollerFactory _alarmIssuePollerFactory;
    private final MutationOperationUpdatesHandler _mutationOperationUpdatesHandler;
    private final MessageSender _messageSender;
    private final List<UpdatesProcessor<?>> _updatesProcessors;
    private final ChangeNotifierManager _changeNotifierManager;
    private final Executor _liveUpdatesExecutor;
    private List<Poller> _pollers = new CopyOnWriteArrayList<Poller>();

    public UpdatesManager(LinkedVcGroupRegistry linkedVcGroupRegistry, FilterRegistry filterRegistry, ConfigurationService configurationService, PropertyCollectorPollerFactory propertyCollectorPollerFactory, TaskRegistryPoller taskRegistryPoller, AlarmIssuePollerFactory alarmIssuePollerFactory, MutationOperationUpdatesHandler mutationOperationUpdatesHandler, ChangeNotifierManager changeNotifierManager, List<UpdatesProcessor<?>> list, Executor executor, MessageSender messageSender) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{linkedVcGroupRegistry, filterRegistry, configurationService, propertyCollectorPollerFactory, taskRegistryPoller, alarmIssuePollerFactory, mutationOperationUpdatesHandler, changeNotifierManager, list, executor, messageSender});
        this._linkedVcGroupRegistry = linkedVcGroupRegistry;
        this._filterRegistry = filterRegistry;
        this._configurationService = configurationService;
        this._propertyCollectorPollerFactory = propertyCollectorPollerFactory;
        this._taskRegistryPoller = taskRegistryPoller;
        this._alarmIssuePollerFactory = alarmIssuePollerFactory;
        this._mutationOperationUpdatesHandler = mutationOperationUpdatesHandler;
        this._changeNotifierManager = changeNotifierManager;
        this._updatesProcessors = list;
        this._liveUpdatesExecutor = executor;
        this._messageSender = messageSender;
    }

    public void subscribe(final String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        if (string.equals("/topic/navTree") || string.equals("/topic/object-details") || !LiveUpdatesUtil.recentTasksEnabled((ConfigurationService)this._configurationService)) {
            return;
        }
        this._liveUpdatesExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SessionUtil.setHttpRequest((HttpServletRequest)UpdatesManager.this._fakeHttpRequest);
                try {
                    Set set = UpdatesManager.this.getCurrentUserVCs();
                    UpdatesManager.this.createPCfilters(string, set);
                }
                finally {
                    SessionUtil.setHttpRequest(null);
                }
            }
        });
    }

    public void init(String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        this._fakeHttpRequest = Session.createFakeHttpRequest((String)string);
        this._liveUpdatesExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SessionUtil.setHttpRequest((HttpServletRequest)UpdatesManager.this._fakeHttpRequest);
                try {
                    Set set = UpdatesManager.this.getCurrentUserVCs();
                    UpdatesManager.this.saveUsername(set);
                    if (LiveUpdatesUtil.recentTasksEnabled((ConfigurationService)UpdatesManager.this._configurationService)) {
                        UpdatesManager.this.createPropertyCollectorPollers(set);
                    }
                    UpdatesManager.this.createAlarmIssuePoller();
                    UpdatesManager.this._taskRegistryPoller.addUpdateHandler(UpdatesManager.this._messageSender);
                }
                finally {
                    SessionUtil.setHttpRequest(null);
                }
            }
        });
    }

    public void cancelUpdates() {
        this._taskRegistryPoller.removeUpdateHandler(this._messageSender);
        this._mutationOperationUpdatesHandler.removeHandler(this._messageSender);
        this._liveUpdatesExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SessionUtil.setHttpRequest((HttpServletRequest)UpdatesManager.this._fakeHttpRequest);
                try {
                    for (Poller poller : UpdatesManager.this._pollers) {
                        try {
                            poller.stop();
                        }
                        catch (Exception exception) {
                            _logger.error((Object)"Error stopping poller:", (Throwable)exception);
                        }
                    }
                    UpdatesManager.this._pollers.clear();
                }
                finally {
                    SessionUtil.setHttpRequest(null);
                }
            }
        });
        SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
        try {
            this._changeNotifierManager.closeNotifiers();
        }
        catch (SessionDataContainerMissingException sessionDataContainerMissingException) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"cancelUpdates() SessionDataContainer is missing for _changeNotifierManager");
            }
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }

    public void destroy() {
        this._taskRegistryPoller.removeUpdateHandler(this._messageSender);
        this._mutationOperationUpdatesHandler.removeHandler(this._messageSender);
    }

    public String getUsername() {
        return this._userName;
    }

    private void createPropertyCollectorPollers(Set<VcService> set) {
        try {
            if (!set.isEmpty()) {
                for (VcService vcService : set) {
                    Poller poller = this._propertyCollectorPollerFactory.createPoller(this._userName, this._fakeHttpRequest, vcService, this._filterRegistry);
                    poller.setHandler(this._messageSender);
                    poller.start();
                    this._pollers.add(poller);
                }
            } else {
                _logger.error((Object)"[LiveRefresh] No Property Collector Streams were created");
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"[LiveRefresh] Property Collector Streams failed to be created");
        }
    }

    private void createAlarmIssuePoller() {
        try {
            boolean bl;
            boolean bl2 = LiveUpdatesUtil.alarmsEnabled((ConfigurationService)this._configurationService);
            boolean bl3 = bl = !LiveUpdatesUtil.alarmsPcBasedUpdateEnabled((ConfigurationService)this._configurationService);
            if (bl2 && bl) {
                Poller poller = this._alarmIssuePollerFactory.createPoller(this._userName, this._fakeHttpRequest);
                poller.setHandler(this._messageSender);
                poller.start();
                this._pollers.add(poller);
                this._mutationOperationUpdatesHandler.addHandler(this._messageSender);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"[LiveRefresh] Alarms Stream failed to be created");
        }
    }

    private void saveUsername(Set<VcService> set) {
        if (set.isEmpty()) {
            return;
        }
        for (VcService vcService : set) {
            VcServiceConnectionInfo vcServiceConnectionInfo;
            if (vcService == null || (vcServiceConnectionInfo = vcService.getConnectionInfo()) == null) {
                _logger.error((Object)"VC ConnectionInfo is null");
                continue;
            }
            UserSession userSession = vcServiceConnectionInfo.getUserSession();
            if (userSession == null) {
                _logger.error((Object)("UserSession is not active for vc:" + vcService.getServiceGuid()));
                continue;
            }
            if (this._userName != null) continue;
            this._userName = userSession.userName;
            if (this._userName == null) continue;
            break;
        }
    }

    private void createPCfilters(String string, Set<VcService> set) {
        for (VcService vcService : set) {
            List<ManagedObjectReference> list = this.registerFilter(string, vcService);
            for (ManagedObjectReference managedObjectReference : list) {
                this._filterRegistry.add(managedObjectReference, string);
            }
        }
    }

    private Set<VcService> getCurrentUserVCs() {
        LinkedVcGroup[] linkedVcGroupArray;
        HashSet<VcService> hashSet = new HashSet<VcService>();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray = this._linkedVcGroupRegistry.getLinkedVcGroups()) {
            if (linkedVcGroup == null) continue;
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                if (vcService == null) continue;
                hashSet.add(vcService);
            }
        }
        return hashSet;
    }

    private List<ManagedObjectReference> registerFilter(String string, VcService vcService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, vcService});
        PropertyCollector propertyCollector = (PropertyCollector)vcService.getManagedObject(vcService.getServiceInstanceContent().propertyCollector);
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        for (UpdatesProcessor<?> updatesProcessor : this._updatesProcessors) {
            PropertyCollector.FilterSpec filterSpec = updatesProcessor.createFilterSpec(string, vcService);
            if (filterSpec == null) continue;
            try {
                boolean bl = true;
                ManagedObjectReference managedObjectReference = propertyCollector.createFilter(filterSpec, bl);
                arrayList.add(managedObjectReference);
            }
            catch (InvalidProperty invalidProperty) {
                _logger.error((Object)"[LiveRefresh] Unable to register PC filter: ", (Throwable)invalidProperty);
            }
        }
        return arrayList;
    }
}

