/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.extension;

import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.vim.messaging.websocket.BroadcastService;

public class PluginPackageNotifier
implements ExtensionListener {
    private static final String PLUGIN_DEPLOYMENT_DESTINATION = "/topic/plugin-deployment";
    private final BroadcastService _broadcastService;

    public PluginPackageNotifier(BroadcastService broadcastService) {
        this._broadcastService = broadcastService;
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) throws Exception {
        if (!"pluginPackageDeployed".equals(pluginPackageEvent.getType())) {
            return;
        }
        NewPluginMessage newPluginMessage = new NewPluginMessage();
        newPluginMessage.destination = PLUGIN_DEPLOYMENT_DESTINATION;
        newPluginMessage.newPluginsCount = pluginPackageEvent.getPluginPackageInfos().length;
        if (newPluginMessage.newPluginsCount > 0) {
            this._broadcastService.broadcast((Object)newPluginMessage);
        }
    }

    static class NewPluginMessage {
        String destination;
        int newPluginsCount;

        NewPluginMessage() {
        }
    }
}

