/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.listeners;

import com.vmware.cdc.vcenter.AlarmChange;
import com.vmware.cdc.vcenter.listener.AlarmChangeListener;
import com.vmware.cdc.vcenter.listener.ChangeNotifier;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.messaging.AlarmChangeProcessor;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.messaging.ChangeNotifierManager;
import com.vmware.vise.vim.messaging.ListenerKind;
import com.vmware.vise.vim.messaging.context.support.Session;
import com.vmware.vise.vim.messaging.updates.AlarmUpdate;
import com.vmware.vise.vim.messaging.util.WebUtils;
import com.vmware.vise.vim.messaging.utils.LoggingHelper;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmListener
implements AlarmChangeListener {
    private static final Log _logger = LogFactory.getLog(AlarmListener.class);
    private final ChangeNotifierManager _changeNotifierManager;
    private final MessageSender _messageSender;
    private final List<AlarmChangeProcessor<?>> _alarmChangeProcessors;
    private volatile HttpServletRequest _fakeHttpRequest;
    private String _clientId;

    public AlarmListener(ChangeNotifierManager changeNotifierManager, List<AlarmChangeProcessor<?>> list, MessageSender messageSender) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{changeNotifierManager, list, messageSender});
        this._changeNotifierManager = changeNotifierManager;
        this._messageSender = messageSender;
        this._alarmChangeProcessors = list;
    }

    public synchronized void startup() throws Exception {
        this._clientId = WebUtils.getCurrentClientId();
        this._fakeHttpRequest = Session.createFakeHttpRequest((String)this._clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChanges(ChangeNotifier changeNotifier, Collection<AlarmChange> collection) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{changeNotifier, collection});
        AlarmUpdate alarmUpdate = new AlarmUpdate(collection);
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
            this.processAlarmChanges(alarmUpdate, this._clientId);
            if (_logger.isDebugEnabled()) {
                LoggingHelper.logTotalProcessingForChange(alarmUpdate, this._clientId, System.currentTimeMillis() - alarmUpdate.createdOn, _logger);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("[LiveRefresh] AlarmUpdates error: " + exception.getMessage()), (Throwable)exception);
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(ChangeNotifier changeNotifier, IllegalStateException illegalStateException) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{changeNotifier, illegalStateException});
        Throwable throwable = illegalStateException.getCause();
        if (throwable != null && (throwable instanceof InterruptedException || throwable.getCause() != null && throwable.getCause() instanceof InterruptedException)) {
            return;
        }
        _logger.error((Object)"AlarmListener error:", (Throwable)illegalStateException);
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
            this._changeNotifierManager.reconfigureAndCommit(changeNotifier, EnumSet.of(ListenerKind.ALARMS, ListenerKind.INVENTORY));
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }

    private void processAlarmChanges(AlarmUpdate alarmUpdate, String string) {
        LoggingHelper.logChanges("AlarmUpdate(" + alarmUpdate.id + ")", alarmUpdate.changes, string, _logger);
        Collection<AlarmChange> collection = alarmUpdate.changes;
        for (AlarmChangeProcessor<?> alarmChangeProcessor : this._alarmChangeProcessors) {
            try {
                PartialUpdate partialUpdate = alarmChangeProcessor.process(collection, alarmUpdate.id);
                if (partialUpdate == null) continue;
                if (StringUtil.isNullOrEmpty((String)partialUpdate.getDestination())) {
                    partialUpdate.setDestination("/topic/alarms");
                }
                if (_logger.isDebugEnabled()) {
                    partialUpdate.changeId = alarmUpdate.id;
                    partialUpdate.timeWhenUpdateIsPushedToTheStream = System.currentTimeMillis();
                    partialUpdate.timeWhenChangeIsReceived = alarmUpdate.createdOn;
                }
                try {
                    this._messageSender.send((Object)partialUpdate);
                }
                catch (Exception exception) {
                    _logger.error((Object)"Error sending the update to the websocket:", (Throwable)exception);
                }
            }
            catch (Exception exception) {
                _logger.error((Object)"[LiveRefresh] Alarms (CDC) err: ", (Throwable)exception);
            }
        }
    }
}

