/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.listeners;

import com.vmware.cdc.vcenter.ResourceChange;
import com.vmware.cdc.vcenter.listener.ChangeNotifier;
import com.vmware.cdc.vcenter.listener.ResourceChangeListener;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.liveupdates.LiveUpdatesUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.messaging.CdcProcessor;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.messaging.ChangeNotifierManager;
import com.vmware.vise.vim.messaging.ListenerKind;
import com.vmware.vise.vim.messaging.context.support.Session;
import com.vmware.vise.vim.messaging.updates.ResourceUpdate;
import com.vmware.vise.vim.messaging.util.WebUtils;
import com.vmware.vise.vim.messaging.utils.LoggingHelper;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceListener
implements ResourceChangeListener {
    private static final Log _logger = LogFactory.getLog(ResourceListener.class);
    private final ChangeNotifierManager _changeNotifierManager;
    private final ConfigurationService _configurationService;
    private final MessageSender _messageSender;
    private final CdcProcessor<?> _navTreeProcessor;
    private final CdcProcessor<?> _objDetailsProcessor;
    private volatile HttpServletRequest _fakeHttpRequest;
    private String _clientId;

    public ResourceListener(ChangeNotifierManager changeNotifierManager, ConfigurationService configurationService, CdcProcessor<?> cdcProcessor, CdcProcessor<?> cdcProcessor2, MessageSender messageSender) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{changeNotifierManager, configurationService, cdcProcessor, cdcProcessor2, messageSender});
        this._changeNotifierManager = changeNotifierManager;
        this._configurationService = configurationService;
        this._messageSender = messageSender;
        this._navTreeProcessor = cdcProcessor;
        this._objDetailsProcessor = cdcProcessor2;
    }

    public synchronized void startup() throws Exception {
        this._clientId = WebUtils.getCurrentClientId();
        this._fakeHttpRequest = Session.createFakeHttpRequest((String)this._clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChanges(ChangeNotifier changeNotifier, Collection<ResourceChange> collection) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{changeNotifier, collection});
        ResourceUpdate resourceUpdate = new ResourceUpdate(new ArrayList<ResourceChange>(collection));
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
            LoggingHelper.logChanges("ResourceUpdate(" + resourceUpdate.id + ")", resourceUpdate.changes, this._clientId, _logger);
            if (LiveUpdatesUtil.navTreeEnabled((ConfigurationService)this._configurationService) || LiveUpdatesUtil.listsEnabled((ConfigurationService)this._configurationService)) {
                this.processTreeUpdates(resourceUpdate);
            }
            this.processObjectDetailsUpdates(resourceUpdate);
            if (_logger.isDebugEnabled()) {
                LoggingHelper.logTotalProcessingForChange(resourceUpdate, this._clientId, System.currentTimeMillis() - resourceUpdate.createdOn, _logger);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("[LiveRefresh] ResourceUpdates error: " + exception.getMessage()), (Throwable)exception);
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(ChangeNotifier changeNotifier, IllegalStateException illegalStateException) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{changeNotifier, illegalStateException});
        Throwable throwable = illegalStateException.getCause();
        if (throwable != null && (throwable instanceof InterruptedException || throwable.getCause() != null && throwable.getCause() instanceof InterruptedException)) {
            return;
        }
        _logger.error((Object)"ResourceListener error:", (Throwable)illegalStateException);
        try {
            SessionUtil.setHttpRequest((HttpServletRequest)this._fakeHttpRequest);
            this._changeNotifierManager.reconfigureAndCommit(changeNotifier, EnumSet.of(ListenerKind.ALARMS, ListenerKind.INVENTORY));
        }
        finally {
            SessionUtil.setHttpRequest(null);
        }
    }

    private void processTreeUpdates(ResourceUpdate resourceUpdate) {
        List<ResourceChange> list = resourceUpdate.changes;
        try {
            PartialUpdate partialUpdate = this._navTreeProcessor.process(list);
            partialUpdate.setDestination("/topic/navTree");
            if (_logger.isDebugEnabled()) {
                partialUpdate.changeId = resourceUpdate.id;
                partialUpdate.timeWhenUpdateIsPushedToTheStream = System.currentTimeMillis();
                partialUpdate.timeWhenChangeIsReceived = resourceUpdate.createdOn;
            }
            this._messageSender.send((Object)partialUpdate);
        }
        catch (Exception exception) {
            _logger.error((Object)"[LiveRefresh] Navigation tree (CDC) err: ", (Throwable)exception);
        }
    }

    private void processObjectDetailsUpdates(ResourceUpdate resourceUpdate) {
        List<ResourceChange> list = resourceUpdate.changes;
        try {
            PartialUpdate partialUpdate = this._objDetailsProcessor.process(list);
            partialUpdate.setDestination("/topic/object-details");
            if (_logger.isDebugEnabled()) {
                partialUpdate.changeId = resourceUpdate.id;
                partialUpdate.timeWhenChangeIsReceived = resourceUpdate.createdOn;
                partialUpdate.timeWhenUpdateIsPushedToTheStream = System.currentTimeMillis();
            }
            this._messageSender.send((Object)partialUpdate);
        }
        catch (Exception exception) {
            _logger.error((Object)"[LiveRefresh] Object details (CDC) err: ", (Throwable)exception);
        }
    }
}

