/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.pollers;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.messaging.AlarmIssueProcessor;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.messaging.pollers.PollTask;
import com.vmware.vise.vim.messaging.pollers.Poller;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AlarmIssuePollerFactory {
    private static final Log _logger = LogFactory.getLog(AlarmIssuePollerFactory.class);
    private static final int _DEFAULT_REFRESH_RATE = 60;
    private static final String _ALARMS_REFRESH_RATE_KEY = "alarms.refresh.rate";
    private ConfigurationService _configurationService;
    private AlarmIssueProcessor<?> _alarmIssueProcessor;
    private final ThreadPoolExecutor _liveUpdatesThreadPoolExecutor;
    private final ScheduledExecutorService _pollingThreadPool;
    private final ThreadPoolExecutor _sendToWebsocketExecutor;

    public AlarmIssuePollerFactory(ThreadPoolExecutor threadPoolExecutor, ScheduledExecutorService scheduledExecutorService, ThreadPoolExecutor threadPoolExecutor2) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{threadPoolExecutor, scheduledExecutorService, threadPoolExecutor2});
        this._liveUpdatesThreadPoolExecutor = threadPoolExecutor;
        this._pollingThreadPool = scheduledExecutorService;
        this._sendToWebsocketExecutor = threadPoolExecutor2;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{configurationService});
        this._configurationService = configurationService;
    }

    public void setAlarmIssueProcessor(AlarmIssueProcessor<?> alarmIssueProcessor) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{alarmIssueProcessor});
        this._alarmIssueProcessor = alarmIssueProcessor;
    }

    public Poller createPoller(String string, final HttpServletRequest httpServletRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, httpServletRequest});
        PollTask pollTask = new PollTask(){

            @Override
            public List<PartialUpdate<?>> call() {
                try {
                    if (AlarmIssuePollerFactory.this._alarmIssueProcessor == null) {
                        List<PartialUpdate<?>> list = Collections.emptyList();
                        return list;
                    }
                    SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
                    PartialUpdate partialUpdate = AlarmIssuePollerFactory.this._alarmIssueProcessor.process();
                    if (partialUpdate.isEmpty()) {
                        List<PartialUpdate<?>> list = Collections.emptyList();
                        return list;
                    }
                    List<PartialUpdate<?>> list = Collections.singletonList(partialUpdate);
                    return list;
                }
                catch (Exception exception) {
                    _logger.error((Object)("[LiveRefresh] AlarmIssuePoller error: " + exception.getMessage()), (Throwable)exception);
                }
                finally {
                    SessionUtil.setHttpRequest(null);
                }
                return Collections.emptyList();
            }
        };
        long l = this.getRefreshRate();
        Poller poller = new Poller(pollTask, httpServletRequest, this._liveUpdatesThreadPoolExecutor, this._pollingThreadPool, this._sendToWebsocketExecutor, l, TimeUnit.SECONDS);
        return poller;
    }

    private int getRefreshRate() {
        if (this._configurationService == null) {
            return 60;
        }
        String string = this._configurationService.getProperty(_ALARMS_REFRESH_RATE_KEY);
        if (StringUtil.isNullOrEmpty((String)string)) {
            return 60;
        }
        try {
            int n = Integer.parseInt(string);
            if (n < 10 || n > 600) {
                n = 60;
            }
            return n;
        }
        catch (Exception exception) {
            return 60;
        }
    }
}

